/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.epoll.AbstractEpollServerChannel;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollServerSocketChannelConfig;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.TcpMd5Util;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.NativeInetAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel() {
        this((InternetProtocolFamily)null);
    }

    public EpollServerSocketChannel(InternetProtocolFamily internetProtocolFamily) {
        super(LinuxSocket.newSocketStream(internetProtocolFamily), false);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    public EpollServerSocketChannel(int n) {
        this(new LinuxSocket(n));
    }

    EpollServerSocketChannel(LinuxSocket linuxSocket) {
        super(linuxSocket);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    EpollServerSocketChannel(LinuxSocket linuxSocket, boolean bl) {
        super(linuxSocket, bl);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    protected final boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        int n;
        super.doBind(socketAddress);
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER && (n = this.config.getTcpFastopen()) > 0) {
            this.socket.setTcpFastOpen(n);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected final Channel newChildChannel(int n, byte[] byArray, int n2, int n3) {
        return new EpollSocketChannel((Channel)this, new LinuxSocket(n), NativeInetAddress.address((byte[])byArray, (int)n2, (int)n3));
    }

    final Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    final void setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        EpollServerSocketChannel epollServerSocketChannel = this;
        synchronized (epollServerSocketChannel) {
            this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, map);
            return;
        }
    }
}

