/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledDuplicatedByteBuf;
import io.netty.buffer.UnpooledSlicedByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String LEGACY_PROP_CHECK_ACCESSIBLE = "io.netty.buffer.bytebuf.checkAccessible";
    private static final String PROP_CHECK_ACCESSIBLE = "io.netty.buffer.checkAccessible";
    static final boolean checkAccessible = SystemPropertyUtil.contains((String)"io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean((String)"io.netty.buffer.checkAccessible", (boolean)true) : SystemPropertyUtil.getBoolean((String)"io.netty.buffer.bytebuf.checkAccessible", (boolean)true);
    private static final String PROP_CHECK_BOUNDS = "io.netty.buffer.checkBounds";
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean((String)"io.netty.buffer.checkBounds", (boolean)true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"maxCapacity");
        this.maxCapacity = n;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (((ByteBuf)this).isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n) {
        this.maxCapacity = n;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    private static void checkIndexBounds(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > n3) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n, n2, n3));
        }
    }

    @Override
    public ByteBuf readerIndex(int n) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n, this.writerIndex, this.capacity());
        }
        this.readerIndex = n;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int n) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, n, this.capacity());
        }
        this.writerIndex = n;
        return this;
    }

    @Override
    public ByteBuf setIndex(int n, int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n, n2, this.capacity());
        }
        this.setIndex0(n, n2);
        return this;
    }

    @Override
    public ByteBuf clear() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.writerIndex = 0;
        abstractByteBuf.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isReadable(int n) {
        return this.writerIndex - this.readerIndex >= n;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int n) {
        return this.capacity() - this.writerIndex >= n;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return ((ByteBuf)this).maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        AbstractByteBuf abstractByteBuf = this;
        ((ByteBuf)abstractByteBuf).readerIndex(abstractByteBuf.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        AbstractByteBuf abstractByteBuf = this;
        ((ByteBuf)abstractByteBuf).writerIndex(abstractByteBuf.markedWriterIndex);
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        if (this.readerIndex == 0) {
            this.ensureAccessible();
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            AbstractByteBuf abstractByteBuf = this;
            this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            AbstractByteBuf abstractByteBuf2 = this;
            abstractByteBuf2.adjustMarkers(abstractByteBuf2.readerIndex);
            this.readerIndex = 0;
        } else {
            this.ensureAccessible();
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
            AbstractByteBuf abstractByteBuf3 = this;
            abstractByteBuf3.readerIndex = 0;
            abstractByteBuf3.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        if (this.readerIndex > 0) {
            if (this.readerIndex == this.writerIndex) {
                this.ensureAccessible();
                AbstractByteBuf abstractByteBuf = this;
                abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
                AbstractByteBuf abstractByteBuf2 = this;
                abstractByteBuf2.readerIndex = 0;
                abstractByteBuf2.writerIndex = 0;
                return this;
            }
            if (this.readerIndex >= this.capacity() >>> 1) {
                AbstractByteBuf abstractByteBuf = this;
                this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
                this.writerIndex -= this.readerIndex;
                AbstractByteBuf abstractByteBuf3 = this;
                abstractByteBuf3.adjustMarkers(abstractByteBuf3.readerIndex);
                this.readerIndex = 0;
                return this;
            }
        }
        this.ensureAccessible();
        return this;
    }

    protected final void adjustMarkers(int n) {
        if (this.markedReaderIndex <= n) {
            this.markedReaderIndex = 0;
            if (this.markedWriterIndex <= n) {
                this.markedWriterIndex = 0;
                return;
            }
            this.markedWriterIndex -= n;
            return;
        }
        this.markedReaderIndex -= n;
        this.markedWriterIndex -= n;
    }

    protected final void trimIndicesToCapacity(int n) {
        if (((ByteBuf)this).writerIndex() > n) {
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.setIndex0(Math.min(((ByteBuf)abstractByteBuf).readerIndex(), n), n);
        }
    }

    @Override
    public ByteBuf ensureWritable(int n) {
        this.ensureWritable0(ObjectUtil.checkPositiveOrZero((int)n, (String)"minWritableBytes"));
        return this;
    }

    final void ensureWritable0(int n) {
        int n2 = ((ByteBuf)this).writerIndex();
        int n3 = n2 + n;
        if (n3 >= 0 & n3 <= this.capacity()) {
            this.ensureAccessible();
            return;
        }
        if (checkBounds && (n3 < 0 || n3 > this.maxCapacity)) {
            this.ensureAccessible();
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", n2, n, this.maxCapacity, this));
        }
        int n4 = this.maxFastWritableBytes();
        n = n4 >= n ? n2 + n4 : this.alloc().calculateNewCapacity(n3, this.maxCapacity);
        this.capacity(n);
    }

    @Override
    public int ensureWritable(int n, boolean n2) {
        int n3;
        this.ensureAccessible();
        ObjectUtil.checkPositiveOrZero((int)n, (String)"minWritableBytes");
        if (n <= ((ByteBuf)this).writableBytes()) {
            return 0;
        }
        int n4 = ((ByteBuf)this).maxCapacity();
        if (n > n4 - (n3 = ((ByteBuf)this).writerIndex())) {
            if (n2 == 0 || this.capacity() == n4) {
                return 1;
            }
            this.capacity(n4);
            return 3;
        }
        n2 = this.maxFastWritableBytes();
        n = n2 >= n ? n3 + n2 : this.alloc().calculateNewCapacity(n3 + n, n4);
        this.capacity(n);
        return 2;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == this.order()) {
            return this;
        }
        ObjectUtil.checkNotNull((Object)byteOrder, (String)"endianness");
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int n) {
        this.checkIndex(n);
        return this._getByte(n);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public boolean getBoolean(int n) {
        return ((ByteBuf)this).getByte(n) != 0;
    }

    @Override
    public short getUnsignedByte(int n) {
        return (short)(((ByteBuf)this).getByte(n) & 0xFF);
    }

    @Override
    public short getShort(int n) {
        this.checkIndex(n, 2);
        return this._getShort(n);
    }

    protected abstract short _getShort(int var1);

    @Override
    public short getShortLE(int n) {
        this.checkIndex(n, 2);
        return this._getShortLE(n);
    }

    protected abstract short _getShortLE(int var1);

    @Override
    public int getUnsignedShort(int n) {
        return ((ByteBuf)this).getShort(n) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int n) {
        return ((ByteBuf)this).getShortLE(n) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int n) {
        this.checkIndex(n, 3);
        return this._getUnsignedMedium(n);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getUnsignedMediumLE(int n) {
        this.checkIndex(n, 3);
        return this._getUnsignedMediumLE(n);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    @Override
    public int getMedium(int n) {
        if (((n = ((ByteBuf)this).getUnsignedMedium(n)) & 0x800000) != 0) {
            n |= 0xFF000000;
        }
        return n;
    }

    @Override
    public int getMediumLE(int n) {
        if (((n = ((ByteBuf)this).getUnsignedMediumLE(n)) & 0x800000) != 0) {
            n |= 0xFF000000;
        }
        return n;
    }

    @Override
    public int getInt(int n) {
        this.checkIndex(n, 4);
        return this._getInt(n);
    }

    protected abstract int _getInt(int var1);

    @Override
    public int getIntLE(int n) {
        this.checkIndex(n, 4);
        return this._getIntLE(n);
    }

    protected abstract int _getIntLE(int var1);

    @Override
    public long getUnsignedInt(int n) {
        return (long)((ByteBuf)this).getInt(n) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int n) {
        return (long)((ByteBuf)this).getIntLE(n) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n) {
        this.checkIndex(n, 8);
        return this._getLong(n);
    }

    protected abstract long _getLong(int var1);

    @Override
    public long getLongLE(int n) {
        this.checkIndex(n, 8);
        return this._getLongLE(n);
    }

    protected abstract long _getLongLE(int var1);

    @Override
    public char getChar(int n) {
        return (char)((ByteBuf)this).getShort(n);
    }

    @Override
    public float getFloat(int n) {
        return Float.intBitsToFloat(((ByteBuf)this).getInt(n));
    }

    @Override
    public double getDouble(int n) {
        return Double.longBitsToDouble(((ByteBuf)this).getLong(n));
    }

    @Override
    public ByteBuf getBytes(int n, byte[] byArray) {
        this.getBytes(n, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).getBytes(n, byteBuf2, byteBuf2.writableBytes());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf;
        this.getBytes(n, byteBuf2, byteBuf2.writerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.writerIndex() + n2);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int n, int n2, Charset charset) {
        if (CharsetUtil.US_ASCII.equals(charset) || CharsetUtil.ISO_8859_1.equals(charset)) {
            return new AsciiString(ByteBufUtil.getBytes(this, n, n2, true), false);
        }
        return ((ByteBuf)this).toString(n, n2, charset);
    }

    @Override
    public CharSequence readCharSequence(int n, Charset object) {
        AbstractByteBuf abstractByteBuf = this;
        object = ((ByteBuf)abstractByteBuf).getCharSequence(abstractByteBuf.readerIndex, n, (Charset)object);
        this.readerIndex += n;
        return object;
    }

    @Override
    public ByteBuf setByte(int n, int n2) {
        this.checkIndex(n);
        this._setByte(n, n2);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setBoolean(int n, boolean bl) {
        ((ByteBuf)this).setByte(n, bl ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf setShort(int n, int n2) {
        this.checkIndex(n, 2);
        this._setShort(n, n2);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setShortLE(int n, int n2) {
        this.checkIndex(n, 2);
        this._setShortLE(n, n2);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    @Override
    public ByteBuf setChar(int n, int n2) {
        ((ByteBuf)this).setShort(n, n2);
        return this;
    }

    @Override
    public ByteBuf setMedium(int n, int n2) {
        this.checkIndex(n, 3);
        this._setMedium(n, n2);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setMediumLE(int n, int n2) {
        this.checkIndex(n, 3);
        this._setMediumLE(n, n2);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    @Override
    public ByteBuf setInt(int n, int n2) {
        this.checkIndex(n, 4);
        this._setInt(n, n2);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setIntLE(int n, int n2) {
        this.checkIndex(n, 4);
        this._setIntLE(n, n2);
        return this;
    }

    protected abstract void _setIntLE(int var1, int var2);

    @Override
    public ByteBuf setFloat(int n, float f) {
        ((ByteBuf)this).setInt(n, Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public ByteBuf setLong(int n, long l) {
        this.checkIndex(n, 8);
        this._setLong(n, l);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public ByteBuf setLongLE(int n, long l) {
        this.checkIndex(n, 8);
        this._setLongLE(n, l);
        return this;
    }

    protected abstract void _setLongLE(int var1, long var2);

    @Override
    public ByteBuf setDouble(int n, double d) {
        ((ByteBuf)this).setLong(n, Double.doubleToRawLongBits(d));
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, byte[] byArray) {
        this.setBytes(n, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).setBytes(n, byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    private static void checkReadableBounds(ByteBuf byteBuf, int n) {
        if (n > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n, byteBuf.readableBytes(), byteBuf));
        }
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        this.checkIndex(n, n2);
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"src");
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n2);
        }
        ByteBuf byteBuf2 = byteBuf;
        this.setBytes(n, byteBuf2, byteBuf2.readerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.readerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf setZero(int n, int n2) {
        if (n2 == 0) {
            return this;
        }
        this.checkIndex(n, n2);
        int n3 = n2 >>> 3;
        n2 &= 7;
        while (n3 > 0) {
            this._setLong(n, 0L);
            n += 8;
            --n3;
        }
        if (n2 == 4) {
            this._setInt(n, 0);
        } else if (n2 < 4) {
            for (n3 = n2; n3 > 0; --n3) {
                this._setByte(n, 0);
                ++n;
            }
        } else {
            this._setInt(n, 0);
            n += 4;
            for (n3 = n2 - 4; n3 > 0; --n3) {
                this._setByte(n, 0);
                ++n;
            }
        }
        return this;
    }

    @Override
    public int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        return this.setCharSequence0(n, charSequence, charset, false);
    }

    private int setCharSequence0(int n, CharSequence charSequence, Charset object, boolean bl) {
        if (((Charset)object).equals(CharsetUtil.UTF_8)) {
            int n2 = ByteBufUtil.utf8MaxBytes(charSequence);
            if (bl) {
                this.ensureWritable0(n2);
                this.checkIndex0(n, n2);
            } else {
                this.checkIndex(n, n2);
            }
            CharSequence charSequence2 = charSequence;
            return ByteBufUtil.writeUtf8(this, n, n2, charSequence2, charSequence2.length());
        }
        if (((Charset)object).equals(CharsetUtil.US_ASCII) || ((Charset)object).equals(CharsetUtil.ISO_8859_1)) {
            int n3 = charSequence.length();
            if (bl) {
                this.ensureWritable0(n3);
                this.checkIndex0(n, n3);
            } else {
                this.checkIndex(n, n3);
            }
            return ByteBufUtil.writeAscii(this, n, charSequence, n3);
        }
        object = charSequence.toString().getBytes((Charset)object);
        if (bl) {
            this.ensureWritable0(((Object)object).length);
        }
        ((ByteBuf)this).setBytes(n, (byte[])object);
        return ((Object)object).length;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int n = this.readerIndex;
        byte by = this._getByte(n);
        this.readerIndex = n + 1;
        return by;
    }

    @Override
    public boolean readBoolean() {
        return ((ByteBuf)this).readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(((ByteBuf)this).readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short s = abstractByteBuf._getShort(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return s;
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short s = abstractByteBuf._getShortLE(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return s;
    }

    @Override
    public int readUnsignedShort() {
        return ((ByteBuf)this).readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return ((ByteBuf)this).readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int n = ((ByteBuf)this).readUnsignedMedium();
        if ((n & 0x800000) != 0) {
            n |= 0xFF000000;
        }
        return n;
    }

    @Override
    public int readMediumLE() {
        int n = ((ByteBuf)this).readUnsignedMediumLE();
        if ((n & 0x800000) != 0) {
            n |= 0xFF000000;
        }
        return n;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int n = abstractByteBuf._getUnsignedMedium(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return n;
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int n = abstractByteBuf._getUnsignedMediumLE(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return n;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int n = abstractByteBuf._getInt(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return n;
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int n = abstractByteBuf._getIntLE(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return n;
    }

    @Override
    public long readUnsignedInt() {
        return (long)((ByteBuf)this).readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)((ByteBuf)this).readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long l = abstractByteBuf._getLong(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return l;
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long l = abstractByteBuf._getLongLE(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return l;
    }

    @Override
    public char readChar() {
        return (char)((ByteBuf)this).readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(((ByteBuf)this).readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(((ByteBuf)this).readLong());
    }

    @Override
    public ByteBuf readBytes(int n) {
        this.checkReadableBytes(n);
        if (n == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n, this.maxCapacity);
        AbstractByteBuf abstractByteBuf = this;
        byteBuf.writeBytes(abstractByteBuf, abstractByteBuf.readerIndex, n);
        this.readerIndex += n;
        return byteBuf;
    }

    @Override
    public ByteBuf readSlice(int n) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf byteBuf = ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, n);
        this.readerIndex += n;
        return byteBuf;
    }

    @Override
    public ByteBuf readRetainedSlice(int n) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf byteBuf = ((ByteBuf)abstractByteBuf).retainedSlice(abstractByteBuf.readerIndex, n);
        this.readerIndex += n;
        return byteBuf;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n, int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byArray, n, n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        ((ByteBuf)this).readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).readBytes(byteBuf2, byteBuf2.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n) {
        if (checkBounds && n > byteBuf.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", n, byteBuf.writableBytes(), byteBuf));
        }
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).readBytes(byteBuf2, byteBuf2.writerIndex(), n);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.writerIndex() + n);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byteBuf, n, n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byteBuffer);
        this.readerIndex += n;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, gatheringByteChannel, n);
        this.readerIndex += n2;
        return n2;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l, int n) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, fileChannel, l, n);
        this.readerIndex += n2;
        return n2;
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, outputStream, n);
        this.readerIndex += n;
        return this;
    }

    @Override
    public ByteBuf skipBytes(int n) {
        this.checkReadableBytes(n);
        this.readerIndex += n;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl) {
        ((ByteBuf)this).writeByte(bl ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n) {
        this.ensureWritable0(1);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setByte(abstractByteBuf.writerIndex++, n);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n) {
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShort(abstractByteBuf.writerIndex, n);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int n) {
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShortLE(abstractByteBuf.writerIndex, n);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n) {
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMedium(abstractByteBuf.writerIndex, n);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int n) {
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMediumLE(abstractByteBuf.writerIndex, n);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int n) {
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setInt(abstractByteBuf.writerIndex, n);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int n) {
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setIntLE(abstractByteBuf.writerIndex, n);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long l) {
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLong(abstractByteBuf.writerIndex, l);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long l) {
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLongLE(abstractByteBuf.writerIndex, l);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int n) {
        ((ByteBuf)this).writeShort(n);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f) {
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d) {
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits(d));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        ((ByteBuf)this).ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byArray, n, n2);
        this.writerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        ((ByteBuf)this).writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).writeBytes(byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n);
        }
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).writeBytes(byteBuf2, byteBuf2.readerIndex(), n);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.readerIndex() + n);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        ((ByteBuf)this).ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuf, n, n2);
        this.writerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.ensureWritable0(n);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuffer);
        this.writerIndex += n;
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n) {
        ((ByteBuf)this).ensureWritable(n);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, inputStream, n);
        if (n2 > 0) {
            this.writerIndex += n2;
        }
        return n2;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) {
        ((ByteBuf)this).ensureWritable(n);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, scatteringByteChannel, n);
        if (n2 > 0) {
            this.writerIndex += n2;
        }
        return n2;
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l, int n) {
        ((ByteBuf)this).ensureWritable(n);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, fileChannel, l, n);
        if (n2 > 0) {
            this.writerIndex += n2;
        }
        return n2;
    }

    @Override
    public ByteBuf writeZero(int n) {
        if (n == 0) {
            return this;
        }
        ((ByteBuf)this).ensureWritable(n);
        int n2 = this.writerIndex;
        this.checkIndex0(n2, n);
        int n3 = n >>> 3;
        n &= 7;
        while (n3 > 0) {
            this._setLong(n2, 0L);
            n2 += 8;
            --n3;
        }
        if (n == 4) {
            this._setInt(n2, 0);
            n2 += 4;
        } else if (n < 4) {
            for (n3 = n; n3 > 0; --n3) {
                this._setByte(n2, 0);
                ++n2;
            }
        } else {
            this._setInt(n2, 0);
            n2 += 4;
            for (n3 = n - 4; n3 > 0; --n3) {
                this._setByte(n2, 0);
                ++n2;
            }
        }
        this.writerIndex = n2;
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        AbstractByteBuf abstractByteBuf = this;
        int n = abstractByteBuf.setCharSequence0(abstractByteBuf.writerIndex, charSequence, charset, true);
        this.writerIndex += n;
        return n;
    }

    @Override
    public ByteBuf copy() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.copy(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return ((ByteBuf)this).duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return ((ByteBuf)this).slice().retain();
    }

    @Override
    public ByteBuf slice(int n, int n2) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, n, n2);
    }

    @Override
    public ByteBuf retainedSlice(int n, int n2) {
        return ((ByteBuf)this).slice(n, n2).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffer(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffers(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).toString(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes(), charset);
    }

    @Override
    public String toString(int n, int n2, Charset charset) {
        return ByteBufUtil.decodeString(this, n, n2, charset);
    }

    @Override
    public int indexOf(int n, int n2, byte by) {
        if (n <= n2) {
            return ByteBufUtil.firstIndexOf(this, n, n2, by);
        }
        return ByteBufUtil.lastIndexOf(this, n, n2, by);
    }

    @Override
    public int bytesBefore(byte by) {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), ((ByteBuf)this).readableBytes(), by);
    }

    @Override
    public int bytesBefore(int n, byte by) {
        this.checkReadableBytes(n);
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), n, by);
    }

    @Override
    public int bytesBefore(int n, int n2, byte by) {
        int n3 = n;
        if ((n2 = ((ByteBuf)this).indexOf(n3, n3 + n2, by)) < 0) {
            return -1;
        }
        return n2 - n;
    }

    @Override
    public int forEachByte(ByteProcessor object) {
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteAsc0(abstractByteBuf.readerIndex, this.writerIndex, (ByteProcessor)object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        try {
            int n3 = n;
            return this.forEachByteAsc0(n3, n3 + n2, byteProcessor);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    int forEachByteAsc0(int n, int n2, ByteProcessor byteProcessor) {
        while (n < n2) {
            if (!byteProcessor.process(this._getByte(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor object) {
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteDesc0(abstractByteBuf.writerIndex - 1, this.readerIndex, (ByteProcessor)object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    @Override
    public int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        try {
            return this.forEachByteDesc0(n + n2 - 1, n, byteProcessor);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException((Throwable)exception);
            return -1;
        }
    }

    int forEachByteDesc0(int n, int n2, ByteProcessor byteProcessor) {
        while (n >= n2) {
            if (!byteProcessor.process(this._getByte(n))) {
                return n;
            }
            --n;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)object);
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName((Object)this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n) {
        this.checkIndex(n, 1);
    }

    protected final void checkIndex(int n, int n2) {
        this.ensureAccessible();
        this.checkIndex0(n, n2);
    }

    private static void checkRangeBounds(String string, int n, int n2, int n3) {
        if (MathUtil.isOutOfBounds((int)n, (int)n2, (int)n3)) {
            throw new IndexOutOfBoundsException(String.format("%s: %d, length: %d (expected: range(0, %d))", string, n, n2, n3));
        }
    }

    final void checkIndex0(int n, int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("index", n, n2, this.capacity());
        }
    }

    protected final void checkSrcIndex(int n, int n2, int n3, int n4) {
        this.checkIndex(n, n2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("srcIndex", n3, n2, n4);
        }
    }

    protected final void checkDstIndex(int n, int n2, int n3, int n4) {
        this.checkIndex(n, n2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n3, n2, n4);
        }
    }

    protected final void checkDstIndex(int n, int n2, int n3) {
        this.checkReadableBytes(n);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n2, n, n3);
        }
    }

    protected final void checkReadableBytes(int n) {
        this.checkReadableBytes0(ObjectUtil.checkPositiveOrZero((int)n, (String)"minimumReadableBytes"));
    }

    protected final void checkNewCapacity(int n) {
        this.ensureAccessible();
        if (checkBounds && (n < 0 || n > ((ByteBuf)this).maxCapacity())) {
            throw new IllegalArgumentException("newCapacity: " + n + " (expected: 0-" + ((ByteBuf)this).maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int n) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - n) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && !this.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n, int n2) {
        this.readerIndex = n;
        this.writerIndex = n2;
    }

    final void discardMarks() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.markedWriterIndex = 0;
        abstractByteBuf.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_CHECK_ACCESSIBLE, (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)PROP_CHECK_BOUNDS, (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

