/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    AbstractUnsafeSwappedByteBuf(AbstractByteBuf abstractByteBuf) {
        super(abstractByteBuf);
        assert (PlatformDependent.isUnaligned());
        this.wrapped = abstractByteBuf;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public final long getLong(int n) {
        this.wrapped.checkIndex(n, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        long l = abstractUnsafeSwappedByteBuf._getLong(abstractUnsafeSwappedByteBuf.wrapped, n);
        if (this.nativeByteOrder) {
            return l;
        }
        return Long.reverseBytes(l);
    }

    @Override
    public final float getFloat(int n) {
        return Float.intBitsToFloat(((ByteBuf)this).getInt(n));
    }

    @Override
    public final double getDouble(int n) {
        return Double.longBitsToDouble(((ByteBuf)this).getLong(n));
    }

    @Override
    public final char getChar(int n) {
        return (char)((ByteBuf)this).getShort(n);
    }

    @Override
    public final long getUnsignedInt(int n) {
        return (long)((ByteBuf)this).getInt(n) & 0xFFFFFFFFL;
    }

    @Override
    public final int getInt(int n) {
        this.wrapped.checkIndex(n, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        n = abstractUnsafeSwappedByteBuf._getInt(abstractUnsafeSwappedByteBuf.wrapped, n);
        if (this.nativeByteOrder) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    @Override
    public final int getUnsignedShort(int n) {
        return ((ByteBuf)this).getShort(n) & 0xFFFF;
    }

    @Override
    public final short getShort(int n) {
        this.wrapped.checkIndex(n, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        n = abstractUnsafeSwappedByteBuf._getShort(abstractUnsafeSwappedByteBuf.wrapped, n);
        if (this.nativeByteOrder) {
            return (short)n;
        }
        return Short.reverseBytes((short)n);
    }

    @Override
    public final ByteBuf setShort(int n, int n2) {
        this.wrapped.checkIndex(n, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, n, this.nativeByteOrder ? (short)n2 : Short.reverseBytes((short)n2));
        return this;
    }

    @Override
    public final ByteBuf setInt(int n, int n2) {
        this.wrapped.checkIndex(n, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, n, this.nativeByteOrder ? n2 : Integer.reverseBytes(n2));
        return this;
    }

    @Override
    public final ByteBuf setLong(int n, long l) {
        this.wrapped.checkIndex(n, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, n, this.nativeByteOrder ? l : Long.reverseBytes(l));
        return this;
    }

    @Override
    public final ByteBuf setChar(int n, int n2) {
        ((ByteBuf)this).setShort(n, n2);
        return this;
    }

    @Override
    public final ByteBuf setFloat(int n, float f) {
        ((ByteBuf)this).setInt(n, Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public final ByteBuf setDouble(int n, double d) {
        ((ByteBuf)this).setLong(n, Double.doubleToRawLongBits(d));
        return this;
    }

    @Override
    public final ByteBuf writeShort(int n) {
        this.wrapped.ensureWritable0(2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)n : Short.reverseBytes((short)n));
        this.wrapped.writerIndex += 2;
        return this;
    }

    @Override
    public final ByteBuf writeInt(int n) {
        this.wrapped.ensureWritable0(4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? n : Integer.reverseBytes(n));
        this.wrapped.writerIndex += 4;
        return this;
    }

    @Override
    public final ByteBuf writeLong(long l) {
        this.wrapped.ensureWritable0(8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? l : Long.reverseBytes(l));
        this.wrapped.writerIndex += 8;
        return this;
    }

    @Override
    public final ByteBuf writeChar(int n) {
        ((ByteBuf)this).writeShort(n);
        return this;
    }

    @Override
    public final ByteBuf writeFloat(float f) {
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public final ByteBuf writeDouble(double d) {
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits(d));
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

