/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.UIDefaultsLoader;
import com.formdev.flatlaf.json.Json;
import com.formdev.flatlaf.json.ParseException;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class IntelliJTheme {
    public final String name;
    public final boolean dark;
    public final String author;
    private final boolean isMaterialUILite;
    private Map<String, String> colors;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private Map<String, ColorUIResource> namedColors = Collections.emptyMap();
    private static final Set<String> uiKeyExcludes;
    private static final Set<String> uiKeyDoNotOverride;
    private static final Map<String, String> uiKeyMapping;
    private static final Map<String, String> uiKeyCopying;
    private static final Map<String, String> uiKeyInverseMapping;
    private static final Map<String, String> checkboxKeyMapping;
    private static final Map<String, String> checkboxDuplicateColors;

    public static boolean setup(InputStream inputStream) {
        try {
            return FlatLaf.setup(IntelliJTheme.createLaf(inputStream));
        }
        catch (Exception exception) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load IntelliJ theme", exception);
            return false;
        }
    }

    @Deprecated
    public static boolean install(InputStream inputStream) {
        return IntelliJTheme.setup(inputStream);
    }

    public static FlatLaf createLaf(InputStream inputStream) {
        return IntelliJTheme.createLaf(new IntelliJTheme(inputStream));
    }

    public static FlatLaf createLaf(IntelliJTheme intelliJTheme) {
        return new ThemeLaf(intelliJTheme);
    }

    public IntelliJTheme(InputStream object) {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, StandardCharsets.UTF_8);){
            object = (Map)Json.parse(inputStreamReader);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage(), parseException);
        }
        this.name = (String)object.get("name");
        this.dark = Boolean.parseBoolean((String)object.get("dark"));
        this.author = (String)object.get("author");
        this.isMaterialUILite = this.author.equals("Mallowigi");
        this.colors = (Map)object.get("colors");
        this.ui = (Map)object.get("ui");
        this.icons = (Map)object.get("icons");
    }

    /*
     * WARNING - void declaration
     */
    private void applyProperties(UIDefaults uIDefaults) {
        int n;
        void var6_22;
        if (this.ui == null) {
            return;
        }
        uIDefaults.put("Component.isIntelliJTheme", Boolean.TRUE);
        uIDefaults.put("Button.paintShadow", Boolean.TRUE);
        uIDefaults.put("Button.shadowWidth", (Object)(this.dark ? 2 : 1));
        Map<Object, Object> map = this.removeThemeSpecificDefaults(uIDefaults);
        this.loadNamedColors(uIDefaults);
        Object object2 = new ArrayList<Object>();
        Object object3 = new HashSet<String>();
        for (Map.Entry<String, Object> entry : this.ui.entrySet()) {
            this.apply(entry.getKey(), entry.getValue(), uIDefaults, (ArrayList<Object>)object2, (Set<String>)object3);
        }
        this.applyColorPalette(uIDefaults);
        this.applyCheckBoxColors(uIDefaults);
        for (Map.Entry<String, String> entry : uiKeyCopying.entrySet()) {
            object2 = uIDefaults.get(entry.getValue());
            if (object2 == null) continue;
            uIDefaults.put(entry.getKey(), object2);
        }
        Object object = uIDefaults.get("Panel.background");
        uIDefaults.put("Button.disabledBackground", object);
        uIDefaults.put("ToggleButton.disabledBackground", object);
        this.copyIfNotSet(uIDefaults, "Button.focusedBorderColor", "Component.focusedBorderColor", (Set<String>)object3);
        uIDefaults.put("Button.hoverBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        uIDefaults.put("HelpButton.hoverBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        Object object4 = uIDefaults.get("Button.startBackground");
        object2 = uIDefaults.get("Button.startBorderColor");
        if (object4 == null) {
            Object object5 = uIDefaults.get("Button.background");
        }
        if (object2 == null) {
            object2 = uIDefaults.get("Button.borderColor");
        }
        uIDefaults.put("HelpButton.background", (Object)var6_22);
        uIDefaults.put("HelpButton.borderColor", object2);
        uIDefaults.put("HelpButton.disabledBackground", object);
        uIDefaults.put("HelpButton.disabledBorderColor", uIDefaults.get("Button.disabledBorderColor"));
        uIDefaults.put("HelpButton.focusedBorderColor", uIDefaults.get("Button.focusedBorderColor"));
        uIDefaults.put("HelpButton.focusedBackground", uIDefaults.get("Button.focusedBackground"));
        object2 = this.get(uIDefaults, map, "TextField.background");
        uIDefaults.put("ComboBox.editableBackground", object2);
        uIDefaults.put("Spinner.background", object2);
        uIDefaults.put("Spinner.buttonBackground", uIDefaults.get("ComboBox.buttonEditableBackground"));
        uIDefaults.put("Spinner.buttonArrowColor", uIDefaults.get("ComboBox.buttonArrowColor"));
        uIDefaults.put("Spinner.buttonDisabledArrowColor", uIDefaults.get("ComboBox.buttonDisabledArrowColor"));
        this.putAll(uIDefaults, object2, "EditorPane.background", "FormattedTextField.background", "PasswordField.background", "TextArea.background", "TextPane.background");
        this.putAll(uIDefaults, this.get(uIDefaults, map, "TextField.selectionBackground"), "EditorPane.selectionBackground", "FormattedTextField.selectionBackground", "PasswordField.selectionBackground", "TextArea.selectionBackground", "TextPane.selectionBackground");
        this.putAll(uIDefaults, this.get(uIDefaults, map, "TextField.selectionForeground"), "EditorPane.selectionForeground", "FormattedTextField.selectionForeground", "PasswordField.selectionForeground", "TextArea.selectionForeground", "TextPane.selectionForeground");
        this.putAll(uIDefaults, object, "ComboBox.disabledBackground", "EditorPane.disabledBackground", "EditorPane.inactiveBackground", "FormattedTextField.disabledBackground", "FormattedTextField.inactiveBackground", "PasswordField.disabledBackground", "PasswordField.inactiveBackground", "Spinner.disabledBackground", "TextArea.disabledBackground", "TextArea.inactiveBackground", "TextField.disabledBackground", "TextField.inactiveBackground", "TextPane.disabledBackground", "TextPane.inactiveBackground");
        if (!object3.contains("ToggleButton.startBackground") && !object3.contains("*.startBackground")) {
            uIDefaults.put("ToggleButton.startBackground", uIDefaults.get("Button.startBackground"));
        }
        if (!object3.contains("ToggleButton.endBackground") && !object3.contains("*.endBackground")) {
            uIDefaults.put("ToggleButton.endBackground", uIDefaults.get("Button.endBackground"));
        }
        if (!object3.contains("ToggleButton.foreground") && object3.contains("Button.foreground")) {
            uIDefaults.put("ToggleButton.foreground", uIDefaults.get("Button.foreground"));
        }
        object2 = uIDefaults.getColor("Panel.background");
        object2 = ColorFunctions.applyFunctions((Color)object2, new ColorFunctions.HSLIncreaseDecrease(2, this.dark, 5.0f, false, true));
        uIDefaults.put("Desktop.background", new ColorUIResource((Color)object2));
        if (this.isMaterialUILite) {
            uIDefaults.put("List.background", uIDefaults.get("Tree.background"));
            uIDefaults.put("Table.background", uIDefaults.get("Tree.background"));
        }
        if ((n = uIDefaults.getInt("Tree.rowHeight")) > 22) {
            uIDefaults.put("Tree.rowHeight", (Object)22);
        }
        HashMap hashMap = new HashMap();
        object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry entry = (Map.Entry)object3.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("*.")) continue;
            hashMap.put(string.substring(2), entry.getValue());
            object3.remove();
        }
        if (!hashMap.isEmpty()) {
            for (Object object6 : uIDefaults.keySet().toArray()) {
                int n2;
                if (!(object6 instanceof String) || (n2 = ((String)object6).lastIndexOf(46)) < 0) continue;
                String string = ((String)object6).substring(n2 + 1);
                if ((string = hashMap.get(string)) == null) continue;
                uIDefaults.put(object6, string);
            }
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object object7;
            Object object6;
            Object k = entry.getKey();
            object6 = entry.getValue();
            if (k instanceof String && ((String)k).startsWith("[style]") && (object7 = uIDefaults.get(k)) != null) {
                object6 = object7 + "; " + object6;
            }
            uIDefaults.put(k, object6);
        }
        this.colors = null;
        this.ui = null;
        this.icons = null;
    }

    private Object get(UIDefaults uIDefaults, Map<Object, Object> map, String string) {
        return map.getOrDefault(string, uIDefaults.get(string));
    }

    private void putAll(UIDefaults uIDefaults, Object object, String ... stringArray) {
        for (String string : stringArray) {
            uIDefaults.put(string, object);
        }
    }

    private Map<Object, Object> removeThemeSpecificDefaults(UIDefaults uIDefaults) {
        Object object3;
        Object object2 = new ArrayList<String>();
        for (Object object3 : uIDefaults.keySet()) {
            if (!(object3 instanceof String) || !((String)object3).startsWith("[") || ((String)object3).startsWith("[style]")) continue;
            ((ArrayList)object2).add((String)object3);
        }
        HashMap hashMap = new HashMap();
        object3 = "[" + this.name.replace(' ', '_') + ']';
        String string = "[" + this.name.replace(' ', '_') + "---" + this.author.replace(' ', '_') + ']';
        String string2 = "[author-" + this.author.replace(' ', '_') + ']';
        Object object4 = "[*]";
        object3 = new String[]{object3, string, string2, object4};
        object2 = ((ArrayList)object2).iterator();
        block1: while (object2.hasNext()) {
            string = (String)object2.next();
            string2 = uIDefaults.remove(string);
            object4 = object3;
            int cfr_ignored_0 = ((K)object4).length;
            for (int i = 0; i < 4; ++i) {
                Object object5 = object4[i];
                if (!string.startsWith((String)object5)) continue;
                hashMap.put(string.substring(((String)object5).length()), string2);
                continue block1;
            }
        }
        return hashMap;
    }

    private void loadNamedColors(UIDefaults uIDefaults) {
        if (this.colors == null) {
            return;
        }
        this.namedColors = new HashMap<String, ColorUIResource>();
        for (Map.Entry<String, String> entry : this.colors.entrySet()) {
            Object object = entry.getValue();
            if ((object = this.parseColor((String)object)) == null) continue;
            String string = entry.getKey();
            this.namedColors.put(string, (ColorUIResource)object);
            uIDefaults.put("ColorPalette." + string, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void apply(String object, Object object2, UIDefaults uIDefaults, ArrayList<Object> object3, Set<String> list) {
        block23: {
            void var6_13;
            block19: {
                block22: {
                    Map object4;
                    block20: {
                        block21: {
                            if (!(object2 instanceof Map)) break block19;
                            object4 = (Map)object2;
                            if (!object4.containsKey("os.default") && !object4.containsKey("os.windows") && !object4.containsKey("os.mac") && !object4.containsKey("os.linux")) break block20;
                            if ((SystemInfo.isWindows ? "os.windows" : (SystemInfo.isMacOS ? "os.mac" : (object2 = SystemInfo.isLinux ? "os.linux" : null))) == null || !object4.containsKey(object2)) break block21;
                            this.apply((String)object, object4.get(object2), uIDefaults, (ArrayList<Object>)object3, (Set<String>)((Object)list));
                            break block22;
                        }
                        if (object4.containsKey("os.default")) {
                            this.apply((String)object, object4.get("os.default"), uIDefaults, (ArrayList<Object>)object3, (Set<String>)((Object)list));
                        }
                        break block23;
                    }
                    for (Map.Entry object5 : object4.entrySet()) {
                        this.apply((String)object + '.' + (String)object5.getKey(), object5.getValue(), uIDefaults, (ArrayList<Object>)object3, (Set<String>)((Object)list));
                    }
                }
                return;
            }
            if ("".equals(object2)) {
                return;
            }
            if (((String)object).endsWith(".border") || ((String)object).endsWith(".rowHeight") || ((String)object).equals("ComboBox.padding") || ((String)object).equals("Spinner.padding") || ((String)object).equals("Tree.leftChildIndent") || ((String)object).equals("Tree.rightChildIndent")) {
                return;
            }
            Iterator iterator = object;
            object = uiKeyMapping.getOrDefault(iterator, (String)((Object)iterator));
            if (((String)object).isEmpty()) {
                return;
            }
            int n = ((String)object).indexOf(46);
            if (n > 0 && uiKeyExcludes.contains(((String)object).substring(0, n + 1))) {
                return;
            }
            if (uiKeyDoNotOverride.contains(object) && list.contains(object)) {
                return;
            }
            list.add((String)object);
            object2 = object2.toString();
            ColorUIResource colorUIResource = this.namedColors.get(object2);
            if (colorUIResource == null) {
                if (!((String)object2).startsWith("#") && (((String)object).endsWith("ground") || ((String)object).endsWith("Color"))) {
                    object2 = this.fixColorIfValid("#" + (String)object2, (String)object2);
                } else if (((String)object2).startsWith("##")) {
                    object2 = this.fixColorIfValid(((String)object2).substring(1), (String)object2);
                } else if ((((String)object).endsWith(".border") || ((String)object).endsWith("Border")) && (list = StringUtils.split((String)object2, ',')).size() == 5 && !list.get(4).startsWith("#")) {
                    list.set(4, "#" + list.get(4));
                    object2 = String.join((CharSequence)",", list);
                }
                try {
                    Object object4 = UIDefaultsLoader.parseValue(object, (String)object2, null);
                }
                catch (RuntimeException runtimeException) {
                    UIDefaultsLoader.logParseError((String)object, (String)object2, runtimeException, false);
                    return;
                }
            }
            if (((String)object).startsWith("*.")) {
                list = ((String)object).substring(1);
                if (((ArrayList)object3).size() != uIDefaults.size()) {
                    ((ArrayList)object3).clear();
                    object = uIDefaults.keys();
                    while (object.hasMoreElements()) {
                        ((ArrayList)object3).add(object.nextElement());
                    }
                }
                object = ((ArrayList)object3).iterator();
                while (object.hasNext()) {
                    object2 = object.next();
                    if (object2.equals("Desktop.background") || object2.equals("DesktopIcon.background") || object2.equals("TabbedPane.focusColor") || !(object2 instanceof String)) continue;
                    Object object5 = object2;
                    object3 = uiKeyInverseMapping.getOrDefault(object5, (String)object5);
                    if (!((String)object3).endsWith((String)((Object)list)) || ((String)object2).startsWith("CheckBox.icon.")) continue;
                    uIDefaults.put(object2, (Object)var6_13);
                }
                return;
            }
            uIDefaults.put(object, (Object)var6_13);
        }
    }

    private String fixColorIfValid(String string, String string2) {
        try {
            UIDefaultsLoader.parseColorRGBA(string);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string2;
        }
    }

    private void applyColorPalette(UIDefaults uIDefaults) {
        if (this.icons == null) {
            return;
        }
        Iterator iterator = this.icons.get("ColorPalette");
        if (!(iterator instanceof Map)) {
            return;
        }
        iterator = (Map)((Object)iterator);
        for (Map.Entry entry : iterator.entrySet()) {
            ColorUIResource colorUIResource;
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string.startsWith("Checkbox.") || !(v instanceof String)) continue;
            if (this.dark) {
                string = StringUtils.removeTrailing(string, ".Dark");
            }
            if ((colorUIResource = this.toColor((String)v)) == null) continue;
            uIDefaults.put(string, colorUIResource);
        }
    }

    private ColorUIResource toColor(String string) {
        ColorUIResource colorUIResource = this.namedColors.get(string);
        if (colorUIResource != null) {
            return colorUIResource;
        }
        return this.parseColor(string);
    }

    private ColorUIResource parseColor(String string) {
        try {
            return UIDefaultsLoader.parseColor(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyCheckBoxColors(UIDefaults uIDefaults) {
        String string;
        if (this.icons == null) {
            return;
        }
        String[] stringArray = this.icons.get("ColorPalette");
        if (!(stringArray instanceof Map)) {
            return;
        }
        boolean bl = false;
        stringArray = (Map)stringArray;
        for (Map.Entry entry : stringArray.entrySet()) {
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (!string2.startsWith("Checkbox.") || !(v instanceof String)) continue;
            if (this.dark) {
                string2 = StringUtils.removeTrailing(string2, ".Dark");
            }
            if ((string = checkboxKeyMapping.get(string2)) == null) continue;
            Object object2 = "CheckBox.icon.";
            if (!this.dark && string.startsWith((String)object2)) {
                string = "CheckBox.icon[filled].".concat(string.substring(((String)object2).length()));
            }
            if ((object2 = this.toColor((String)v)) != null) {
                uIDefaults.put(string, object2);
                String string3 = checkboxDuplicateColors.get(string2 + ".Dark");
                if (string3 != null) {
                    void var4_10;
                    String string4;
                    if (this.dark) {
                        String string5 = StringUtils.removeTrailing(string3, ".Dark");
                    }
                    if ((string4 = checkboxKeyMapping.get(var4_10)) != null) {
                        uIDefaults.put(string4, object2);
                    }
                }
            }
            bl = true;
        }
        if (bl) {
            uIDefaults.remove("CheckBox.icon.focusWidth");
            uIDefaults.put("CheckBox.icon.hoverBorderColor", uIDefaults.get("CheckBox.icon.focusedBorderColor"));
            uIDefaults.remove("CheckBox.icon[filled].focusWidth");
            uIDefaults.put("CheckBox.icon[filled].hoverBorderColor", uIDefaults.get("CheckBox.icon[filled].focusedBorderColor"));
            uIDefaults.put("CheckBox.icon[filled].focusedSelectedBackground", uIDefaults.get("CheckBox.icon[filled].selectedBackground"));
            if (this.dark) {
                stringArray = new String[]{"CheckBox.icon.focusedBorderColor", "CheckBox.icon.focusedSelectedBorderColor", "CheckBox.icon[filled].focusedBorderColor", "CheckBox.icon[filled].focusedSelectedBorderColor"};
                String[] stringArray2 = stringArray;
                int cfr_ignored_0 = stringArray.length;
                for (int i = 0; i < 4; ++i) {
                    string = stringArray2[i];
                    Color color = uIDefaults.getColor(string);
                    if (color == null) continue;
                    uIDefaults.put(string, new ColorUIResource(new Color(color.getRGB() & 0xFFFFFF | 0xA6000000, true)));
                }
            }
        }
    }

    private void copyIfNotSet(UIDefaults uIDefaults, String string, String string2, Set<String> set) {
        if (!set.contains(string)) {
            uIDefaults.put(string, uIDefaults.get(string2));
        }
    }

    static {
        Map.Entry[] entryArray;
        uiKeyMapping = new HashMap<String, String>();
        uiKeyCopying = new LinkedHashMap<String, String>();
        uiKeyInverseMapping = new HashMap<String, String>();
        checkboxKeyMapping = new HashMap<String, String>();
        checkboxDuplicateColors = new HashMap<String, String>();
        uiKeyExcludes = new HashSet<String>(Arrays.asList("ActionButton.", "ActionToolbar.", "ActionsList.", "AppInspector.", "AssignedMnemonic.", "Autocomplete.", "AvailableMnemonic.", "BigSpinner.", "Bookmark.", "BookmarkIcon.", "BookmarkMnemonicAssigned.", "BookmarkMnemonicAvailable.", "BookmarkMnemonicCurrent.", "BookmarkMnemonicIcon.", "Borders.", "Breakpoint.", "Canvas.", "CodeWithMe.", "ComboBoxButton.", "CompletionPopup.", "ComplexPopup.", "Content.", "CurrentMnemonic.", "Counter.", "Debugger.", "DebuggerPopup.", "DebuggerTabs.", "DefaultTabs.", "Dialog.", "DialogWrapper.", "DragAndDrop.", "Editor.", "EditorGroupsTabs.", "EditorTabs.", "FileColor.", "FlameGraph.", "Focus.", "Git.", "Github.", "GotItTooltip.", "Group.", "Gutter.", "GutterTooltip.", "HeaderColor.", "HelpTooltip.", "Hg.", "IconBadge.", "InformationHint.", "InplaceRefactoringPopup.", "Lesson.", "Link.", "LiveIndicator.", "MainMenu.", "MainToolbar.", "MemoryIndicator.", "MlModelBinding.", "MnemonicIcon.", "NavBar.", "NewClass.", "NewPSD.", "Notification.", "Notifications.", "NotificationsToolwindow.", "OnePixelDivider.", "OptionButton.", "Outline.", "ParameterInfo.", "Plugins.", "ProgressIcon.", "PsiViewer.", "ReviewList.", "RunWidget.", "ScreenView.", "SearchEverywhere.", "SearchFieldWithExtension.", "SearchMatch.", "SearchOption.", "SearchResults.", "SegmentedButton.", "Settings.", "SidePanel.", "Space.", "SpeedSearch.", "StateWidget.", "StatusBar.", "Tag.", "TipOfTheDay.", "ToolbarComboWidget.", "ToolWindow.", "UIDesigner.", "UnattendedHostStatus.", "ValidationTooltip.", "VersionControl.", "WelcomeScreen.", "darcula.", "dropArea.", "icons.", "intellijlaf.", "macOSWindow.", "material.", "tooltips.", "Checkbox.", "Toolbar.", "Tooltip.", "UiDesigner.", "link."));
        uiKeyDoNotOverride = new HashSet<String>(Arrays.asList("TabbedPane.selectedForeground"));
        uiKeyMapping.put("ComboBox.background", "");
        uiKeyMapping.put("ComboBox.buttonBackground", "");
        uiKeyMapping.put("ComboBox.nonEditableBackground", "ComboBox.background");
        uiKeyMapping.put("ComboBox.ArrowButton.background", "ComboBox.buttonEditableBackground");
        uiKeyMapping.put("ComboBox.ArrowButton.disabledIconColor", "ComboBox.buttonDisabledArrowColor");
        uiKeyMapping.put("ComboBox.ArrowButton.iconColor", "ComboBox.buttonArrowColor");
        uiKeyMapping.put("ComboBox.ArrowButton.nonEditableBackground", "ComboBox.buttonBackground");
        uiKeyCopying.put("ComboBox.buttonSeparatorColor", "Component.borderColor");
        uiKeyCopying.put("ComboBox.buttonDisabledSeparatorColor", "Component.disabledBorderColor");
        uiKeyMapping.put("Component.inactiveErrorFocusColor", "Component.error.borderColor");
        uiKeyMapping.put("Component.errorFocusColor", "Component.error.focusedBorderColor");
        uiKeyMapping.put("Component.inactiveWarningFocusColor", "Component.warning.borderColor");
        uiKeyMapping.put("Component.warningFocusColor", "Component.warning.focusedBorderColor");
        uiKeyMapping.put("Link.activeForeground", "Component.linkColor");
        uiKeyMapping.put("Menu.border", "Menu.margin");
        uiKeyMapping.put("MenuItem.border", "MenuItem.margin");
        uiKeyCopying.put("CheckBoxMenuItem.margin", "MenuItem.margin");
        uiKeyCopying.put("RadioButtonMenuItem.margin", "MenuItem.margin");
        uiKeyMapping.put("PopupMenu.border", "PopupMenu.borderInsets");
        uiKeyCopying.put("MenuItem.underlineSelectionColor", "TabbedPane.underlineColor");
        uiKeyCopying.put("Menu.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("MenuItem.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("CheckBoxMenuItem.selectionBackground", "List.selectionBackground");
        uiKeyCopying.put("RadioButtonMenuItem.selectionBackground", "List.selectionBackground");
        uiKeyMapping.put("ProgressBar.background", "");
        uiKeyMapping.put("ProgressBar.foreground", "");
        uiKeyMapping.put("ProgressBar.trackColor", "ProgressBar.background");
        uiKeyMapping.put("ProgressBar.progressColor", "ProgressBar.foreground");
        uiKeyCopying.put("ProgressBar.selectionForeground", "ProgressBar.background");
        uiKeyCopying.put("ProgressBar.selectionBackground", "ProgressBar.foreground");
        uiKeyMapping.put("ScrollBar.trackColor", "ScrollBar.track");
        uiKeyMapping.put("ScrollBar.thumbColor", "ScrollBar.thumb");
        uiKeyMapping.put("Separator.separatorColor", "Separator.foreground");
        uiKeyMapping.put("Slider.trackWidth", "");
        uiKeyCopying.put("Slider.trackValueColor", "ProgressBar.foreground");
        uiKeyCopying.put("Slider.thumbColor", "ProgressBar.foreground");
        uiKeyCopying.put("Slider.trackColor", "ProgressBar.background");
        uiKeyCopying.put("Spinner.buttonSeparatorColor", "Component.borderColor");
        uiKeyCopying.put("Spinner.buttonDisabledSeparatorColor", "Component.disabledBorderColor");
        uiKeyMapping.put("DefaultTabs.underlinedTabBackground", "TabbedPane.selectedBackground");
        uiKeyMapping.put("DefaultTabs.underlinedTabForeground", "TabbedPane.selectedForeground");
        uiKeyMapping.put("DefaultTabs.inactiveUnderlineColor", "TabbedPane.inactiveUnderlineColor");
        uiKeyCopying.put("TitlePane.inactiveBackground", "TitlePane.background");
        uiKeyMapping.put("TitlePane.infoForeground", "TitlePane.foreground");
        uiKeyMapping.put("TitlePane.inactiveInfoForeground", "TitlePane.inactiveForeground");
        Map.Entry[] entryArray2 = uiKeyMapping.entrySet().iterator();
        while (entryArray2.hasNext()) {
            entryArray = entryArray2.next();
            uiKeyInverseMapping.put(entryArray.getValue(), entryArray.getKey());
        }
        uiKeyCopying.put("ToggleButton.tab.underlineColor", "TabbedPane.underlineColor");
        uiKeyCopying.put("ToggleButton.tab.disabledUnderlineColor", "TabbedPane.disabledUnderlineColor");
        uiKeyCopying.put("ToggleButton.tab.selectedBackground", "TabbedPane.selectedBackground");
        uiKeyCopying.put("ToggleButton.tab.hoverBackground", "TabbedPane.hoverColor");
        uiKeyCopying.put("ToggleButton.tab.focusBackground", "TabbedPane.focusColor");
        checkboxKeyMapping.put("Checkbox.Background.Default", "CheckBox.icon.background");
        checkboxKeyMapping.put("Checkbox.Background.Disabled", "CheckBox.icon.disabledBackground");
        checkboxKeyMapping.put("Checkbox.Border.Default", "CheckBox.icon.borderColor");
        checkboxKeyMapping.put("Checkbox.Border.Disabled", "CheckBox.icon.disabledBorderColor");
        checkboxKeyMapping.put("Checkbox.Focus.Thin.Default", "CheckBox.icon.focusedBorderColor");
        checkboxKeyMapping.put("Checkbox.Focus.Wide", "CheckBox.icon.focusColor");
        checkboxKeyMapping.put("Checkbox.Foreground.Disabled", "CheckBox.icon.disabledCheckmarkColor");
        checkboxKeyMapping.put("Checkbox.Background.Selected", "CheckBox.icon.selectedBackground");
        checkboxKeyMapping.put("Checkbox.Border.Selected", "CheckBox.icon.selectedBorderColor");
        checkboxKeyMapping.put("Checkbox.Foreground.Selected", "CheckBox.icon.checkmarkColor");
        checkboxKeyMapping.put("Checkbox.Focus.Thin.Selected", "CheckBox.icon.focusedSelectedBorderColor");
        checkboxDuplicateColors.put("Checkbox.Background.Default.Dark", "Checkbox.Background.Selected.Dark");
        checkboxDuplicateColors.put("Checkbox.Border.Default.Dark", "Checkbox.Border.Selected.Dark");
        checkboxDuplicateColors.put("Checkbox.Focus.Thin.Default.Dark", "Checkbox.Focus.Thin.Selected.Dark");
        entryArray = entryArray2 = checkboxDuplicateColors.entrySet().toArray(new Map.Entry[checkboxDuplicateColors.size()]);
        int n = entryArray2.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            checkboxDuplicateColors.put((String)entry.getValue(), (String)entry.getKey());
        }
    }

    public static class ThemeLaf
    extends FlatLaf {
        private final IntelliJTheme theme;

        public ThemeLaf(IntelliJTheme intelliJTheme) {
            this.theme = intelliJTheme;
        }

        @Override
        public String getName() {
            return this.theme.name;
        }

        @Override
        public String getDescription() {
            return this.getName();
        }

        @Override
        public boolean isDark() {
            return this.theme.dark;
        }

        public IntelliJTheme getTheme() {
            return this.theme;
        }

        @Override
        void applyAdditionalDefaults(UIDefaults uIDefaults) {
            this.theme.applyProperties(uIDefaults);
        }

        protected ArrayList<Class<?>> getLafClassesForDefaultsLoading() {
            ArrayList arrayList = new ArrayList();
            arrayList.add(FlatLaf.class);
            arrayList.add(this.theme.dark ? FlatDarkLaf.class : FlatLightLaf.class);
            arrayList.add(this.theme.dark ? FlatDarculaLaf.class : FlatIntelliJLaf.class);
            arrayList.add(ThemeLaf.class);
            return arrayList;
        }
    }
}

