/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicListUI;

public class FlatListUI
extends BasicListUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color cellFocusColor;
    @FlatStylingSupport.Styleable
    protected Boolean showCellFocusIndicator;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatListUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
            return;
        }
        this.installUIImpl(jComponent);
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("List.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("List.selectionInactiveForeground");
        this.selectionInsets = UIManager.getInsets("List.selectionInsets");
        this.selectionArc = UIManager.getInt("List.selectionArc");
        this.toggleSelectionColors();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicListUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                FlatListUI.this.toggleSelectionColors();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                EventQueue.invokeLater(() -> FlatListUI.this.toggleSelectionColors());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            switch (propertyChangeEvent.getPropertyName()) {
                case "JComponent.focusOwner": {
                    this.toggleSelectionColors();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.list.revalidate();
                    this.list.repaint();
                }
            }
        };
    }

    @Override
    protected ListSelectionListener createListSelectionListener() {
        ListSelectionListener listSelectionListener = super.createListSelectionListener();
        return listSelectionEvent -> {
            listSelectionListener.valueChanged(listSelectionEvent);
            if (this.useUnitedRoundedSelection(true, true) && !this.list.isSelectionEmpty() && this.list.getMaxSelectionIndex() - this.list.getMinSelectionIndex() > 0) {
                int n = this.list.getModel().getSize();
                int n2 = Math.min(Math.max(listSelectionEvent.getFirstIndex(), 0), n - 1);
                n = Math.min(Math.max(listSelectionEvent.getLastIndex(), 0), n - 1);
                FlatListUI flatListUI = this;
                Rectangle rectangle = flatListUI.getCellBounds(flatListUI.list, n2, n);
                if (rectangle != null) {
                    int n3 = (int)Math.ceil(UIScale.scale((float)this.selectionArc / 2.0f));
                    this.list.repaint(rectangle.x - n3, rectangle.y - n3, rectangle.width + (n3 << 1), rectangle.height + (n3 << 1));
                }
            }
        };
    }

    protected void installStyle() {
        try {
            FlatListUI flatListUI = this;
            flatListUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatListUI.list, "List"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        Color color = this.selectionBackground;
        Color color2 = this.selectionForeground;
        Color color3 = this.selectionInactiveBackground;
        Color color4 = this.selectionInactiveForeground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.selectionBackground != color) {
            object = this.list.getSelectionBackground();
            if (object == color) {
                this.list.setSelectionBackground(this.selectionBackground);
            } else if (object == color3) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
        }
        if (this.selectionForeground != color2) {
            object = this.list.getSelectionForeground();
            if (object == color2) {
                this.list.setSelectionForeground(this.selectionForeground);
                return;
            }
            if (object == color4) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        FlatListUI flatListUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatListUI, flatListUI.list, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private void toggleSelectionColors() {
        if (this.list == null) {
            return;
        }
        if (FlatUIUtils.isPermanentFocusOwner(this.list)) {
            if (this.list.getSelectionBackground() == this.selectionInactiveBackground) {
                this.list.setSelectionBackground(this.selectionBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionInactiveForeground) {
                this.list.setSelectionForeground(this.selectionForeground);
                return;
            }
        } else {
            if (this.list.getSelectionBackground() == this.selectionBackground) {
                this.list.setSelectionBackground(this.selectionInactiveBackground);
            }
            if (this.list.getSelectionForeground() == this.selectionForeground) {
                this.list.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer object, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        int n3;
        boolean bl = listSelectionModel.isSelectedIndex(n);
        object = object.getListCellRendererComponent(this.list, listModel.getElementAt(n), n, bl, FlatUIUtils.isPermanentFocusOwner(this.list) && n == n2);
        boolean bl2 = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        if (bl2) {
            n3 = Math.min(rectangle.width, ((Component)object).getPreferredSize().width + 4);
            n2 = this.list.getComponentOrientation().isLeftToRight() ? rectangle.x : rectangle.x + (rectangle.width - n3);
        } else {
            n2 = rectangle.x;
            n3 = rectangle.width;
        }
        if (bl && !bl2 && (object instanceof DefaultListCellRenderer || object instanceof BasicComboBoxRenderer) && (this.selectionArc > 0 || this.selectionInsets != null && (this.selectionInsets.top != 0 || this.selectionInsets.left != 0 || this.selectionInsets.bottom != 0 || this.selectionInsets.right != 0))) {
            class RoundedSelectionGraphics
            extends Graphics2DProxy {
                private boolean inPaintSelection;
                final /* synthetic */ Rectangle val$rowBounds;
                final /* synthetic */ Component val$rendererComponent;
                final /* synthetic */ int val$row;

                RoundedSelectionGraphics(Graphics graphics) {
                    this.val$rowBounds = rectangle;
                    this.val$rendererComponent = component;
                    this.val$row = n;
                    super((Graphics2D)graphics);
                }

                @Override
                public Graphics create() {
                    return new RoundedSelectionGraphics(super.create());
                }

                @Override
                public Graphics create(int n, int n2, int n3, int n4) {
                    return new RoundedSelectionGraphics(super.create(n, n2, n3, n4));
                }

                @Override
                public void fillRect(int n, int n2, int n3, int n4) {
                    if (!this.inPaintSelection && n == 0 && n2 == 0 && n3 == this.val$rowBounds.width && n4 == this.val$rowBounds.height && this.getColor() == this.val$rendererComponent.getBackground()) {
                        this.inPaintSelection = true;
                        RoundedSelectionGraphics roundedSelectionGraphics = this;
                        FlatListUI.this.paintCellSelection(roundedSelectionGraphics, roundedSelectionGraphics.val$row, n, n2, n3, n4);
                        this.inPaintSelection = false;
                        return;
                    }
                    super.fillRect(n, n2, n3, n4);
                }
            }
            graphics = new RoundedSelectionGraphics(graphics);
        }
        this.rendererPane.paintComponent(graphics, (Component)object, this.list, n2, rectangle.y, n3, rectangle.height, true);
    }

    protected void paintCellSelection(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        float f;
        float f2 = f = UIScale.scale((float)this.selectionArc / 2.0f);
        float f3 = f;
        float f4 = f;
        if (this.list.getLayoutOrientation() == 0) {
            if (this.useUnitedRoundedSelection(true, false)) {
                if (n > 0 && this.list.isSelectedIndex(n - 1)) {
                    f3 = 0.0f;
                    f4 = 0.0f;
                }
                if (n < this.list.getModel().getSize() - 1 && this.list.isSelectedIndex(n + 1)) {
                    f = 0.0f;
                    f2 = 0.0f;
                }
            }
        } else {
            int n6;
            int n7;
            Rectangle rectangle = null;
            if (this.useUnitedRoundedSelection(true, false)) {
                FlatListUI flatListUI = this;
                int n8 = n;
                rectangle = flatListUI.getCellBounds(flatListUI.list, n8, n8);
                FlatListUI flatListUI2 = this;
                n7 = flatListUI2.locationToIndex(flatListUI2.list, new Point(rectangle.x, rectangle.y - 1));
                FlatListUI flatListUI3 = this;
                n6 = flatListUI3.locationToIndex(flatListUI3.list, new Point(rectangle.x, rectangle.y + rectangle.height));
                if (n7 >= 0 && n7 != n && this.list.isSelectedIndex(n7)) {
                    f3 = 0.0f;
                    f4 = 0.0f;
                }
                if (n6 >= 0 && n6 != n && this.list.isSelectedIndex(n6)) {
                    f = 0.0f;
                    f2 = 0.0f;
                }
            }
            if (this.useUnitedRoundedSelection(false, true)) {
                if (rectangle == null) {
                    FlatListUI flatListUI = this;
                    int n9 = n;
                    rectangle = flatListUI.getCellBounds(flatListUI.list, n9, n9);
                }
                FlatListUI flatListUI = this;
                n7 = flatListUI.locationToIndex(flatListUI.list, new Point(rectangle.x - 1, rectangle.y));
                FlatListUI flatListUI4 = this;
                n6 = flatListUI4.locationToIndex(flatListUI4.list, new Point(rectangle.x + rectangle.width, rectangle.y));
                boolean bl = this.list.getComponentOrientation().isLeftToRight();
                if (!bl && n7 >= 0 && n7 != n) {
                    FlatListUI flatListUI5 = this;
                    if (n7 == flatListUI5.locationToIndex(flatListUI5.list, new Point(rectangle.x - 1, rectangle.y - 1))) {
                        n7 = -1;
                    }
                }
                if (bl && n6 >= 0 && n6 != n) {
                    FlatListUI flatListUI6 = this;
                    if (n6 == flatListUI6.locationToIndex(flatListUI6.list, new Point(rectangle.x + rectangle.width, rectangle.y - 1))) {
                        n6 = -1;
                    }
                }
                if (n7 >= 0 && n7 != n && this.list.isSelectedIndex(n7)) {
                    f2 = 0.0f;
                    f4 = 0.0f;
                }
                if (n6 >= 0 && n6 != n && this.list.isSelectedIndex(n6)) {
                    f = 0.0f;
                    f3 = 0.0f;
                }
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)graphics, n2, n3, n4, n5, UIScale.scale(this.selectionInsets), f4, f3, f2, f, 0);
    }

    private boolean useUnitedRoundedSelection(boolean bl, boolean bl2) {
        return this.selectionArc > 0 && (this.selectionInsets == null || bl && this.selectionInsets.top == 0 && this.selectionInsets.bottom == 0 || bl2 && this.selectionInsets.left == 0 && this.selectionInsets.right == 0);
    }

    public static void paintCellSelection(JList<?> object, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (!(((JList)object).getUI() instanceof FlatListUI)) {
            return;
        }
        object = (FlatListUI)((JList)object).getUI();
        ((FlatListUI)object).paintCellSelection(graphics, n, n2, n3, n4, n5);
    }
}

