/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.MappedByteBufferInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MappedByteBufferOutputStream
extends OutputStream {
    private final MappedByteBufferInputStream parent;

    MappedByteBufferOutputStream(MappedByteBufferInputStream mappedByteBufferInputStream, MappedByteBufferInputStream.FileResizeOp fileResizeOp) {
        if (FileChannel.MapMode.READ_ONLY == mappedByteBufferInputStream.getMapMode()) {
            throw new IOException("FileChannel map-mode is read-only");
        }
        this.parent = mappedByteBufferInputStream;
        this.parent.setFileResizeOp(fileResizeOp);
    }

    public MappedByteBufferOutputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, MappedByteBufferInputStream.CacheMode cacheMode, int n, MappedByteBufferInputStream.FileResizeOp fileResizeOp) {
        this(new MappedByteBufferInputStream(fileChannel, mapMode, cacheMode, n, fileChannel.size(), 0), fileResizeOp);
    }

    public final synchronized void setSynchronous(boolean bl) {
        this.parent.setSynchronous(bl);
    }

    public final synchronized boolean getSynchronous() {
        return this.parent.getSynchronous();
    }

    public final synchronized void setLength(long l) {
        this.parent.setLength(l);
    }

    public final synchronized void notifyLengthChange(long l) {
        this.parent.notifyLengthChange(l);
    }

    public final synchronized long length() {
        return this.parent.length();
    }

    public final synchronized long remaining() {
        return this.parent.remaining();
    }

    public final synchronized long position() {
        return this.parent.position();
    }

    public final synchronized MappedByteBufferInputStream position(long l) {
        return this.parent.position(l);
    }

    public final synchronized long skip(long l) {
        return this.parent.skip(l);
    }

    @Override
    public final synchronized void flush() {
        this.parent.flush(true);
    }

    public final synchronized void flush(boolean bl) {
        this.parent.flush(bl);
    }

    @Override
    public final synchronized void close() {
        this.parent.close();
    }

    @Override
    public final synchronized void write(int n) {
        ByteBuffer byteBuffer;
        int n2;
        this.parent.checkOpen();
        long l = this.parent.remaining();
        if (l < 1L) {
            this.parent.setLength(this.parent.length() + 1L);
        }
        if ((n2 = (byteBuffer = this.parent.currentSlice()).remaining()) == 0 && null == (byteBuffer = this.parent.nextSlice())) {
            if (MappedByteBufferInputStream.DEBUG) {
                System.err.println("EOT write: " + this.parent.currentSlice());
                this.parent.dbgDump("EOT write:", System.err);
            }
            throw new IOException("EOT");
        }
        byteBuffer.put((byte)n);
        if (byteBuffer != null) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) {
        int n3;
        this.parent.checkOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("offset " + n + ", length " + n2 + ", b.length " + byArray.length);
        }
        if (n2 == 0) {
            return;
        }
        long l = this.parent.remaining();
        if (l < (long)n2) {
            this.parent.setLength(this.parent.length() + (long)n2 - l);
        }
        ByteBuffer byteBuffer = null;
        for (int i = 0; i < n2; i += n3) {
            byteBuffer = this.parent.currentSlice();
            n3 = byteBuffer.remaining();
            if (n3 == 0) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: offset " + n + ", length " + n2 + ", b.length " + byArray.length);
                        System.err.println("EOT write: written " + i + " / " + n2 + ", currRem " + n3);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n3 = byteBuffer.remaining();
            }
            n3 = Math.min(n2 - i, n3);
            byteBuffer.put(byArray, n + i, n3);
        }
        if (byteBuffer != null) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    public final synchronized void write(ByteBuffer byteBuffer, int n) {
        int n2;
        this.parent.checkOpen();
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n + ", b " + byteBuffer);
        }
        if (n == 0) {
            return;
        }
        long l = this.parent.remaining();
        if (l < (long)n) {
            this.parent.setLength(this.parent.length() + (long)n - l);
        }
        ByteBuffer byteBuffer2 = null;
        for (int i = 0; i < n; i += n2) {
            byteBuffer2 = this.parent.currentSlice();
            int n3 = byteBuffer2.remaining();
            if (n3 == 0) {
                byteBuffer2 = this.parent.nextSlice();
                if (null == byteBuffer2) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: length " + n + ", b " + byteBuffer);
                        System.err.println("EOT write: written " + i + " / " + n + ", currRem " + n3);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n3 = byteBuffer2.remaining();
            }
            n2 = Math.min(n - i, n3);
            if (byteBuffer2.hasArray() && byteBuffer.hasArray()) {
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), n2);
                ByteBuffer byteBuffer3 = byteBuffer;
                byteBuffer3.position(byteBuffer3.position() + n2);
                ByteBuffer byteBuffer4 = byteBuffer2;
                byteBuffer4.position(byteBuffer4.position() + n2);
                continue;
            }
            if (n2 == n3) {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            n3 = byteBuffer.limit();
            byteBuffer.limit(n2);
            try {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            finally {
                byteBuffer.limit(n3);
            }
        }
        if (byteBuffer2 != null) {
            this.parent.syncSlice(byteBuffer2);
        }
    }

    public final synchronized void write(MappedByteBufferInputStream mappedByteBufferInputStream, long l) {
        int n;
        this.parent.checkOpen();
        if (mappedByteBufferInputStream == null) {
            throw new NullPointerException();
        }
        if (l < 0L || l > mappedByteBufferInputStream.remaining()) {
            throw new IndexOutOfBoundsException("length " + l + ", b " + mappedByteBufferInputStream);
        }
        if (0L == l) {
            return;
        }
        long l2 = this.parent.remaining();
        if (l2 < l) {
            this.parent.setLength(this.parent.length() + l - l2);
        }
        ByteBuffer byteBuffer = null;
        for (long i = 0L; i < l; i += (long)n) {
            byteBuffer = this.parent.currentSlice();
            n = byteBuffer.remaining();
            if (n == 0) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        System.err.println("EOT write: length " + l + ", b " + mappedByteBufferInputStream);
                        System.err.println("EOT write: written " + i + " / " + l + ", currRem " + n);
                        System.err.println("EOT write: " + this.parent.currentSlice());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n = byteBuffer.remaining();
            }
            if ((n = mappedByteBufferInputStream.read(byteBuffer, (int)Math.min(l - i, (long)n))) >= 0) continue;
            throw new InternalError("Unexpected InputStream EOT");
        }
        if (byteBuffer != null) {
            this.parent.syncSlice(byteBuffer);
        }
    }
}

