/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BufferedImagePainter;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020#0,H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\u001b\u0010(\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010'\u001a\u0004\b)\u0010%\u00a8\u0006-"}, d2={"Landroidx/compose/ui/graphics/PainterImage;", "Ljava/awt/Image;", "Ljava/awt/image/MultiResolutionImage;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "size", "Landroidx/compose/ui/geometry/Size;", "<init>", "(Landroidx/compose/ui/graphics/painter/Painter;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "width", "", "height", "getWidth", "observer", "Ljava/awt/image/ImageObserver;", "getHeight", "getResolutionVariant", "destImageWidth", "", "destImageHeight", "asBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "getProperty", "", "name", "", "getSource", "Ljava/awt/image/ImageProducer;", "getGraphics", "Ljava/awt/Graphics;", "defaultImage", "Ljava/awt/image/BufferedImage;", "getDefaultImage", "()Ljava/awt/image/BufferedImage;", "defaultImage$delegate", "Lkotlin/Lazy;", "scaledImage", "getScaledImage", "scaledImage$delegate", "getResolutionVariants", "", "ui-graphics"})
final class PainterImage
extends Image
implements MultiResolutionImage {
    private final Painter painter;
    private final Density density;
    private final LayoutDirection layoutDirection;
    private final int width;
    private final int height;
    private final Lazy defaultImage$delegate;
    private final Lazy scaledImage$delegate;

    private PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long l) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"");
        Intrinsics.checkNotNullParameter((Object)density, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        this.painter = painter;
        this.density = density;
        this.layoutDirection = layoutDirection;
        int n = (int)(l >> 32);
        this.width = (int)Float.intBitsToFloat(n);
        n = (int)l;
        this.height = (int)Float.intBitsToFloat(n);
        this.defaultImage$delegate = LazyKt.lazy(() -> PainterImage.defaultImage_delegate$lambda$2(this));
        this.scaledImage$delegate = LazyKt.lazy(() -> PainterImage.scaledImage_delegate$lambda$3(this));
    }

    @Override
    public final int getWidth(ImageObserver imageObserver) {
        return this.width;
    }

    @Override
    public final int getHeight(ImageObserver imageObserver) {
        return this.height;
    }

    @Override
    public final Image getResolutionVariant(double d2, double d3) {
        int n = (int)d2;
        int n2 = (int)d3;
        if (this.painter instanceof BufferedImagePainter && ((BufferedImagePainter)this.painter).getImage().getWidth() == n && ((BufferedImagePainter)this.painter).getImage().getHeight() == n2) {
            return ((BufferedImagePainter)this.painter).getImage();
        }
        return DesktopImageConverters_desktopKt.toAwtImage(this.asBitmap(n, n2));
    }

    private final ImageBitmap asBitmap(int n, int n2) {
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(n, n2, 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(imageBitmap);
        float f = n;
        float f2 = n2;
        long l = Float.floatToRawIntBits(f);
        long l2 = Float.floatToRawIntBits(f2);
        long l3 = Size.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL));
        CanvasDrawScope canvasDrawScope = new CanvasDrawScope();
        Density density = this.density;
        Object object = this.layoutDirection;
        CanvasDrawScope.DrawParams drawParams = canvasDrawScope.getDrawParams();
        Density density2 = drawParams.component1();
        LayoutDirection layoutDirection = drawParams.component2();
        Canvas canvas2 = drawParams.component3();
        long l4 = drawParams.component4-NH-jbRc();
        CanvasDrawScope.DrawParams drawParams2 = canvasDrawScope.getDrawParams();
        CanvasDrawScope.DrawParams drawParams3 = drawParams2;
        drawParams3 = drawParams2;
        drawParams2.setDensity(density);
        drawParams3.setLayoutDirection((LayoutDirection)object);
        drawParams3.setCanvas(canvas);
        drawParams3.setSize-uvyYCjk(l3);
        canvas.save();
        density = canvasDrawScope;
        object = this.painter;
        Painter.draw-x_KDEd0$default((Painter)object, (DrawScope)density, l3, 0.0f, null, 6, null);
        canvas.restore();
        CanvasDrawScope.DrawParams drawParams4 = canvasDrawScope.getDrawParams();
        drawParams3 = drawParams4;
        drawParams3 = drawParams4;
        drawParams4.setDensity(density2);
        drawParams3.setLayoutDirection(layoutDirection);
        drawParams3.setCanvas(canvas2);
        drawParams3.setSize-uvyYCjk(l4);
        return imageBitmap;
    }

    @Override
    public final Object getProperty(String string, ImageObserver imageObserver) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Object object = Image.UndefinedProperty;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return object;
    }

    @Override
    public final ImageProducer getSource() {
        ImageProducer imageProducer = this.getDefaultImage().getSource();
        Intrinsics.checkNotNullExpressionValue((Object)imageProducer, (String)"");
        return imageProducer;
    }

    @Override
    public final Graphics getGraphics() {
        Graphics graphics = this.getDefaultImage().getGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"");
        return graphics;
    }

    private final BufferedImage getDefaultImage() {
        Lazy lazy = this.defaultImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    private final BufferedImage getScaledImage() {
        Lazy lazy = this.scaledImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    public final List<BufferedImage> getResolutionVariants() {
        Object[] objectArray = this.painter;
        if (this.painter instanceof BufferedImagePainter || objectArray instanceof BitmapPainter) {
            return CollectionsKt.listOf((Object)this.getDefaultImage());
        }
        Object[] objectArray2 = new BufferedImage[2];
        objectArray = objectArray2;
        objectArray2[0] = this.getDefaultImage();
        objectArray[1] = this.getScaledImage();
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final BufferedImage defaultImage_delegate$lambda$2(PainterImage painterImage) {
        if (painterImage.painter instanceof BufferedImagePainter) {
            return ((BufferedImagePainter)painterImage.painter).getImage();
        }
        PainterImage painterImage2 = painterImage;
        return DesktopImageConverters_desktopKt.toAwtImage(painterImage2.asBitmap(painterImage2.width, painterImage.height));
    }

    private static final BufferedImage scaledImage_delegate$lambda$3(PainterImage painterImage) {
        PainterImage painterImage2 = painterImage;
        return DesktopImageConverters_desktopKt.toAwtImage(painterImage2.asBitmap(MathKt.roundToInt((float)((float)painterImage2.width * painterImage.density.getDensity())), MathKt.roundToInt((float)((float)painterImage.height * painterImage.density.getDensity()))));
    }

    public /* synthetic */ PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long l, DefaultConstructorMarker defaultConstructorMarker) {
        this(painter, density, layoutDirection, l);
    }
}

