/*
 * Decompiled with CFR 0.152.
 */
package kotlin.math;

import kotlin.Metadata;
import kotlin.math.Constants;
import kotlin.math.MathKt;
import kotlin.math.MathKt__MathHKt;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0006\n\u0002\b%\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\t\n\u0002\u0010\u0007\n\u0002\b\b\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0019\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0019\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0007\u001a\u0011\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0011\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u001a\u0011\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0019\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001H\u0087\b\u001a\u0019\u0010#\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001H\u0087\b\u001a\u0011\u0010$\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0015\u0010%\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0087\b\u001a\u0015\u0010%\u001a\u00020\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020'H\u0087\b\u001a\u0015\u0010(\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0087\b\u001a\u0015\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0087\b\u001a\u0015\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020'H\u0087\b\u001a\r\u00105\u001a\u00020\u0001*\u00020\u0001H\u0087\b\u001a\r\u00106\u001a\u00020\u0001*\u00020\u0001H\u0087\b\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u00108\u001a\u00020\u0001H\u0087\b\u001a\f\u00109\u001a\u00020'*\u00020\u0001H\u0007\u001a\f\u0010:\u001a\u00020;*\u00020\u0001H\u0007\u001a\u0011\u0010\u0000\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0003\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0004\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0005\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0006\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0007\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0019\u0010\b\u001a\u00020<2\u0006\u0010\t\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\n\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u000b\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\f\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\r\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u000e\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u000f\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0019\u0010\u0010\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<2\u0006\u0010\t\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0011\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0012\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0013\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0018\u0010\u0014\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020<H\u0007\u001a\u0011\u0010\u0016\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u0017\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0010\u0010\u0018\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0007\u001a\u0011\u0010\u0019\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u001a\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u001b\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0010\u0010\u001c\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0007\u001a\u0011\u0010\u001d\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u001e\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0011\u0010\u001f\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0019\u0010 \u001a\u00020<2\u0006\u0010!\u001a\u00020<2\u0006\u0010\"\u001a\u00020<H\u0087\b\u001a\u0019\u0010#\u001a\u00020<2\u0006\u0010!\u001a\u00020<2\u0006\u0010\"\u001a\u00020<H\u0087\b\u001a\u0011\u0010$\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0015\u0010%\u001a\u00020<*\u00020<2\u0006\u0010\u0002\u001a\u00020<H\u0087\b\u001a\u0015\u0010%\u001a\u00020<*\u00020<2\u0006\u0010&\u001a\u00020'H\u0087\b\u001a\u0015\u0010(\u001a\u00020<*\u00020<2\u0006\u0010)\u001a\u00020<H\u0087\b\u001a\u0015\u00101\u001a\u00020<*\u00020<2\u0006\u0010\u001f\u001a\u00020<H\u0087\b\u001a\u0015\u00101\u001a\u00020<*\u00020<2\u0006\u0010\u001f\u001a\u00020'H\u0087\b\u001a\r\u00105\u001a\u00020<*\u00020<H\u0087\b\u001a\r\u00106\u001a\u00020<*\u00020<H\u0087\b\u001a\u0015\u00107\u001a\u00020<*\u00020<2\u0006\u00108\u001a\u00020<H\u0087\b\u001a\f\u00109\u001a\u00020'*\u00020<H\u0007\u001a\f\u0010:\u001a\u00020;*\u00020<H\u0007\u001a\u0011\u0010\u001e\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0087\b\u001a\u0019\u0010 \u001a\u00020'2\u0006\u0010!\u001a\u00020'2\u0006\u0010\"\u001a\u00020'H\u0087\b\u001a\u0019\u0010#\u001a\u00020'2\u0006\u0010!\u001a\u00020'2\u0006\u0010\"\u001a\u00020'H\u0087\b\u001a\u0011\u0010\u001e\u001a\u00020;2\u0006\u0010&\u001a\u00020;H\u0087\b\u001a\u0019\u0010 \u001a\u00020;2\u0006\u0010!\u001a\u00020;2\u0006\u0010\"\u001a\u00020;H\u0087\b\u001a\u0019\u0010#\u001a\u00020;2\u0006\u0010!\u001a\u00020;2\u0006\u0010\"\u001a\u00020;H\u0087\b\"\u001f\u0010*\u001a\u00020\u0001*\u00020\u00018\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u001f\u0010\u001f\u001a\u00020\u0001*\u00020\u00018\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010,\u001a\u0004\b0\u0010.\"\u001f\u00102\u001a\u00020\u0001*\u00020\u00018\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u0010,\u001a\u0004\b4\u0010.\"\u001f\u0010*\u001a\u00020<*\u00020<8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010=\u001a\u0004\b-\u0010>\"\u001f\u0010\u001f\u001a\u00020<*\u00020<8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010=\u001a\u0004\b0\u0010>\"\u001f\u00102\u001a\u00020<*\u00020<8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u0010=\u001a\u0004\b4\u0010>\"\u001f\u0010*\u001a\u00020'*\u00020'8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010?\u001a\u0004\b-\u0010@\"\u001e\u0010\u001f\u001a\u00020'*\u00020'8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010?\u001a\u0004\b0\u0010@\"\u001f\u0010*\u001a\u00020;*\u00020;8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010A\u001a\u0004\b-\u0010B\"\u001e\u0010\u001f\u001a\u00020'*\u00020;8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010A\u001a\u0004\b0\u0010C\u00a8\u0006D"}, d2={"sin", "", "x", "cos", "tan", "asin", "acos", "atan", "atan2", "y", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "hypot", "sqrt", "exp", "expm1", "log", "base", "ln", "log10", "log2", "ln1p", "ceil", "floor", "truncate", "round", "abs", "sign", "min", "a", "b", "max", "cbrt", "pow", "n", "", "IEEErem", "divisor", "absoluteValue", "getAbsoluteValue$annotations", "(D)V", "getAbsoluteValue", "(D)D", "getSign$annotations", "getSign", "withSign", "ulp", "getUlp$annotations", "getUlp", "nextUp", "nextDown", "nextTowards", "to", "roundToInt", "roundToLong", "", "", "(F)V", "(F)F", "(I)V", "(I)I", "(J)V", "(J)J", "(J)I", "kotlin-stdlib"}, xs="kotlin/math/MathKt")
class MathKt__MathJVMKt
extends MathKt__MathHKt {
    private static final double sin(double d) {
        return Math.sin(d);
    }

    private static final double cos(double d) {
        return Math.cos(d);
    }

    private static final double tan(double d) {
        return Math.tan(d);
    }

    private static final double asin(double d) {
        return Math.asin(d);
    }

    private static final double acos(double d) {
        return Math.acos(d);
    }

    private static final double atan(double d) {
        return Math.atan(d);
    }

    private static final double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    private static final double sinh(double d) {
        return Math.sinh(d);
    }

    private static final double cosh(double d) {
        return Math.cosh(d);
    }

    private static final double tanh(double d) {
        return Math.tanh(d);
    }

    public static final double asinh(double d) {
        if (d >= Constants.taylor_n_bound) {
            if (d > Constants.upper_taylor_n_bound) {
                if (d > Constants.upper_taylor_2_bound) {
                    return Math.log(d) + Constants.LN2;
                }
                return Math.log(d * 2.0 + 1.0 / (d * 2.0));
            }
            double d2 = d;
            return Math.log(d2 + Math.sqrt(d2 * d + 1.0));
        }
        if (d <= -Constants.taylor_n_bound) {
            return -MathKt.asinh(-d);
        }
        double d3 = d;
        if (Math.abs(d) >= Constants.taylor_2_bound) {
            double d4 = d;
            d3 = d4 - d4 * d * d / 6.0;
        }
        return d3;
    }

    public static final double acosh(double d) {
        double d2;
        if (d < 1.0) {
            return Double.NaN;
        }
        if (d > Constants.upper_taylor_2_bound) {
            return Math.log(d) + Constants.LN2;
        }
        if (d - 1.0 >= Constants.taylor_n_bound) {
            double d3 = d;
            return Math.log(d3 + Math.sqrt(d3 * d - 1.0));
        }
        double d4 = d2 = Math.sqrt(d - 1.0);
        if (d2 >= Constants.taylor_2_bound) {
            double d5 = d2;
            d4 = d5 - d5 * d2 * d2 / 12.0;
        }
        return Math.sqrt(2.0) * d4;
    }

    public static final double atanh(double d) {
        if (Math.abs(d) < Constants.taylor_n_bound) {
            double d2 = d;
            if (Math.abs(d) > Constants.taylor_2_bound) {
                double d3 = d;
                d2 = d3 + d3 * d * d / 3.0;
            }
            return d2;
        }
        return Math.log((d + 1.0) / (1.0 - d)) / 2.0;
    }

    private static final double hypot(double d, double d2) {
        return Math.hypot(d, d2);
    }

    private static final double sqrt(double d) {
        return Math.sqrt(d);
    }

    private static final double exp(double d) {
        return Math.exp(d);
    }

    private static final double expm1(double d) {
        return Math.expm1(d);
    }

    public static final double log(double d, double d2) {
        if (d2 <= 0.0 || d2 == 1.0) {
            return Double.NaN;
        }
        return Math.log(d) / Math.log(d2);
    }

    private static final double ln(double d) {
        return Math.log(d);
    }

    private static final double log10(double d) {
        return Math.log10(d);
    }

    public static final double log2(double d) {
        return Math.log(d) / Constants.LN2;
    }

    private static final double ln1p(double d) {
        return Math.log1p(d);
    }

    private static final double ceil(double d) {
        return Math.ceil(d);
    }

    private static final double floor(double d) {
        return Math.floor(d);
    }

    public static final double truncate(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    private static final double round(double d) {
        return Math.rint(d);
    }

    private static final double abs(double d) {
        return Math.abs(d);
    }

    private static final double sign(double d) {
        return Math.signum(d);
    }

    private static final double min(double d, double d2) {
        return Math.min(d, d2);
    }

    private static final double max(double d, double d2) {
        return Math.max(d, d2);
    }

    private static final double cbrt(double d) {
        return Math.cbrt(d);
    }

    private static final double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    private static final double pow(double d, int n) {
        return Math.pow(d, n);
    }

    private static final double IEEErem(double d, double d2) {
        return Math.IEEEremainder(d, d2);
    }

    private static final double getAbsoluteValue(double d) {
        return Math.abs(d);
    }

    public static /* synthetic */ void getAbsoluteValue$annotations(double d) {
    }

    private static final double getSign(double d) {
        return Math.signum(d);
    }

    public static /* synthetic */ void getSign$annotations(double d) {
    }

    private static final double withSign(double d, double d2) {
        return Math.copySign(d, d2);
    }

    private static final double withSign(double d, int n) {
        return Math.copySign(d, (double)n);
    }

    private static final double getUlp(double d) {
        return Math.ulp(d);
    }

    public static /* synthetic */ void getUlp$annotations(double d) {
    }

    private static final double nextUp(double d) {
        return Math.nextUp(d);
    }

    private static final double nextDown(double d) {
        return Math.nextAfter(d, Double.NEGATIVE_INFINITY);
    }

    private static final double nextTowards(double d, double d2) {
        return Math.nextAfter(d, d2);
    }

    public static final int roundToInt(double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cannot round NaN value.");
        }
        if (d > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.round(d);
    }

    public static final long roundToLong(double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cannot round NaN value.");
        }
        return Math.round(d);
    }

    private static final float sin(float f) {
        return (float)Math.sin(f);
    }

    private static final float cos(float f) {
        return (float)Math.cos(f);
    }

    private static final float tan(float f) {
        return (float)Math.tan(f);
    }

    private static final float asin(float f) {
        return (float)Math.asin(f);
    }

    private static final float acos(float f) {
        return (float)Math.acos(f);
    }

    private static final float atan(float f) {
        return (float)Math.atan(f);
    }

    private static final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    private static final float sinh(float f) {
        return (float)Math.sinh(f);
    }

    private static final float cosh(float f) {
        return (float)Math.cosh(f);
    }

    private static final float tanh(float f) {
        return (float)Math.tanh(f);
    }

    private static final float asinh(float f) {
        return (float)MathKt.asinh((double)f);
    }

    private static final float acosh(float f) {
        return (float)MathKt.acosh((double)f);
    }

    private static final float atanh(float f) {
        return (float)MathKt.atanh((double)f);
    }

    private static final float hypot(float f, float f2) {
        return (float)Math.hypot(f, f2);
    }

    private static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    private static final float exp(float f) {
        return (float)Math.exp(f);
    }

    private static final float expm1(float f) {
        return (float)Math.expm1(f);
    }

    public static final float log(float f, float f2) {
        if (f2 <= 0.0f || f2 == 1.0f) {
            return Float.NaN;
        }
        return (float)(Math.log(f) / Math.log(f2));
    }

    private static final float ln(float f) {
        return (float)Math.log(f);
    }

    private static final float log10(float f) {
        return (float)Math.log10(f);
    }

    public static final float log2(float f) {
        return (float)(Math.log(f) / Constants.LN2);
    }

    private static final float ln1p(float f) {
        return (float)Math.log1p(f);
    }

    private static final float ceil(float f) {
        return (float)Math.ceil(f);
    }

    private static final float floor(float f) {
        return (float)Math.floor(f);
    }

    public static final float truncate(float f) {
        if (Float.isNaN(f) || Float.isInfinite(f)) {
            return f;
        }
        if (f > 0.0f) {
            return (float)Math.floor(f);
        }
        return (float)Math.ceil(f);
    }

    private static final float round(float f) {
        return (float)Math.rint(f);
    }

    private static final float abs(float f) {
        return Math.abs(f);
    }

    private static final float sign(float f) {
        return Math.signum(f);
    }

    private static final float min(float f, float f2) {
        return Math.min(f, f2);
    }

    private static final float max(float f, float f2) {
        return Math.max(f, f2);
    }

    private static final float cbrt(float f) {
        return (float)Math.cbrt(f);
    }

    private static final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    private static final float pow(float f, int n) {
        return (float)Math.pow(f, n);
    }

    private static final float IEEErem(float f, float f2) {
        return (float)Math.IEEEremainder(f, f2);
    }

    private static final float getAbsoluteValue(float f) {
        return Math.abs(f);
    }

    public static /* synthetic */ void getAbsoluteValue$annotations(float f) {
    }

    private static final float getSign(float f) {
        return Math.signum(f);
    }

    public static /* synthetic */ void getSign$annotations(float f) {
    }

    private static final float withSign(float f, float f2) {
        return Math.copySign(f, f2);
    }

    private static final float withSign(float f, int n) {
        return Math.copySign(f, n);
    }

    private static final float getUlp(float f) {
        return Math.ulp(f);
    }

    public static /* synthetic */ void getUlp$annotations(float f) {
    }

    private static final float nextUp(float f) {
        return Math.nextUp(f);
    }

    private static final float nextDown(float f) {
        return Math.nextAfter(f, Double.NEGATIVE_INFINITY);
    }

    private static final float nextTowards(float f, float f2) {
        return Math.nextAfter(f, (double)f2);
    }

    public static final int roundToInt(float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException("Cannot round NaN value.");
        }
        return Math.round(f);
    }

    public static final long roundToLong(float f) {
        return MathKt.roundToLong((double)f);
    }

    private static final int abs(int n) {
        return Math.abs(n);
    }

    private static final int min(int n, int n2) {
        return Math.min(n, n2);
    }

    private static final int max(int n, int n2) {
        return Math.max(n, n2);
    }

    private static final int getAbsoluteValue(int n) {
        return Math.abs(n);
    }

    public static /* synthetic */ void getAbsoluteValue$annotations(int n) {
    }

    public static final int getSign(int n) {
        return Integer.signum(n);
    }

    public static /* synthetic */ void getSign$annotations(int n) {
    }

    private static final long abs(long l) {
        return Math.abs(l);
    }

    private static final long min(long l, long l2) {
        return Math.min(l, l2);
    }

    private static final long max(long l, long l2) {
        return Math.max(l, l2);
    }

    private static final long getAbsoluteValue(long l) {
        return Math.abs(l);
    }

    public static /* synthetic */ void getAbsoluteValue$annotations(long l) {
    }

    public static final int getSign(long l) {
        return Long.signum(l);
    }

    public static /* synthetic */ void getSign$annotations(long l) {
    }
}

