/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class FastThreadLocal<V> {
    private final int index = InternalThreadLocalMap.nextVariableIndex();

    public static void removeAll() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getIfSet();
        if (internalThreadLocalMap == null) {
            return;
        }
        try {
            FastThreadLocal[] fastThreadLocalArray = internalThreadLocalMap.indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
            if (fastThreadLocalArray != null && fastThreadLocalArray != InternalThreadLocalMap.UNSET) {
                fastThreadLocalArray = (Set)fastThreadLocalArray;
                FastThreadLocal[] fastThreadLocalArray2 = fastThreadLocalArray.toArray(new FastThreadLocal[0]);
                fastThreadLocalArray = fastThreadLocalArray2;
                fastThreadLocalArray = fastThreadLocalArray2;
                int n = fastThreadLocalArray2.length;
                for (int i = 0; i < n; ++i) {
                    FastThreadLocal fastThreadLocal = fastThreadLocalArray[i];
                    fastThreadLocal.remove(internalThreadLocalMap);
                }
            }
            return;
        }
        finally {
            InternalThreadLocalMap.remove();
        }
    }

    public static int size() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getIfSet();
        if (internalThreadLocalMap == null) {
            return 0;
        }
        return internalThreadLocalMap.size();
    }

    public static void destroy() {
        InternalThreadLocalMap.destroy();
    }

    private static void addToVariablesToRemove(InternalThreadLocalMap internalThreadLocalMap, FastThreadLocal<?> fastThreadLocal) {
        Set set = internalThreadLocalMap.indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
        if (set == InternalThreadLocalMap.UNSET || set == null) {
            set = Collections.newSetFromMap(new IdentityHashMap());
            internalThreadLocalMap.setIndexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX, set);
        } else {
            set = set;
        }
        set.add(fastThreadLocal);
    }

    private static void removeFromVariablesToRemove(InternalThreadLocalMap object, FastThreadLocal<?> fastThreadLocal) {
        if ((object = ((InternalThreadLocalMap)object).indexedVariable(InternalThreadLocalMap.VARIABLES_TO_REMOVE_INDEX)) == InternalThreadLocalMap.UNSET || object == null) {
            return;
        }
        object = (Set)object;
        object.remove(fastThreadLocal);
    }

    public final V get() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        Object object = internalThreadLocalMap.indexedVariable(this.index);
        if (object != InternalThreadLocalMap.UNSET) {
            return (V)object;
        }
        return this.initialize(internalThreadLocalMap);
    }

    public final V getIfExists() {
        Object object = InternalThreadLocalMap.getIfSet();
        if (object != null && (object = ((InternalThreadLocalMap)object).indexedVariable(this.index)) != InternalThreadLocalMap.UNSET) {
            return (V)object;
        }
        return null;
    }

    public final V get(InternalThreadLocalMap internalThreadLocalMap) {
        Object object = internalThreadLocalMap.indexedVariable(this.index);
        if (object != InternalThreadLocalMap.UNSET) {
            return (V)object;
        }
        return this.initialize(internalThreadLocalMap);
    }

    private V initialize(InternalThreadLocalMap internalThreadLocalMap) {
        V v = null;
        try {
            V v2 = this.initialValue();
            v = v2;
            if (v2 == InternalThreadLocalMap.UNSET) {
                throw new IllegalArgumentException("InternalThreadLocalMap.UNSET can not be initial value.");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
        }
        internalThreadLocalMap.setIndexedVariable(this.index, v);
        FastThreadLocal.addToVariablesToRemove(internalThreadLocalMap, this);
        return v;
    }

    public final void set(V v) {
        if (v != InternalThreadLocalMap.UNSET) {
            InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
            this.setKnownNotUnset(internalThreadLocalMap, v);
            return;
        }
        this.remove();
    }

    public final void set(InternalThreadLocalMap internalThreadLocalMap, V v) {
        if (v != InternalThreadLocalMap.UNSET) {
            this.setKnownNotUnset(internalThreadLocalMap, v);
            return;
        }
        this.remove(internalThreadLocalMap);
    }

    private void setKnownNotUnset(InternalThreadLocalMap internalThreadLocalMap, V v) {
        if (internalThreadLocalMap.setIndexedVariable(this.index, v)) {
            FastThreadLocal.addToVariablesToRemove(internalThreadLocalMap, this);
        }
    }

    public final boolean isSet() {
        return this.isSet(InternalThreadLocalMap.getIfSet());
    }

    public final boolean isSet(InternalThreadLocalMap internalThreadLocalMap) {
        return internalThreadLocalMap != null && internalThreadLocalMap.isIndexedVariableSet(this.index);
    }

    public final void remove() {
        this.remove(InternalThreadLocalMap.getIfSet());
    }

    public final void remove(InternalThreadLocalMap object) {
        if (object == null) {
            return;
        }
        Object object2 = ((InternalThreadLocalMap)object).removeIndexedVariable(this.index);
        if (object2 != InternalThreadLocalMap.UNSET) {
            FastThreadLocal.removeFromVariablesToRemove((InternalThreadLocalMap)object, this);
            try {
                this.onRemoval(object2);
                return;
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException(exception);
            }
        }
    }

    protected V initialValue() {
        return null;
    }

    protected void onRemoval(V v) {
    }
}

