/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BoundedInputStream
extends FilterInputStream {
    private final int maxBytesRead;
    private int numRead;

    public BoundedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.maxBytesRead = ObjectUtil.checkPositive(n, "maxRead");
    }

    public BoundedInputStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    @Override
    public final int read() {
        this.checkMaxBytesRead();
        int n = super.read();
        if (n != -1) {
            ++this.numRead;
        }
        return n;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        this.checkMaxBytesRead();
        n2 = Math.min(n2, this.maxBytesRead - this.numRead + 1);
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.numRead += n3;
        }
        return n3;
    }

    private void checkMaxBytesRead() {
        if (this.numRead > this.maxBytesRead) {
            throw new IOException("Maximum number of bytes read: " + this.numRead);
        }
    }
}

