/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

public final class IndexedQueueSizeUtil {
    public static final int PLAIN_DIVISOR = 1;
    public static final int IGNORE_PARITY_DIVISOR = 2;

    public static int size(IndexedQueue indexedQueue, int n) {
        long l;
        long l2;
        long l3 = indexedQueue.lvConsumerIndex();
        do {
            l2 = l3;
            l = indexedQueue.lvProducerIndex();
        } while (l2 != (l3 = indexedQueue.lvConsumerIndex()));
        long l4 = (l - l3) / (long)n;
        return IndexedQueueSizeUtil.sanitizedSize(indexedQueue.capacity(), l4);
    }

    public static int sanitizedSize(int n, long l) {
        if (l < 0L) {
            return 0;
        }
        if (n != -1 && l > (long)n) {
            return n;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static boolean isEmpty(IndexedQueue indexedQueue) {
        return indexedQueue.lvConsumerIndex() >= indexedQueue.lvProducerIndex();
    }

    public static interface IndexedQueue {
        public long lvConsumerIndex();

        public long lvProducerIndex();

        public int capacity();
    }
}

