/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.e.a.i;
import org.e.c.a.a;
import org.e.c.a.b;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Exception;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5BytestreamRequest
implements BytestreamRequest {
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    private static final int BLACKLIST_MAX_SIZE = 100;
    private static final a<String, Integer> ADDRESS_BLACKLIST = new b(100, 0x6DDD00L);
    private static int DEFAULT_CONNECTION_FAILURE_THRESHOLD = 2;
    private int connectionFailureThreshold = DEFAULT_CONNECTION_FAILURE_THRESHOLD;
    private Bytestream bytestreamRequest;
    private Socks5BytestreamManager manager;
    private int totalConnectTimeout = 10000;
    private int minimumConnectTimeout = 2000;

    public static int getDefaultConnectFailureThreshold() {
        return DEFAULT_CONNECTION_FAILURE_THRESHOLD;
    }

    public static void setDefaultConnectFailureThreshold(int n) {
        DEFAULT_CONNECTION_FAILURE_THRESHOLD = n;
    }

    public int getConnectFailureThreshold() {
        return this.connectionFailureThreshold;
    }

    public void setConnectFailureThreshold(int n) {
        this.connectionFailureThreshold = n;
    }

    protected Socks5BytestreamRequest(Socks5BytestreamManager socks5BytestreamManager, Bytestream bytestream) {
        this.manager = socks5BytestreamManager;
        this.bytestreamRequest = bytestream;
    }

    public int getTotalConnectTimeout() {
        if (this.totalConnectTimeout <= 0) {
            return 10000;
        }
        return this.totalConnectTimeout;
    }

    public void setTotalConnectTimeout(int n) {
        this.totalConnectTimeout = n;
    }

    public int getMinimumConnectTimeout() {
        if (this.minimumConnectTimeout <= 0) {
            return 2000;
        }
        return this.minimumConnectTimeout;
    }

    public void setMinimumConnectTimeout(int n) {
        this.minimumConnectTimeout = n;
    }

    @Override
    public i getFrom() {
        return this.bytestreamRequest.getFrom();
    }

    @Override
    public String getSessionID() {
        return this.bytestreamRequest.getSessionID();
    }

    @Override
    public Socks5BytestreamSession accept() {
        Object object = this.bytestreamRequest.getStreamHosts();
        HashMap<Bytestream.StreamHost, Exception> hashMap = new HashMap<Bytestream.StreamHost, Exception>();
        if (object.size() == 0) {
            this.cancelRequest(hashMap);
        }
        Bytestream.StreamHost streamHost = null;
        Socket socket = null;
        String string = Socks5Utils.createDigest(this.bytestreamRequest.getSessionID(), this.bytestreamRequest.getFrom(), (i)this.manager.getConnection().getUser());
        int n = Math.max(this.getTotalConnectTimeout() / object.size(), this.getMinimumConnectTimeout());
        object = object.iterator();
        while (object.hasNext()) {
            Bytestream.StreamHost streamHost2 = (Bytestream.StreamHost)object.next();
            String string2 = streamHost2.getAddress() + ":" + streamHost2.getPort();
            int n2 = Socks5BytestreamRequest.getConnectionFailures(string2);
            if (this.connectionFailureThreshold > 0 && n2 >= this.connectionFailureThreshold) continue;
            try {
                Socks5Client socks5Client = new Socks5Client(streamHost2, string);
                socket = socks5Client.getSocket(n);
                streamHost = streamHost2;
                break;
            }
            catch (IOException | TimeoutException | SmackException | XMPPException throwable) {
                hashMap.put(streamHost2, (Exception)throwable);
                Socks5BytestreamRequest.incrementConnectionFailures(string2);
            }
        }
        if (streamHost == null || socket == null) {
            this.cancelRequest(hashMap);
        }
        object = this.createUsedHostResponse(streamHost);
        this.manager.getConnection().sendStanza((Stanza)object);
        return new Socks5BytestreamSession(socket, streamHost.getJID().a((CharSequence)this.bytestreamRequest.getFrom()));
    }

    @Override
    public void reject() {
        this.manager.replyRejectPacket(this.bytestreamRequest);
    }

    private void cancelRequest(Map<Bytestream.StreamHost, Exception> object) {
        String string;
        Socks5Exception.NoSocks5StreamHostsProvided noSocks5StreamHostsProvided;
        if (object.isEmpty()) {
            noSocks5StreamHostsProvided = new Socks5Exception.NoSocks5StreamHostsProvided();
            object = null;
            string = noSocks5StreamHostsProvided.getMessage();
        } else {
            noSocks5StreamHostsProvided = null;
            object = Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host.construct(object);
            string = object.getMessage();
        }
        string = StanzaError.from((StanzaError.Condition)StanzaError.Condition.item_not_found, (String)string).build();
        string = IQ.createErrorResponse((IQ)this.bytestreamRequest, (StanzaError)string);
        this.manager.getConnection().sendStanza((Stanza)string);
        if (noSocks5StreamHostsProvided != null) {
            throw noSocks5StreamHostsProvided;
        }
        throw object;
    }

    private Bytestream createUsedHostResponse(Bytestream.StreamHost streamHost) {
        Bytestream bytestream = new Bytestream(this.bytestreamRequest.getSessionID());
        bytestream.setTo(this.bytestreamRequest.getFrom());
        bytestream.setType(IQ.Type.result);
        bytestream.setStanzaId(this.bytestreamRequest.getStanzaId());
        bytestream.setUsedHost(streamHost.getJID());
        return bytestream;
    }

    private static void incrementConnectionFailures(String string) {
        Integer n = (Integer)ADDRESS_BLACKLIST.a((Object)string);
        ADDRESS_BLACKLIST.put((Object)string, (Object)(n == null ? 1 : n + 1));
    }

    private static int getConnectionFailures(String object) {
        if ((object = (Integer)ADDRESS_BLACKLIST.a(object)) != null) {
            return (Integer)object;
        }
        return 0;
    }
}

