/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.packet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class Privacy
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:privacy";
    private boolean declineActiveList = false;
    private String activeName;
    private boolean declineDefaultList = false;
    private String defaultName;
    private final Map<String, List<PrivacyItem>> itemLists = new HashMap<String, List<PrivacyItem>>();

    public Privacy() {
        super(ELEMENT, NAMESPACE);
    }

    public List<PrivacyItem> setPrivacyList(String string, List<PrivacyItem> list) {
        this.getItemLists().put(string, list);
        return list;
    }

    public List<PrivacyItem> setActivePrivacyList() {
        Privacy privacy = this;
        privacy.setActiveName(privacy.getDefaultName());
        return this.getItemLists().get(this.getActiveName());
    }

    public void deletePrivacyList(String string) {
        this.getItemLists().remove(string);
        if (this.getDefaultName() != null && string.equals(this.getDefaultName())) {
            this.setDefaultName(null);
        }
    }

    public List<PrivacyItem> getActivePrivacyList() {
        if (this.getActiveName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getActiveName());
    }

    public List<PrivacyItem> getDefaultPrivacyList() {
        if (this.getDefaultName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getDefaultName());
    }

    public List<PrivacyItem> getPrivacyList(String string) {
        return this.getItemLists().get(string);
    }

    public PrivacyItem getItem(String string, int n) {
        return this.getItem(string, UInt32.from((long)n));
    }

    public PrivacyItem getItem(String object, UInt32 uInt32) {
        object = this.getPrivacyList((String)object).iterator();
        PrivacyItem privacyItem = null;
        while (privacyItem == null && object.hasNext()) {
            PrivacyItem privacyItem2 = (PrivacyItem)object.next();
            if (!privacyItem2.getOrder().equals((Object)uInt32)) continue;
            privacyItem = privacyItem2;
        }
        return privacyItem;
    }

    public boolean changeDefaultList(String string) {
        if (this.getItemLists().containsKey(string)) {
            this.setDefaultName(string);
            return true;
        }
        return false;
    }

    public void deleteList(String string) {
        this.getItemLists().remove(string);
    }

    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String string) {
        this.activeName = string;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    public Map<String, List<PrivacyItem>> getItemLists() {
        return this.itemLists;
    }

    public boolean isDeclineActiveList() {
        return this.declineActiveList;
    }

    public void setDeclineActiveList(boolean bl) {
        this.declineActiveList = bl;
    }

    public boolean isDeclineDefaultList() {
        return this.declineDefaultList;
    }

    public void setDeclineDefaultList(boolean bl) {
        this.declineDefaultList = bl;
    }

    public Set<String> getPrivacyListNames() {
        return this.itemLists.keySet();
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.rightAngleBracket();
        if (this.isDeclineActiveList()) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<active/>");
        } else if (this.getActiveName() != null) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<active name=\"").escape(this.getActiveName()).append((CharSequence)"\"/>");
        }
        if (this.isDeclineDefaultList()) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<default/>");
        } else if (this.getDefaultName() != null) {
            iQChildElementXmlStringBuilder.append((CharSequence)"<default name=\"").escape(this.getDefaultName()).append((CharSequence)"\"/>");
        }
        for (Map.Entry<String, List<PrivacyItem>> entry : this.getItemLists().entrySet()) {
            String string = entry.getKey();
            List<PrivacyItem> object = entry.getValue();
            if (object.isEmpty()) {
                iQChildElementXmlStringBuilder.append((CharSequence)"<list name=\"").escape(string).append((CharSequence)"\"/>");
            } else {
                iQChildElementXmlStringBuilder.append((CharSequence)"<list name=\"").escape(string).append((CharSequence)"\">");
            }
            for (PrivacyItem privacyItem : object) {
                iQChildElementXmlStringBuilder.append((CharSequence)privacyItem.toXML());
            }
            if (object.isEmpty()) continue;
            iQChildElementXmlStringBuilder.append((CharSequence)"</list>");
        }
        return iQChildElementXmlStringBuilder;
    }
}

