/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.entropy;

import dorkbox.util.Sys;
import dorkbox.util.entropy.EntropyProvider;
import dorkbox.util.entropy.SimpleEntropy;
import dorkbox.util.exceptions.InitializationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J/\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ldorkbox/util/entropy/Entropy;", "", "()V", "provider", "Ldorkbox/util/entropy/EntropyProvider;", "version", "", "getVersion", "()Ljava/lang/String;", "get", "", "messageForUser", "init", "", "providerClass", "Ljava/lang/Class;", "args", "", "(Ljava/lang/Class;[Ljava/lang/Object;)V", "Utilities"})
public final class Entropy {
    public static final Entropy INSTANCE = new Entropy();
    private static final String version = Sys.INSTANCE.getVersion();
    private static EntropyProvider provider;

    private Entropy() {
    }

    public final String getVersion() {
        return version;
    }

    public final byte[] get(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.init(SimpleEntropy.class, new Object[0]);
        try {
            EntropyProvider entropyProvider = provider;
            Intrinsics.checkNotNull((Object)entropyProvider);
            object = entropyProvider.get((String)object);
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger(Entropy.class);
            StringBuilder stringBuilder = new StringBuilder("Unable to get entropy bytes for ");
            EntropyProvider entropyProvider = provider;
            Intrinsics.checkNotNull((Object)entropyProvider);
            String string = stringBuilder.append(entropyProvider.getClass()).toString();
            logger.error(string, (Throwable)exception);
            throw new InitializationException(string);
        }
        return object;
    }

    public final void init(Class<? extends EntropyProvider> object, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Class<Entropy> clazz = Entropy.class;
        synchronized (Entropy.class) {
            if (provider == null) {
                try {
                    EntropyProvider entropyProvider;
                    if (objectArray.length == 0) {
                        entropyProvider = ((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        Object[] objectArray2 = new Object[1];
                        Object[] objectArray3 = objectArray2;
                        objectArray2[0] = objectArray;
                        entropyProvider = ((Class)object).getDeclaredConstructor(new Class[0]).newInstance(objectArray3);
                    }
                    provider = entropyProvider;
                }
                catch (Exception exception) {
                    Logger logger = LoggerFactory.getLogger(Entropy.class);
                    object = "Unable to create entropy provider for " + object + " with " + objectArray.length + " args";
                    logger.error((String)object, (Throwable)exception);
                    throw new InitializationException((String)object);
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }
}

