/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public DefaultMessageSizeEstimator(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"unknownSize");
        this.handle = new HandleImpl(n);
    }

    @Override
    public final MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int n) {
            this.unknownSize = n;
        }

        @Override
        public final int size(Object object) {
            if (object instanceof ByteBuf) {
                return ((ByteBuf)object).readableBytes();
            }
            if (object instanceof ByteBufHolder) {
                return ((ByteBufHolder)object).content().readableBytes();
            }
            if (object instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

