/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Iterator;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> socketOption) {
        super(socketOption.name());
        this.option = socketOption;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> socketOption) {
        return new NioChannelOption<T>(socketOption);
    }

    static <T> boolean setOption(Channel channel, NioChannelOption<T> nioChannelOption, T t) {
        if (!(channel = (NetworkChannel)channel).supportedOptions().contains(nioChannelOption.option)) {
            return false;
        }
        if (channel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            channel.setOption(nioChannelOption.option, t);
            return true;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    static <T> T getOption(Channel channel, NioChannelOption<T> nioChannelOption) {
        if (!(channel = (NetworkChannel)channel).supportedOptions().contains(nioChannelOption.option)) {
            return null;
        }
        if (channel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return channel.getOption(nioChannelOption.option);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    static ChannelOption[] getOptions(Channel channelOptionArray) {
        channelOptionArray = (NetworkChannel)channelOptionArray;
        SocketOption<?> socketOption = channelOptionArray.supportedOptions();
        if (channelOptionArray instanceof ServerSocketChannel) {
            channelOptionArray = new ArrayList(socketOption.size());
            Iterator<SocketOption<?>> iterator = socketOption.iterator();
            while (iterator.hasNext()) {
                socketOption = iterator.next();
                if (socketOption == StandardSocketOptions.IP_TOS) continue;
                channelOptionArray.add(new NioChannelOption(socketOption));
            }
            return channelOptionArray.toArray(new ChannelOption[0]);
        }
        channelOptionArray = new ChannelOption[socketOption.size()];
        int n = 0;
        socketOption = socketOption.iterator();
        while (socketOption.hasNext()) {
            SocketOption socketOption2 = (SocketOption)socketOption.next();
            channelOptionArray[n++] = new NioChannelOption(socketOption2);
        }
        return channelOptionArray;
    }
}

