/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> clazz) {
        this(clazz, true);
    }

    protected MessageToByteEncoder(boolean bl) {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToByteEncoder.class, (String)"I");
        this.preferDirect = bl;
    }

    protected MessageToByteEncoder(Class<? extends I> clazz, boolean bl) {
        this.matcher = TypeParameterMatcher.get(clazz);
        this.preferDirect = bl;
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.matcher.match(object);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        ByteBuf byteBuf = null;
        try {
            try {
                if (this.acceptOutboundMessage(object)) {
                    byteBuf = this.allocateBuffer(channelHandlerContext, object, this.preferDirect);
                    try {
                        this.encode(channelHandlerContext, object, byteBuf);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)object);
                    }
                    if (byteBuf.isReadable()) {
                        channelHandlerContext.write((Object)byteBuf, channelPromise);
                    } else {
                        byteBuf.release();
                        channelHandlerContext.write((Object)Unpooled.EMPTY_BUFFER, channelPromise);
                    }
                } else {
                    channelHandlerContext.write(object, channelPromise);
                    return;
                }
                byteBuf = null;
            }
            catch (EncoderException encoderException) {
                object = encoderException;
                throw encoderException;
            }
            catch (Throwable throwable) {
                throw new EncoderException(throwable);
            }
        }
        catch (Throwable throwable) {
            if (byteBuf != null) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, I i, boolean bl) {
        if (bl) {
            return channelHandlerContext.alloc().ioBuffer();
        }
        return channelHandlerContext.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3);

    protected boolean isPreferDirect() {
        return this.preferDirect;
    }
}

