/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.Signal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf byteBuf) {
        this.setCumulation(byteBuf);
    }

    final void setCumulation(ByteBuf byteBuf) {
        this.buffer = byteBuf;
    }

    final void terminate() {
        this.terminated = true;
    }

    public final int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    public final ByteBuf capacity(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int maxCapacity() {
        return this.capacity();
    }

    public final ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    public final boolean isReadOnly() {
        return false;
    }

    public final ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public final boolean hasArray() {
        return false;
    }

    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMemoryAddress() {
        return false;
    }

    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public final ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int compareTo(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.copy(n, n2);
    }

    public final ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf ensureWritable(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int ensureWritable(int n, boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final boolean getBoolean(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getBoolean(n);
    }

    public final byte getByte(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getByte(n);
    }

    public final short getUnsignedByte(int n) {
        this.checkIndex(n, 1);
        return this.buffer.getUnsignedByte(n);
    }

    public final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex(n, n3);
        this.buffer.getBytes(n, byArray, n2, n3);
        return this;
    }

    public final ByteBuf getBytes(int n, byte[] byArray) {
        this.checkIndex(n, byArray.length);
        this.buffer.getBytes(n, byArray);
        return this;
    }

    public final ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex(n, n3);
        this.buffer.getBytes(n, byteBuf, n2, n3);
        return this;
    }

    public final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf getBytes(int n, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int getInt(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getInt(n);
    }

    public final int getIntLE(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getIntLE(n);
    }

    public final long getUnsignedInt(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getUnsignedInt(n);
    }

    public final long getUnsignedIntLE(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getUnsignedIntLE(n);
    }

    public final long getLong(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getLong(n);
    }

    public final long getLongLE(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getLongLE(n);
    }

    public final int getMedium(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getMedium(n);
    }

    public final int getMediumLE(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getMediumLE(n);
    }

    public final int getUnsignedMedium(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getUnsignedMedium(n);
    }

    public final int getUnsignedMediumLE(int n) {
        this.checkIndex(n, 3);
        return this.buffer.getUnsignedMediumLE(n);
    }

    public final short getShort(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getShort(n);
    }

    public final short getShortLE(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getShortLE(n);
    }

    public final int getUnsignedShort(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getUnsignedShort(n);
    }

    public final int getUnsignedShortLE(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getUnsignedShortLE(n);
    }

    public final char getChar(int n) {
        this.checkIndex(n, 2);
        return this.buffer.getChar(n);
    }

    public final float getFloat(int n) {
        this.checkIndex(n, 4);
        return this.buffer.getFloat(n);
    }

    public final double getDouble(int n) {
        this.checkIndex(n, 8);
        return this.buffer.getDouble(n);
    }

    public final CharSequence getCharSequence(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return this.buffer.getCharSequence(n, n2, charset);
    }

    public final int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int indexOf(int n, int n2, byte by) {
        if (n == n2) {
            return -1;
        }
        if (Math.max(n, n2) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(n, n2, by);
    }

    public final int bytesBefore(byte by) {
        int n = this.buffer.bytesBefore(by);
        by = (byte)n;
        if (n < 0) {
            throw REPLAY;
        }
        return by;
    }

    public final int bytesBefore(int n, byte by) {
        ReplayingDecoderByteBuf replayingDecoderByteBuf = this;
        return replayingDecoderByteBuf.bytesBefore(replayingDecoderByteBuf.buffer.readerIndex(), n, by);
    }

    public final int bytesBefore(int n, int n2, byte by) {
        int n3 = this.buffer.writerIndex();
        if (n >= n3) {
            throw REPLAY;
        }
        if (n <= n3 - n2) {
            return this.buffer.bytesBefore(n, n2, by);
        }
        if ((n = this.buffer.bytesBefore(n, n3 - n, by)) < 0) {
            throw REPLAY;
        }
        return n;
    }

    public final int forEachByte(ByteProcessor byteProcessor) {
        int n = this.buffer.forEachByte(byteProcessor);
        if (n < 0) {
            throw REPLAY;
        }
        return n;
    }

    public final int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        int n3 = this.buffer.writerIndex();
        if (n >= n3) {
            throw REPLAY;
        }
        if (n <= n3 - n2) {
            return this.buffer.forEachByte(n, n2, byteProcessor);
        }
        if ((n = this.buffer.forEachByte(n, n3 - n, byteProcessor)) < 0) {
            throw REPLAY;
        }
        return n;
    }

    public final int forEachByteDesc(ByteProcessor byteProcessor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(byteProcessor);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        if (n + n2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(n, n2, byteProcessor);
    }

    public final ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    public final ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteOrder order() {
        return this.buffer.order();
    }

    public final ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull((Object)byteOrder, (String)"endianness") == this.order()) {
            return this;
        }
        byteOrder = this.swapped;
        if (byteOrder == null) {
            byteOrder = new SwappedByteBuf((ByteBuf)this);
            this.swapped = byteOrder;
        }
        return byteOrder;
    }

    public final boolean isReadable() {
        return !this.terminated || this.buffer.isReadable();
    }

    public final boolean isReadable(int n) {
        return !this.terminated || this.buffer.isReadable(n);
    }

    public final int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    public final boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    public final byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    public final short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    public final ByteBuf readBytes(byte[] byArray, int n, int n2) {
        this.checkReadableBytes(n2);
        this.buffer.readBytes(byArray, n, n2);
        return this;
    }

    public final ByteBuf readBytes(byte[] byArray) {
        this.checkReadableBytes(byArray.length);
        this.buffer.readBytes(byArray);
        return this;
    }

    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        this.checkReadableBytes(n2);
        this.buffer.readBytes(byteBuf, n, n2);
        return this;
    }

    public final ByteBuf readBytes(ByteBuf byteBuf, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf readBytes(ByteBuf byteBuf) {
        this.checkReadableBytes(byteBuf.writableBytes());
        this.buffer.readBytes(byteBuf);
        return this;
    }

    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int readBytes(FileChannel fileChannel, long l, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf readBytes(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readBytes(n);
    }

    public final ByteBuf readSlice(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readSlice(n);
    }

    public final ByteBuf readRetainedSlice(int n) {
        this.checkReadableBytes(n);
        return this.buffer.readRetainedSlice(n);
    }

    public final ByteBuf readBytes(OutputStream outputStream, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int readerIndex() {
        return this.buffer.readerIndex();
    }

    public final ByteBuf readerIndex(int n) {
        this.buffer.readerIndex(n);
        return this;
    }

    public final int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    public final int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    public final long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    public final long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    public final long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    public final long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    public final int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    public final int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    public final int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    public final int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    public final short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    public final short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    public final int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    public final int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    public final char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    public final float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    public final double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    public final CharSequence readCharSequence(int n, Charset charset) {
        this.checkReadableBytes(n);
        return this.buffer.readCharSequence(n, charset);
    }

    public final ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public final ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBoolean(int n, boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setByte(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int n, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int n, InputStream inputStream, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setZero(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setIndex(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setInt(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setIntLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setLong(int n, long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setLongLE(int n, long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setMedium(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setMediumLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setShort(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setShortLE(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setChar(int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setFloat(int n, float f) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setDouble(int n, double d) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf skipBytes(int n) {
        this.checkReadableBytes(n);
        this.buffer.skipBytes(n);
        return this;
    }

    public final ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf slice(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.slice(n, n2);
    }

    public final ByteBuf retainedSlice(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.retainedSlice(n, n2);
    }

    public final int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public final ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.nioBuffer(n, n2);
    }

    public final ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.nioBuffers(n, n2);
    }

    public final ByteBuffer internalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this.buffer.internalNioBuffer(n, n2);
    }

    public final String toString(int n, int n2, Charset charset) {
        this.checkIndex(n, n2);
        return this.buffer.toString(n, n2, charset);
    }

    public final String toString(Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    public final boolean isWritable() {
        return false;
    }

    public final boolean isWritable(int n) {
        return false;
    }

    public final int writableBytes() {
        return 0;
    }

    public final int maxWritableBytes() {
        return 0;
    }

    public final ByteBuf writeBoolean(boolean bl) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeByte(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(byte[] byArray, int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(InputStream inputStream, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(FileChannel fileChannel, long l, int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeInt(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeIntLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeLong(long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeLongLE(long l) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeMedium(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeMediumLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeZero(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writerIndex() {
        return this.buffer.writerIndex();
    }

    public final ByteBuf writerIndex(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeShort(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeShortLE(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeChar(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeFloat(float f) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeDouble(double d) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setCharSequence(int n, CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    private void checkIndex(int n, int n2) {
        if (n + n2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int n) {
        if (this.buffer.readableBytes() < n) {
            throw REPLAY;
        }
    }

    public final ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int refCnt() {
        return this.buffer.refCnt();
    }

    public final ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retain(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    public final ByteBuf touch(Object object) {
        this.buffer.touch(object);
        return this;
    }

    public final boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final boolean release(int n) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

