/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int idx;
    private int lastReaderIndex;
    private int state;
    private boolean insideString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int n) {
        this(n, false);
    }

    public JsonObjectDecoder(boolean bl) {
        this(0x100000, bl);
    }

    public JsonObjectDecoder(int n, boolean bl) {
        this.maxObjectLength = ObjectUtil.checkPositive((int)n, (String)"maxObjectLength");
        this.streamArrayElements = bl;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n;
        int n2;
        if (this.state == -1) {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            return;
        }
        if (this.idx > byteBuf.readerIndex() && this.lastReaderIndex != byteBuf.readerIndex()) {
            this.idx = byteBuf.readerIndex() + (this.idx - this.lastReaderIndex);
        }
        if ((n2 = byteBuf.writerIndex()) > this.maxObjectLength) {
            ByteBuf byteBuf3 = byteBuf;
            byteBuf3.skipBytes(byteBuf3.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + n2 + " bytes discarded");
        }
        for (n = this.idx; n < n2; ++n) {
            ByteBuf byteBuf4;
            byte by = byteBuf.getByte(n);
            if (this.state == 1) {
                this.decodeByte(by, byteBuf, n);
                if (this.openBraces != 0) continue;
                ByteBuf byteBuf5 = byteBuf;
                byteBuf4 = this.extractObject(channelHandlerContext, byteBuf5, byteBuf5.readerIndex(), n + 1 - byteBuf.readerIndex());
                if (byteBuf4 != null) {
                    list.add(byteBuf4);
                }
                byteBuf.readerIndex(n + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                this.decodeByte(by, byteBuf, n);
                if (this.insideString || (this.openBraces != 1 || by != 44) && (this.openBraces != 0 || by != 93)) continue;
                int n3 = byteBuf.readerIndex();
                while (Character.isWhitespace(byteBuf.getByte(n3))) {
                    byteBuf.skipBytes(1);
                    ++n3;
                }
                for (n3 = n - 1; n3 >= byteBuf.readerIndex() && Character.isWhitespace(byteBuf.getByte(n3)); --n3) {
                }
                ByteBuf byteBuf6 = byteBuf;
                byteBuf4 = this.extractObject(channelHandlerContext, byteBuf6, byteBuf6.readerIndex(), n3 + 1 - byteBuf.readerIndex());
                if (byteBuf4 != null) {
                    list.add(byteBuf4);
                }
                byteBuf.readerIndex(n + 1);
                if (by != 93) continue;
                this.reset();
                continue;
            }
            if (by == 123 || by == 91) {
                this.initDecoding(by);
                if (this.state != 2) continue;
                byteBuf.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(by)) {
                byteBuf.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + n + ": " + ByteBufUtil.hexDump((ByteBuf)byteBuf));
        }
        this.idx = byteBuf.readableBytes() == 0 ? 0 : n;
        this.lastReaderIndex = byteBuf.readerIndex();
    }

    protected ByteBuf extractObject(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n, int n2) {
        return byteBuf.retainedSlice(n, n2);
    }

    private void decodeByte(byte by, ByteBuf byteBuf, int n) {
        if (!(by != 123 && by != 91 || this.insideString)) {
            ++this.openBraces;
            return;
        }
        if (!(by != 125 && by != 93 || this.insideString)) {
            --this.openBraces;
            return;
        }
        if (by == 34) {
            if (!this.insideString) {
                this.insideString = true;
                return;
            }
            by = 0;
            --n;
            while (n >= 0 && byteBuf.getByte(n) == 92) {
                by = (byte)(by + 1);
                --n;
            }
            if (by % 2 == 0) {
                this.insideString = false;
            }
        }
    }

    private void initDecoding(byte by) {
        this.openBraces = 1;
        if (by == 91 && this.streamArrayElements) {
            this.state = 2;
            return;
        }
        this.state = 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

