/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElementSerializersKt;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonExceptionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lkotlinx/serialization/json/JsonLiteralSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonLiteral;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "kotlinx-serialization-json"})
final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"kotlinx.serialization.json.JsonLiteral", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private JsonLiteralSerializer() {
    }

    public final SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public final void serialize(Encoder encoder, JsonLiteral jsonLiteral) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter((Object)jsonLiteral, (String)"");
        JsonElementSerializersKt.access$verify(encoder);
        if (((JsonPrimitive)jsonLiteral).isString()) {
            encoder.encodeString(((JsonPrimitive)jsonLiteral).getContent());
            return;
        }
        if (jsonLiteral.getCoerceToInlineType$kotlinx_serialization_json() != null) {
            encoder.encodeInline(jsonLiteral.getCoerceToInlineType$kotlinx_serialization_json()).encodeString(((JsonPrimitive)jsonLiteral).getContent());
            return;
        }
        Constable constable = StringsKt.toLongOrNull((String)((JsonPrimitive)jsonLiteral).getContent());
        if (constable != null) {
            long l = ((Number)((Object)constable)).longValue();
            encoder.encodeLong(l);
            return;
        }
        constable = UStringsKt.toULongOrNull((String)((JsonPrimitive)jsonLiteral).getContent());
        if (constable != null) {
            long l = constable.unbox-impl();
            encoder.encodeInline(BuiltinSerializersKt.serializer((ULong.Companion)ULong.Companion).getDescriptor()).encodeLong(l);
            return;
        }
        constable = StringsKt.toDoubleOrNull((String)((JsonPrimitive)jsonLiteral).getContent());
        if (constable != null) {
            double d = ((Number)((Object)constable)).doubleValue();
            encoder.encodeDouble(d);
            return;
        }
        constable = StringsKt.toBooleanStrictOrNull((String)((JsonPrimitive)jsonLiteral).getContent());
        if (constable != null) {
            boolean bl = (Boolean)constable;
            encoder.encodeBoolean(bl);
            return;
        }
        encoder.encodeString(((JsonPrimitive)jsonLiteral).getContent());
    }

    public final JsonLiteral deserialize(Decoder object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = JsonElementSerializersKt.asJsonDecoder((Decoder)object).decodeJsonElement();
        if (!(object instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(object.getClass()), object.toString());
        }
        return (JsonLiteral)object;
    }
}

