/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.ChunkedDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001UB1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020!H\u0016J!\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020\u0013H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020*H\u0002J;\u00100\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\b\u00102\u001a\u0004\u0018\u0001H#H\u0016\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u00105\u001a\u00020\u001bH\u0002J\u0018\u00106\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u00108\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0015H\u0002J\b\u0010:\u001a\u00020\u001bH\u0002J\b\u0010;\u001a\u00020\u0013H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u001bH\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020\u0015H\u0002J\b\u0010J\u001a\u00020\u0015H\u0016J+\u0010K\u001a\u00020*2!\u0010L\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(P\u0012\u0004\u0012\u00020*0MH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010S\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/ChunkedDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "lexer", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "discriminatorHolder", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;)V", "getJson", "()Lkotlinx/serialization/json/Json;", "trySkip", "", "unknownKey", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentIndex", "", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "skipLeftoverElements", "decodeNotNullMark", "decodeNull", "", "checkLeadingComma", "decodeSerializableElement", "index", "previousValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeElementIndex", "decodeMapIndex", "coerceInputValue", "decodeObjectIndex", "handleUnknown", "key", "decodeListIndex", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeFloat", "", "decodeDouble", "", "decodeChar", "", "decodeStringKey", "decodeString", "decodeStringChunked", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "chunk", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeEnum", "enumDescriptor", "DiscriminatorHolder", "kotlinx-serialization-json"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements ChunkedDecoder,
JsonDecoder {
    private final Json json;
    private final WriteMode mode;
    public final AbstractJsonLexer lexer;
    private final SerializersModule serializersModule;
    private int currentIndex;
    private DiscriminatorHolder discriminatorHolder;
    private final JsonConfiguration configuration;
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(Json json, WriteMode writeMode, AbstractJsonLexer abstractJsonLexer, SerialDescriptor serialDescriptor, DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)writeMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        this.json = json;
        this.mode = writeMode;
        this.lexer = abstractJsonLexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(serialDescriptor);
    }

    @Override
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder discriminatorHolder, String string) {
        if (discriminatorHolder == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)discriminatorHolder.discriminatorToSkip, (Object)string)) {
            discriminatorHolder.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        try {
            if (!(object instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return (T)object.deserialize((Decoder)this);
            }
            String string = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)object).getDescriptor(), this.json);
            String string2 = this.lexer.peekLeadingMatchingValue(string, this.configuration.isLenient());
            if (string2 == null) {
                JsonDecoder jsonDecoder = this;
                if (!(object instanceof AbstractPolymorphicSerializer) || jsonDecoder.getJson().getConfiguration().getUseArrayPolymorphism()) {
                    return (T)object.deserialize((Decoder)jsonDecoder);
                }
                string = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)object).getDescriptor(), jsonDecoder.getJson());
                JsonElement jsonElement = jsonDecoder.decodeJsonElement();
                String string3 = ((AbstractPolymorphicSerializer)object).getDescriptor().getSerialName();
                if (!(jsonElement instanceof JsonObject)) {
                    object = new StringBuilder("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName()).append(" as the serialized body of ").append(string3).append(" at element: ");
                    string = this.lexer.path.getPath();
                    throw JsonExceptionsKt.JsonDecodingException(-1, ((StringBuilder)object).append(string).toString(), jsonElement.toString());
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)string);
                jsonElement = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
                try {
                    object = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)object), (CompositeDecoder)jsonDecoder, (String)((Object)jsonElement));
                }
                catch (SerializationException serializationException) {
                    String string4 = serializationException.getMessage();
                    Intrinsics.checkNotNull((Object)string4);
                    throw JsonExceptionsKt.JsonDecodingException(-1, string4, jsonObject.toString());
                }
                Intrinsics.checkNotNull((Object)object);
                string3 = object;
                return TreeJsonDecoderKt.readPolymorphicJson(jsonDecoder.getJson(), string, jsonObject, string3);
            }
            String string5 = string2;
            try {
                object = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)((AbstractPolymorphicSerializer)object), (CompositeDecoder)this, (String)string5);
            }
            catch (SerializationException serializationException) {
                object = serializationException;
                String string6 = serializationException.getMessage();
                Intrinsics.checkNotNull((Object)string6);
                string = StringsKt.removeSuffix((String)StringsKt.substringBefore$default((String)string6, (char)'\n', null, (int)2, null), (CharSequence)".");
                String string7 = object.getMessage();
                Intrinsics.checkNotNull((Object)string7);
                String string8 = StringsKt.substringAfter((String)string7, (char)'\n', (String)"");
                AbstractJsonLexer.fail$default(this.lexer, string, 0, string8, 2, null);
                throw new KotlinNothingValueException();
            }
            string5 = object;
            Intrinsics.checkNotNull((Object)string5);
            object = string5;
            this.discriminatorHolder = new DiscriminatorHolder(string);
            return (T)object.deserialize((Decoder)this);
        }
        catch (MissingFieldException missingFieldException) {
            MissingFieldException missingFieldException2 = missingFieldException;
            String string = missingFieldException.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"at path", (boolean)false, (int)2, null)) {
                throw missingFieldException2;
            }
            throw new MissingFieldException(missingFieldException2.getMissingFields(), missingFieldException2.getMessage() + " at path: " + this.lexer.path.getPath(), (Throwable)missingFieldException2);
        }
    }

    public CompositeDecoder beginStructure(SerialDescriptor serialDescriptor) {
        StreamingJsonDecoder streamingJsonDecoder;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        WriteMode writeMode = WriteModeKt.switchMode(this.json, serialDescriptor);
        this.lexer.path.pushDescriptor(serialDescriptor);
        this.lexer.consumeNextToken(writeMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[writeMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                streamingJsonDecoder = new StreamingJsonDecoder(this.json, writeMode, this.lexer, serialDescriptor, this.discriminatorHolder);
                break;
            }
            default: {
                streamingJsonDecoder = this.mode == writeMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, writeMode, this.lexer, serialDescriptor, this.discriminatorHolder);
            }
        }
        return streamingJsonDecoder;
    }

    public void endStructure(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (serialDescriptor.getElementsCount() == 0 && JsonNamesMapKt.ignoreUnknownKeys(serialDescriptor, this.json)) {
            this.skipLeftoverElements(serialDescriptor);
        }
        if (this.lexer.tryConsumeComma() && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "");
            throw new KotlinNothingValueException();
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor serialDescriptor) {
        while (this.decodeElementIndex(serialDescriptor) != -1) {
        }
    }

    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && !AbstractJsonLexer.tryConsumeNull$default(this.lexer, false, 1, null);
    }

    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    public <T> T decodeSerializableElement(SerialDescriptor object, int n, DeserializationStrategy<? extends T> deserializationStrategy, T t) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        boolean bl = this.mode == WriteMode.MAP && (n & 1) == 0;
        if (bl) {
            this.lexer.path.resetCurrentMapKey();
        }
        object = super.decodeSerializableElement(object, n, deserializationStrategy, t);
        if (bl) {
            this.lexer.path.updateCurrentMapKey(object);
        }
        return (T)object;
    }

    public int decodeElementIndex(SerialDescriptor serialDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n2 = this.decodeObjectIndex(serialDescriptor);
                break;
            }
            case 2: {
                int n2 = this.decodeMapIndex();
                break;
            }
            default: {
                int n2 = n = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(n);
        }
        return n;
    }

    private final int decodeMapIndex() {
        int n = 0;
        boolean bl = this.currentIndex % 2 != 0;
        if (bl) {
            if (this.currentIndex != -1) {
                n = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (bl) {
                if (this.currentIndex == -1) {
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean bl2 = n == 0;
                    n = abstractJsonLexer.currentPosition;
                    if (!bl2) {
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Unexpected leading comma", n, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    int n2 = abstractJsonLexer.currentPosition;
                    if (n == 0) {
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected comma after the key-value pair", n2, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            ++this.currentIndex;
            return this.currentIndex;
        }
        if (n != 0 && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        return -1;
    }

    private final boolean coerceInputValue(SerialDescriptor serialDescriptor, int n) {
        Json json = this.json;
        boolean bl = serialDescriptor.isElementOptional(n);
        serialDescriptor = serialDescriptor.getElementDescriptor(n);
        if (bl && !serialDescriptor.isNullable() && this.lexer.tryConsumeNull(true)) {
            return true;
        }
        if (!(!Intrinsics.areEqual((Object)serialDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE) || serialDescriptor.isNullable() && this.lexer.tryConsumeNull(false))) {
            String string = this.lexer.peekString(this.configuration.isLenient());
            if (string != null) {
                boolean bl2;
                String string2 = string;
                int n2 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, json, string2);
                boolean bl3 = bl2 = !json.getConfiguration().getExplicitNulls() && serialDescriptor.isNullable();
                if (n2 == -3 && (bl || bl2)) {
                    this.lexer.consumeString();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor serialDescriptor) {
        boolean bl = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            int n;
            String string;
            block5: {
                string = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int n2 = JsonNamesMapKt.getJsonNameIndex(serialDescriptor, this.json, string);
                if (n2 != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(serialDescriptor, n2)) {
                        bl = this.lexer.tryConsumeComma();
                        n = 0;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return n2;
                        jsonElementMarker.mark$kotlinx_serialization_json(n2);
                        return n2;
                    }
                }
                n = n2 = 1;
            }
            if (n == 0) continue;
            bl = this.handleUnknown(serialDescriptor, string);
        }
        if (bl && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        return jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean handleUnknown(SerialDescriptor serialDescriptor, String string) {
        if (!JsonNamesMapKt.ignoreUnknownKeys(serialDescriptor, this.json)) {
            StreamingJsonDecoder streamingJsonDecoder = this;
            if (!streamingJsonDecoder.trySkip(streamingJsonDecoder.discriminatorHolder, string)) {
                this.lexer.path.popDescriptor();
                this.lexer.failOnUnknownKey(string);
                return this.lexer.tryConsumeComma();
            }
        }
        this.lexer.skipElement(this.configuration.isLenient());
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        boolean bl = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !bl) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentIndex;
            return this.currentIndex;
        }
        if (bl && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "array");
            throw new KotlinNothingValueException();
        }
        return -1;
    }

    public boolean decodeBoolean() {
        return this.lexer.consumeBooleanLenient();
    }

    public byte decodeByte() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((byte)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)l;
    }

    public short decodeShort() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((short)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)l;
    }

    public int decodeInt() {
        long l = this.lexer.consumeNumericLiteral();
        if (l != (long)((int)l)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + l + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)l;
    }

    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    public float decodeFloat() {
        float f;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String string = "float";
        String string2 = abstractJsonLexer.consumeStringLenient();
        try {
            String string3 = string2;
            f = Float.parseFloat(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(abstractJsonLexer, "Failed to parse type '" + string + "' for input '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float f2 = f;
        boolean bl = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (bl || !Float.isInfinite(f2) && !Float.isNaN(f2)) {
            return f2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(f2));
        throw new KotlinNothingValueException();
    }

    public double decodeDouble() {
        double d;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String string = "double";
        String string2 = abstractJsonLexer.consumeStringLenient();
        try {
            String string3 = string2;
            d = Double.parseDouble(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractJsonLexer.fail$default(abstractJsonLexer, "Failed to parse type '" + string + "' for input '" + string2 + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double d2 = d;
        boolean bl = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (bl || !Double.isInfinite(d2) && !Double.isNaN(d2)) {
            return d2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, d2);
        throw new KotlinNothingValueException();
    }

    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        if (this.configuration.isLenient()) {
            return this.lexer.consumeStringLenientNotNull();
        }
        return this.lexer.consumeKeyString();
    }

    public String decodeString() {
        if (this.configuration.isLenient()) {
            return this.lexer.consumeStringLenientNotNull();
        }
        return this.lexer.consumeString();
    }

    public void decodeStringChunked(Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.lexer.consumeStringChunked(this.configuration.isLenient(), function1);
    }

    public Decoder decodeInline(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        if (StreamingJsonEncoderKt.isUnsignedNumber(serialDescriptor)) {
            return (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json);
        }
        return super.decodeInline(serialDescriptor);
    }

    public int decodeEnum(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(serialDescriptor, this.json, this.decodeString(), " at path " + this.lexer.path.getPath());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "", "discriminatorToSkip", "", "<init>", "(Ljava/lang/String;)V", "kotlinx-serialization-json"})
    public static final class DiscriminatorHolder {
        public String discriminatorToSkip;

        public DiscriminatorHolder(String string) {
            this.discriminatorToSkip = string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

