/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.jna.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.jna.windows.GDI32;
import dorkbox.jna.windows.User32;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.slf4j.LoggerFactory;

public class HBITMAPWrap
extends WinDef.HBITMAP {
    private static final Object lockObject = new Object();
    private WinDef.HBITMAP bitmap;
    BufferedImage img;

    private static WinDef.HBITMAP createBitmap(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        Object object = lockObject;
        synchronized (object) {
            Object object2;
            WinDef.HDC hDC = User32.User32.GetDC(null);
            WinDef.HDC hDC2 = GDI32.CreateCompatibleDC(hDC);
            try {
                object2 = new BufferedImage(n, n2, 3);
                Graphics2D graphics2D = (Graphics2D)((BufferedImage)object2).getGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(3));
                graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
                bufferedImage = new WinGDI.BITMAPINFO();
                new WinGDI.BITMAPINFO().bmiHeader.biWidth = n;
                ((WinGDI.BITMAPINFO)bufferedImage).bmiHeader.biHeight = n2;
                ((WinGDI.BITMAPINFO)bufferedImage).bmiHeader.biPlanes = 1;
                ((WinGDI.BITMAPINFO)bufferedImage).bmiHeader.biBitCount = (short)32;
                ((WinGDI.BITMAPINFO)bufferedImage).bmiHeader.biCompression = 0;
                ((WinGDI.BITMAPINFO)bufferedImage).bmiHeader.biSizeImage = n * n2 << 2;
                graphics2D = new Memory((long)(n * n2 << 5 << 2));
                graphics2D = new PointerByReference((Pointer)graphics2D);
                bufferedImage = GDI32.CreateDIBSection(hDC2, (WinGDI.BITMAPINFO)bufferedImage, 0, (PointerByReference)graphics2D, null, 0);
                graphics2D = graphics2D.getValue();
                if (graphics2D == null) {
                    LoggerFactory.getLogger(HBITMAPWrap.class).error("The image was invalid", (Object)Kernel32Util.getLastErrorMessage());
                } else {
                    object2 = ((BufferedImage)object2).getData();
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[n * n2];
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            ((Raster)object2).getPixel(j, n2 - i - 1, nArray);
                            int n3 = nArray[2] & 0xFF;
                            int n4 = (nArray[1] & 0xFF) << 8;
                            int n5 = (nArray[0] & 0xFF) << 16;
                            int n6 = (nArray[3] & 0xFF) << 24;
                            nArray2[j + i * n] = n6 | n3 | n4 | n5;
                        }
                    }
                    graphics2D.write(0L, nArray2, 0, nArray2.length);
                }
                object2 = bufferedImage;
                User32.User32.ReleaseDC(null, hDC);
            }
            catch (Throwable throwable) {
                User32.User32.ReleaseDC(null, hDC);
                GDI32.DeleteDC(hDC2);
                throw throwable;
            }
            GDI32.DeleteDC(hDC2);
            return object2;
        }
    }

    public HBITMAPWrap(BufferedImage bufferedImage) {
        this.bitmap = HBITMAPWrap.createBitmap(bufferedImage);
        HBITMAPWrap hBITMAPWrap = this;
        hBITMAPWrap.setPointer(hBITMAPWrap.bitmap.getPointer());
        this.img = bufferedImage;
    }

    protected void finalize() {
        this.close();
        super.finalize();
    }

    public void close() {
        if (Pointer.nativeValue((Pointer)this.getPointer()) != 0L) {
            GDI32.DeleteObject((WinNT.HANDLE)this);
            this.setPointer(new Pointer(0L));
            this.bitmap = null;
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }
}

