/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml.stax;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class StaxXmlPullParser
implements XmlPullParser {
    private final XMLStreamReader xmlStreamReader;
    private int depth;
    private boolean delayedDepthDecrement;

    StaxXmlPullParser(XMLStreamReader xMLStreamReader) {
        this.xmlStreamReader = xMLStreamReader;
    }

    public final Object getProperty(String string) {
        return this.xmlStreamReader.getProperty(string);
    }

    public final String getInputEncoding() {
        return this.xmlStreamReader.getEncoding();
    }

    public final int getNamespaceCount() {
        return this.xmlStreamReader.getNamespaceCount();
    }

    public final String getNamespacePrefix(int n) {
        return this.xmlStreamReader.getNamespacePrefix(n);
    }

    public final String getNamespaceUri(int n) {
        return this.xmlStreamReader.getNamespaceURI(n);
    }

    public final String getNamespace(String string) {
        if (string == null) {
            string = "";
        }
        NamespaceContext namespaceContext = this.xmlStreamReader.getNamespaceContext();
        return namespaceContext.getNamespaceURI(string);
    }

    public final String getNamespace() {
        String string = this.getPrefix();
        return this.getNamespace(string);
    }

    public final int getDepth() {
        return this.depth;
    }

    public final String getPositionDescription() {
        Location location = this.xmlStreamReader.getLocation();
        return location.toString();
    }

    public final int getLineNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getLineNumber();
    }

    public final int getColumnNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getColumnNumber();
    }

    public final boolean isWhiteSpace() {
        return this.xmlStreamReader.isWhiteSpace();
    }

    public final String getText() {
        return this.xmlStreamReader.getText();
    }

    public final String getName() {
        QName qName = this.getQName();
        return qName.getLocalPart();
    }

    public final QName getQName() {
        return this.xmlStreamReader.getName();
    }

    public final String getPrefix() {
        return this.xmlStreamReader.getPrefix();
    }

    public final int getAttributeCount() {
        return this.xmlStreamReader.getAttributeCount();
    }

    public final String getAttributeNamespace(int n) {
        return this.xmlStreamReader.getAttributeNamespace(n);
    }

    public final String getAttributeName(int n) {
        QName qName = this.getAttributeQName(n);
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public final QName getAttributeQName(int n) {
        return this.xmlStreamReader.getAttributeName(n);
    }

    public final String getAttributePrefix(int n) {
        return this.xmlStreamReader.getAttributePrefix(n);
    }

    public final String getAttributeType(int n) {
        return this.xmlStreamReader.getAttributeType(n);
    }

    public final String getAttributeValue(int n) {
        return this.xmlStreamReader.getAttributeValue(n);
    }

    public final String getAttributeValue(String string, String string2) {
        return this.xmlStreamReader.getAttributeValue(string, string2);
    }

    public final XmlPullParser.Event getEventType() {
        int n = this.xmlStreamReader.getEventType();
        return StaxXmlPullParser.staxEventIntegerToEvent(n);
    }

    public final XmlPullParser.Event next() {
        int n;
        this.preNextEvent();
        try {
            n = this.xmlStreamReader.next();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        XmlPullParser.Event event = StaxXmlPullParser.staxEventIntegerToEvent(n);
        switch (event) {
            case START_ELEMENT: {
                ++this.depth;
                break;
            }
            case END_ELEMENT: {
                this.delayedDepthDecrement = true;
            }
        }
        return event;
    }

    public final String nextText() {
        String string;
        try {
            string = this.xmlStreamReader.getElementText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        this.delayedDepthDecrement = true;
        return string;
    }

    public final XmlPullParser.TagEvent nextTag() {
        int n;
        this.preNextEvent();
        try {
            n = this.xmlStreamReader.nextTag();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XmlPullParserException((Exception)xMLStreamException);
        }
        switch (n) {
            case 1: {
                ++this.depth;
                return XmlPullParser.TagEvent.START_ELEMENT;
            }
            case 2: {
                this.delayedDepthDecrement = true;
                return XmlPullParser.TagEvent.END_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void preNextEvent() {
        if (this.delayedDepthDecrement) {
            --this.depth;
            this.delayedDepthDecrement = false;
            assert (this.depth >= 0);
        }
    }

    private static XmlPullParser.Event staxEventIntegerToEvent(int n) {
        switch (n) {
            case 1: {
                return XmlPullParser.Event.START_ELEMENT;
            }
            case 2: {
                return XmlPullParser.Event.END_ELEMENT;
            }
            case 3: {
                return XmlPullParser.Event.PROCESSING_INSTRUCTION;
            }
            case 4: {
                return XmlPullParser.Event.TEXT_CHARACTERS;
            }
            case 5: {
                return XmlPullParser.Event.COMMENT;
            }
            case 6: {
                return XmlPullParser.Event.IGNORABLE_WHITESPACE;
            }
            case 7: {
                return XmlPullParser.Event.START_DOCUMENT;
            }
            case 8: {
                return XmlPullParser.Event.END_DOCUMENT;
            }
            case 9: {
                return XmlPullParser.Event.ENTITY_REFERENCE;
            }
            case 10: {
                return XmlPullParser.Event.OTHER;
            }
            case 11: {
                return XmlPullParser.Event.OTHER;
            }
            case 12: {
                return XmlPullParser.Event.OTHER;
            }
            case 13: {
                return XmlPullParser.Event.OTHER;
            }
            case 14: {
                return XmlPullParser.Event.OTHER;
            }
            case 15: {
                return XmlPullParser.Event.OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown Stax event integer: " + n);
    }

    public final boolean supportsRoundtrip() {
        return false;
    }
}

