/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.sound3d.AudioSystem3D;
import java.nio.ByteBuffer;

public final class Buffer {
    public static final int FORMAT_MONO8 = 4352;
    public static final int FORMAT_MONO16 = 4353;
    public static final int FORMAT_STEREO8 = 4354;
    public static final int FORMAT_STEREO16 = 4355;
    private int alBufferID;
    private ByteBuffer data;

    public Buffer(int n) {
        this.alBufferID = n;
    }

    public final int getID() {
        return this.alBufferID;
    }

    public final boolean isValid() {
        return this.alBufferID >= 0 && AudioSystem3D.al.alIsBuffer(this.alBufferID);
    }

    public final void delete() {
        this.data = null;
        if (this.alBufferID >= 0) {
            AudioSystem3D.al.alDeleteBuffers(1, new int[]{this.alBufferID}, 0);
            this.alBufferID = -1;
        }
    }

    public final void configure(ByteBuffer byteBuffer, int n, int n2) {
        this.data = byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer;
        AudioSystem3D.al.alBufferData(this.alBufferID, n, byteBuffer2, byteBuffer2.capacity(), n2);
    }

    public final int getBitDepth() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetBufferi(this.alBufferID, 8194, nArray, 0);
        return nArray[0];
    }

    public final int getNumChannels() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetBufferi(this.alBufferID, 8195, nArray, 0);
        return nArray[0];
    }

    public final ByteBuffer getData() {
        return this.data;
    }

    public final int getFrequency() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetBufferi(this.alBufferID, 8193, nArray, 0);
        return nArray[0];
    }

    public final int getSize() {
        int[] nArray = new int[1];
        AudioSystem3D.al.alGetBufferi(this.alBufferID, 8196, nArray, 0);
        return nArray[0];
    }

    public final String toString() {
        return "ALBuffer[id " + this.alBufferID + "]";
    }
}

