/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.StringColumnType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/CharColumnType;", "Lorg/jetbrains/exposed/sql/StringColumnType;", "colLength", "", "collate", "", "(ILjava/lang/String;)V", "getColLength", "()I", "equals", "", "other", "", "hashCode", "sqlType", "validateValueBeforeUpdate", "", "value", "exposed-core"})
public class CharColumnType
extends StringColumnType {
    private final int colLength;

    public CharColumnType(int n, String string) {
        super(string);
        this.colLength = n;
    }

    public /* synthetic */ CharColumnType(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 255;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        this(n, string);
    }

    public final int getColLength() {
        return this.colLength;
    }

    @Override
    public String sqlType() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append("CHAR(" + this.colLength + ')');
        if (this.getCollate() != null) {
            CharColumnType charColumnType = this;
            stringBuilder2.append(" COLLATE " + charColumnType.escapeAndQuote(charColumnType.getCollate()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public void validateValueBeforeUpdate(String string) {
        int n;
        if (string != null && !((n = string.codePointCount(0, string.length())) <= this.colLength)) {
            String string2 = "Value can't be stored to database column because exceeds length (" + n + " > " + this.colLength + ')';
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        CharColumnType cfr_ignored_0 = (CharColumnType)object;
        if (this.colLength != ((CharColumnType)object).colLength) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getCollate(), (Object)((CharColumnType)object).getCollate());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.colLength;
        return n;
    }

    public CharColumnType() {
        this(0, null, 3, null);
    }
}

