/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H&J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020\u00042\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020\u0004H\u0016J\b\u00100\u001a\u00020\u0004H\u0016J\u0010\u00101\u001a\u00020\u00012\u0006\u0010\n\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0006H\u0016\u00a8\u00066"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "()V", "binaryType", "", "length", "", "blobType", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "dateType", "doubleType", "floatType", "hexToDb", "hexString", "integerAutoincType", "integerType", "jsonBType", "jsonType", "largeTextType", "longAutoincType", "longType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "processForDefaultValue", "e", "shortType", "textType", "timeType", "timestampWithTimeZoneType", "ubyteType", "uintegerAutoincType", "uintegerType", "ulongAutoincType", "ulongType", "ushortType", "uuidToDB", "Ljava/util/UUID;", "uuidType", "varcharType", "colLength", "exposed-core"})
public abstract class DataTypeProvider {
    public String byteType() {
        return "TINYINT";
    }

    public String ubyteType() {
        return "SMALLINT";
    }

    public String shortType() {
        return "SMALLINT";
    }

    public String ushortType() {
        return "INT";
    }

    public String integerType() {
        return "INT";
    }

    public String uintegerType() {
        return "BIGINT";
    }

    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    public String uintegerAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    public String longType() {
        return "BIGINT";
    }

    public String ulongType() {
        return "NUMERIC(20)";
    }

    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    public String ulongAutoincType() {
        return "NUMERIC(20) AUTO_INCREMENT";
    }

    public String floatType() {
        return "FLOAT";
    }

    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    public String varcharType(int n) {
        return "VARCHAR(" + n + ')';
    }

    public String textType() {
        return "TEXT";
    }

    public String mediumTextType() {
        return "TEXT";
    }

    public String largeTextType() {
        return "TEXT";
    }

    public abstract String binaryType();

    public String binaryType(int n) {
        if (n == Integer.MAX_VALUE) {
            return "VARBINARY(MAX)";
        }
        return "VARBINARY(" + n + ')';
    }

    public String blobType() {
        return "BLOB";
    }

    public String uuidType() {
        return "BINARY(16)";
    }

    public Object uuidToDB(UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"");
        byte[] byArray = ByteBuffer.allocate(16).putLong(uUID.getMostSignificantBits()).putLong(uUID.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        return byArray;
    }

    public String dateTimeType() {
        return "DATETIME";
    }

    public String timestampWithTimeZoneType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    public String timeType() {
        return "TIME";
    }

    public String dateType() {
        return "DATE";
    }

    public String booleanType() {
        return "BOOLEAN";
    }

    public String booleanToStatementString(boolean bl) {
        String string = String.valueOf(bl).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public boolean booleanFromStringToBoolean(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return Boolean.parseBoolean(string);
    }

    public String jsonType() {
        return "JSON";
    }

    public String jsonBType() {
        throw new UnsupportedByDialectException("This vendor does not support binary JSON data type", DatabaseDialectKt.getCurrentDialect());
    }

    public String processForDefaultValue(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        if (expression instanceof LiteralOp && ((ExpressionWithColumnType)((LiteralOp)expression)).getColumnType() instanceof JsonColumnMarker) {
            if (DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect) {
                return StringsKt.substringAfter$default((String)String.valueOf(expression), (String)"JSON ", null, (int)2, null);
            }
            return "'" + expression + '\'';
        }
        if (expression instanceof LiteralOp) {
            IColumnType iColumnType = ((ExpressionWithColumnType)((LiteralOp)expression)).getColumnType();
            Intrinsics.checkNotNull(iColumnType);
            return iColumnType.valueAsDefaultString(((LiteralOp)expression).getValue());
        }
        if (expression instanceof Function) {
            return String.valueOf(expression);
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect) {
            return String.valueOf(expression);
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect) {
            return String.valueOf(expression);
        }
        return "(" + expression + ')';
    }

    public void precessOrderByClause(QueryBuilder objectArray, Expression<?> expressionAlias, SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        Intrinsics.checkNotNullParameter(expressionAlias, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"");
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray = new Object[3];
        ExpressionAlias expressionAlias2 = expressionAlias instanceof ExpressionAlias ? (ExpressionAlias)expressionAlias : null;
        if (expressionAlias2 == null || (expressionAlias2 = expressionAlias2.getAlias()) == null) {
            expressionAlias2 = expressionAlias;
        }
        objectArray3[0] = expressionAlias2;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append((QueryBuilder)objectArray2, objectArray);
    }

    public abstract String hexToDb(String var1);
}

