/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J0\u0010!\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J(\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u00020\rH\u0016J\u0014\u00101\u001a\u00020\r2\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\b\u00104\u001a\u00020\u0012H\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u0012062\n\u00107\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u00020:H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001206H\u0016J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006>"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "nonAcceptableDefaults", "", "", "[Ljava/lang/String;", "supportsIfNotExists", "getSupportsIfNotExists", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "createDatabase", "name", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createIndexWithType", "table", "columns", "type", "filterCondition", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "sequences", "setSchema", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsRestrictReferenceOption;
    private final String[] nonAcceptableDefaults;
    private final Map<Character, Character> likePatternSpecialChars;
    private static final Map<Character, Character> sqlServerLikePatternSpecialChars;

    public SQLServerDialect() {
        super(Companion.getDialectName(), SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "DEFAULT";
        this.nonAcceptableDefaults = stringArray2;
        this.likePatternSpecialChars = sqlServerLikePatternSpecialChars;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        String string = ((Expression)object).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        object = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains((Object[])this.nonAcceptableDefaults, (Object)object);
    }

    @Override
    public List<String> modifyColumn(Column<?> column, ColumnDiff object) {
        List list;
        block7: {
            StringBuilder stringBuilder;
            List list2;
            block9: {
                Object object2;
                Object object3;
                CharSequence charSequence;
                String string;
                block8: {
                    Intrinsics.checkNotNullParameter(column, (String)"");
                    Intrinsics.checkNotNullParameter((Object)object, (String)"");
                    Transaction transaction2 = TransactionManager.Companion.current();
                    string = "ALTER TABLE " + transaction2.identity(column.getTable()) + ' ';
                    list = new ArrayList();
                    charSequence = new StringBuilder();
                    Object object4 = charSequence;
                    list2 = list;
                    ((StringBuilder)object4).append(string + "ALTER COLUMN " + transaction2.identity(column) + ' ' + ((ExpressionWithColumnType)column).getColumnType().sqlType());
                    if (((ColumnDiff)object).getNullability()) {
                        boolean bl;
                        object3 = column.getDbDefaultValue$exposed_core();
                        Object[] objectArray = column.getTable().getPrimaryKey();
                        boolean bl2 = objectArray != null && (objectArray = objectArray.getColumns()) != null ? ArraysKt.contains((Object[])objectArray, column) : (bl = false);
                        if (((ExpressionWithColumnType)column).getColumnType().getNullable() || object3 != null && column.getDefaultValueFun() == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault((Expression<?>)object3)) {
                            ((StringBuilder)object4).append(" NULL");
                        } else if (!bl) {
                            ((StringBuilder)object4).append(" NOT NULL");
                        }
                    }
                    String string2 = ((StringBuilder)charSequence).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    list2.add(string2);
                    if (!((ColumnDiff)object).getDefaults()) break block7;
                    charSequence = column.getTable().getTableName();
                    object4 = column.getName();
                    object = "DF_" + (String)charSequence + '_' + (String)object4;
                    object3 = "DROP CONSTRAINT IF EXISTS " + (String)object;
                    stringBuilder = new StringBuilder();
                    charSequence = stringBuilder;
                    list2 = list;
                    object2 = column.getDbDefaultValue$exposed_core();
                    if (object2 == null) break block8;
                    object4 = object2;
                    ((StringBuilder)charSequence).append(string + (String)object3);
                    ((StringBuilder)charSequence).append("; ");
                    object2 = ((StringBuilder)charSequence).append(string + "ADD CONSTRAINT " + (String)object + " DEFAULT " + SQLServerDataTypeProvider.INSTANCE.processForDefaultValue((Expression<?>)object4) + " for " + transaction2.identity(column));
                    if (object2 != null) break block9;
                }
                object2 = ((StringBuilder)charSequence).append(string + (String)object3);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            list2.add(string);
        }
        return list;
    }

    @Override
    public String createDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String listDatabases() {
        return "SELECT name FROM sys.databases";
    }

    @Override
    public String dropDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String setSchema(Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    public String createSchema(Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "CREATE SCHEMA ";
        stringArray2[1] = schema.getIdentifier();
        StringsKt.append((StringBuilder)stringBuilder, (String[])stringArray2);
        SchemaKt.appendIfNotNull(stringBuilder2, " AUTHORIZATION ", schema.getAuthorization());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String dropSchema(Schema schema, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "DROP SCHEMA " + schema.getIdentifier();
    }

    @Override
    public String createIndex(Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, (Function1)createIndex.1.INSTANCE, (int)31, null) + " can't be created in SQLServer");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    protected String createIndexWithType(String string, String string2, String string3, String string4, String string5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"");
        return "CREATE " + string4 + " INDEX " + string + " ON " + string2 + ' ' + string3 + string5;
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (bl && !bl2) {
            return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(string) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string2);
        }
        return "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string2) + " ON " + this.getIdentifierManager().quoteIfNecessary(string);
    }

    @Override
    public Map<Character, Character> getLikePatternSpecialChars() {
        return this.likePatternSpecialChars;
    }

    @Override
    public List<String> sequences() {
        List list = new ArrayList();
        Transaction.exec$default(TransactionManager.Companion.current(), "SELECT name FROM sys.sequences", null, null, (Function1)new Function1<ResultSet, Unit>((List<String>)list){
            final /* synthetic */ List<String> $sequences;
            {
                this.$sequences = list;
                super(1);
            }

            public final void invoke(ResultSet resultSet) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                while (resultSet.next()) {
                    String string = resultSet.getString("name");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    this.$sequences.add(string);
                }
            }
        }, 6, null);
        return list;
    }

    static {
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)Character.valueOf('%'), null);
        pairArray2[1] = TuplesKt.to((Object)Character.valueOf('_'), null);
        pairArray2[2] = TuplesKt.to((Object)Character.valueOf('['), (Object)Character.valueOf(']'));
        sqlServerLikePatternSpecialChars = MapsKt.mapOf((Pair[])pairArray2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "sqlServerLikePatternSpecialChars", "", "", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLServer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

