/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0014\u0010\u0019\u001a\u00020\u00042\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "supportsCreateSchema", "", "getSupportsCreateSchema", "()Z", "supportsCreateSequence", "getSupportsCreateSequence", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "createDatabase", "", "name", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    private final boolean supportsWindowFrameGroupsMode;
    private static final Lazy<Boolean> ENABLE_UPDATE_DELETE_LIMIT$delegate = LazyKt.lazy((Function0)Companion.ENABLE_UPDATE_DELETE_LIMIT.2.INSTANCE);

    public SQLiteDialect() {
        super(Companion.getDialectName(), SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
        this.supportsWindowFrameGroupsMode = true;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        return true;
    }

    @Override
    public String createIndex(Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.1.INSTANCE, (int)31, null) + " can't be created in SQLite");
            return "";
        }
        String string = super.createIndex(Index.copy$default(index, null, false, null, null, null, null, null, 125, null));
        if (index.getUnique()) {
            return StringsKt.replace$default((String)string, (String)"CREATE INDEX", (String)"CREATE UNIQUE INDEX", (boolean)false, (int)4, null);
        }
        return string;
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(string2);
    }

    @Override
    public String createDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        StringBuilder stringBuilder = new StringBuilder("ATTACH DATABASE '");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return stringBuilder.append(string2).append(".db' AS ").append(DatabaseDialectKt.inProperCase(string)).toString();
    }

    @Override
    public String listDatabases() {
        return "SELECT name FROM pragma_database_list";
    }

    @Override
    public String dropDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "DETACH DATABASE " + DatabaseDialectKt.inProperCase(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "ENABLE_UPDATE_DELETE_LIMIT", "", "getENABLE_UPDATE_DELETE_LIMIT", "()Z", "ENABLE_UPDATE_DELETE_LIMIT$delegate", "Lkotlin/Lazy;", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLite");
        }

        public final boolean getENABLE_UPDATE_DELETE_LIMIT() {
            Lazy lazy = ENABLE_UPDATE_DELETE_LIMIT$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

