/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.collections.ConcurrentMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\u001a\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\b\b\u0000\u0010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"", "Key", "", "ConcurrentSet", "()Ljava/util/Set;", "ktor-utils"})
public final class ConcurrentSetKt {
    public static final <Key> Set<Key> ConcurrentSet() {
        return new Set<Key>(){
            private final ConcurrentMap<Key, Unit> delegate;
            {
                this.delegate = new ConcurrentMap<Key, Value>(0, 1, null);
            }

            public final boolean add(Key Key2) {
                Intrinsics.checkNotNullParameter(Key2, (String)"");
                if (this.delegate.containsKey(Key2)) {
                    return false;
                }
                ((Map)this.delegate).put(Key2, Unit.INSTANCE);
                return true;
            }

            public final boolean addAll(Collection<? extends Key> object) {
                Intrinsics.checkNotNullParameter(object, (String)"");
                object = (Iterable)object;
                if (!((Collection)object).isEmpty()) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        E e = object.next();
                        if (this.add((Key)e)) continue;
                        return false;
                    }
                }
                return true;
            }

            public final void clear() {
                this.delegate.clear();
            }

            public final Iterator<Key> iterator() {
                return this.delegate.keySet().iterator();
            }

            public final boolean remove(Object object) {
                if (object == null) {
                    return false;
                }
                return this.delegate.remove(object) != null;
            }

            public final boolean removeAll(Collection<? extends Object> object) {
                Intrinsics.checkNotNullParameter(object, (String)"");
                object = (Iterable)object;
                if (!((Collection)object).isEmpty()) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        E e = object.next();
                        if (this.remove(e)) continue;
                        return false;
                    }
                }
                return true;
            }

            public final boolean retainAll(Collection<? extends Object> collection) {
                Intrinsics.checkNotNullParameter(collection, (String)"");
                Set set = new LinkedHashSet<E>();
                for (Key Key2 : this.delegate.keySet()) {
                    if (collection.contains(Key2)) continue;
                    set.add(Key2);
                }
                return this.removeAll(set);
            }

            public final int getSize() {
                return this.delegate.size();
            }

            public final boolean contains(Object object) {
                if (object == null) {
                    return false;
                }
                return this.delegate.containsKey(object);
            }

            public final boolean containsAll(Collection<? extends Object> collection) {
                Intrinsics.checkNotNullParameter(collection, (String)"");
                return collection.containsAll((Collection)this.delegate.keySet());
            }

            public final boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            public final int size() {
                return this.getSize();
            }

            public final <T> T[] toArray(T[] TArray) {
                Intrinsics.checkNotNullParameter(TArray, (String)"");
                return CollectionToArray.toArray((Collection)this, (Object[])TArray);
            }

            public final Object[] toArray() {
                return CollectionToArray.toArray((Collection)this);
            }
        };
    }
}

