/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.input.internal.ToCharArray_skikoKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0005H\u0002J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J2\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010\u001b\u001a\u00020\u0005J\u0012\u0010\u001c\u001a\u00020\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fJ\u0006\u0010 \u001a\u00020\u0005J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/compose/foundation/text/input/internal/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "<init>", "([CII)V", "capacity", "buffer", "gapStart", "gapEnd", "gapLength", "get", "", "index", "makeSureAvailableSpace", "", "requestSize", "delete", "start", "end", "replace", "text", "", "textStart", "textEnd", "append", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "length", "toString", "", "foundation"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    public GapBuffer(char[] cArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"");
        this.capacity = cArray.length;
        this.buffer = cArray;
        this.gapStart = n2;
        this.gapEnd = n3;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    public final char get(int n2) {
        if (n2 < this.gapStart) {
            return this.buffer[n2];
        }
        return this.buffer[n2 - this.gapStart + this.gapEnd];
    }

    private final void makeSureAvailableSpace(int n2) {
        if (n2 <= this.gapLength()) {
            return;
        }
        n2 -= this.gapLength();
        int n3 = this.capacity << 1;
        while (n3 - this.capacity < n2) {
            n3 <<= 1;
        }
        char[] cArray = new char[n3];
        ArraysKt.copyInto((char[])this.buffer, (char[])cArray, (int)0, (int)0, (int)this.gapStart);
        int n4 = this.capacity - this.gapEnd;
        int n5 = n3 - n4;
        ArraysKt.copyInto((char[])this.buffer, (char[])cArray, (int)n5, (int)this.gapEnd, (int)(this.gapEnd + n4));
        this.buffer = cArray;
        this.capacity = n3;
        this.gapEnd = n5;
    }

    private final void delete(int n2, int n3) {
        if (n2 < this.gapStart && n3 <= this.gapStart) {
            int n4 = this.gapStart - n3;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - n4), (int)n3, (int)this.gapStart);
            this.gapStart = n2;
            this.gapEnd -= n4;
            return;
        }
        if (n2 < this.gapStart && n3 >= this.gapStart) {
            this.gapEnd = n3 + this.gapLength();
            this.gapStart = n2;
            return;
        }
        int n5 = n2 + this.gapLength();
        n2 = n3 + this.gapLength();
        n3 = n5 - this.gapEnd;
        ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)n5);
        this.gapStart += n3;
        this.gapEnd = n2;
    }

    public final void replace(int n2, int n3, CharSequence charSequence, int n4, int n5) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"");
        int n6 = n5 - n4;
        this.makeSureAvailableSpace(n6 - (n3 - n2));
        this.delete(n2, n3);
        ToCharArray_skikoKt.toCharArray(charSequence, this.buffer, this.gapStart, n4, n5);
        this.gapStart += n6;
    }

    public static /* synthetic */ void replace$default(GapBuffer gapBuffer, int n2, int n3, CharSequence charSequence, int n4, int n5, int n6, Object object) {
        if ((n6 & 8) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n5 = charSequence.length();
        }
        gapBuffer.replace(n2, n3, charSequence, n4, n5);
    }

    public final void append(StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        StringBuilder stringBuilder2 = stringBuilder;
        char[] cArray = this.buffer;
        int n2 = this.gapStart;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(cArray, 0, n2), (String)"");
        stringBuilder2 = stringBuilder;
        cArray = this.buffer;
        int n3 = this.gapEnd;
        n2 = this.capacity;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(cArray, n3, n2 - n3), (String)"");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)stringBuilder2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }
}

