/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.b.H;
import androidx.b.p;
import androidx.b.s;
import androidx.b.t;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0.H\u0016J\u0012\u0010/\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0000H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\r032\u0006\u00104\u001a\u00020\rH\u0016J2\u00105\u001a\u00020,*\b\u0012\u0004\u0012\u00020\r062\u0006\u00104\u001a\u00020\r2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u000bH\u0002J\u0018\u0010?\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u000bH\u0002J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0017R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"\u00a8\u0006D"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "Landroidx/collection/LongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "<init>", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "getSelectableIdToInfoListIndex", "()Landroidx/collection/LongIntMap;", "getInfoList", "()Ljava/util/List;", "getStartSlot", "()I", "getEndSlot", "()Z", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "size", "getSize", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "startInfo", "getStartInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "currentInfo", "getCurrentInfo", "firstInfo", "getFirstInfo", "lastInfo", "getLastInfo", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "shouldRecomputeSelection", "other", "shouldAnyInfoRecomputeSelection", "createSubSelections", "Landroidx/collection/LongObjectMap;", "selection", "createAndPutSubSelection", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "toString", "", "startOrEndSlotToIndex", "slot", "isStartSlot", "slotToIndex", "isMinimumSlot", "getInfoListIndexBySelectableId", "id", "", "foundation"})
final class MultiSelectionLayout
implements SelectionLayout {
    private final p selectableIdToInfoListIndex;
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    private final Selection previousSelection;

    public MultiSelectionLayout(p p2, List<SelectableInfo> list, int n2, int n3, boolean bl, Selection selection) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.selectableIdToInfoListIndex = p2;
        this.infoList = list;
        this.startSlot = n2;
        this.endSlot = n3;
        this.isStartHandle = bl;
        this.previousSelection = selection;
        boolean bl2 = this.infoList.size() > 1;
        if (!bl2) {
            InlineClassHelperKt.throwIllegalStateException("MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + ".");
        }
    }

    public final p getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public final int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public final int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public final int getSize() {
        return this.infoList.size();
    }

    @Override
    public final CrossStatus getCrossStatus() {
        if (this.getStartSlot() < this.getEndSlot()) {
            return CrossStatus.NOT_CROSSED;
        }
        if (this.getStartSlot() > this.getEndSlot()) {
            return CrossStatus.CROSSED;
        }
        return this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus();
    }

    @Override
    public final SelectableInfo getStartInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getStartSlot(), true));
    }

    @Override
    public final SelectableInfo getEndInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.getEndSlot(), false));
    }

    @Override
    public final SelectableInfo getCurrentInfo() {
        if (this.isStartHandle()) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final SelectableInfo getFirstInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getEndInfo();
        }
        return this.getStartInfo();
    }

    @Override
    public final SelectableInfo getLastInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final void forEachMiddleInfo(Function1<? super SelectableInfo, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        MultiSelectionLayout multiSelectionLayout = this;
        int n2 = multiSelectionLayout.getInfoListIndexBySelectableId(multiSelectionLayout.getFirstInfo().getSelectableId());
        MultiSelectionLayout multiSelectionLayout2 = this;
        int n3 = multiSelectionLayout2.getInfoListIndexBySelectableId(multiSelectionLayout2.getLastInfo().getSelectableId());
        if (n2 + 1 >= n3) {
            return;
        }
        ++n2;
        while (n2 < n3) {
            function1.invoke((Object)this.infoList.get(n2));
            ++n2;
        }
    }

    @Override
    public final boolean shouldRecomputeSelection(SelectionLayout selectionLayout) {
        return this.getPreviousSelection() == null || selectionLayout == null || !(selectionLayout instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)selectionLayout).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)selectionLayout).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)selectionLayout).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)selectionLayout);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout multiSelectionLayout) {
        if (this.getSize() != multiSelectionLayout.getSize()) {
            return true;
        }
        int n2 = ((Collection)this.infoList).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SelectableInfo selectableInfo;
            SelectableInfo selectableInfo2 = this.infoList.get(i2);
            if (!selectableInfo2.shouldRecomputeSelection(selectableInfo = multiSelectionLayout.infoList.get(i2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final s<Selection> createSubSelections(Selection selection) {
        H h2;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            boolean bl = selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset();
            if (!bl) {
                InlineClassHelperKt.throwIllegalStateException("unexpectedly miss-crossed selection: " + selection);
            }
            return t.a((long)selection.getStart().getSelectableId(), (Selection)selection);
        }
        H h3 = h2 = t.b();
        Object object = selection;
        object = ((Selection)object).getHandlesCrossed() ? ((Selection)object).getEnd() : ((Selection)object).getStart();
        this.createAndPutSubSelection((H<Selection>)h3, selection, this.getFirstInfo(), ((Selection.AnchorInfo)object).getOffset(), this.getFirstInfo().getTextLength());
        MultiSelectionLayout multiSelectionLayout = this;
        multiSelectionLayout.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)arg_0 -> MultiSelectionLayout.createSubSelections$lambda$5$lambda$3(multiSelectionLayout, h3, selection, arg_0)));
        object = selection;
        object = ((Selection)object).getHandlesCrossed() ? ((Selection)object).getStart() : ((Selection)object).getEnd();
        this.createAndPutSubSelection((H<Selection>)h3, selection, this.getLastInfo(), 0, ((Selection.AnchorInfo)object).getOffset());
        return (s)h2;
    }

    private final void createAndPutSubSelection(H<Selection> h2, Selection selection, SelectableInfo selectableInfo, int n2, int n3) {
        selection = selection.getHandlesCrossed() ? selectableInfo.makeSingleLayoutSelection(n3, n2) : selectableInfo.makeSingleLayoutSelection(n2, n3);
        if ((n2 = n2 <= n3 ? 1 : 0) == 0) {
            InlineClassHelperKt.throwIllegalStateException("minOffset should be less than or equal to maxOffset: " + selection);
        }
        h2.a(selectableInfo.getSelectableId(), selection);
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CrossStatus crossStatus = this.getCrossStatus();
        float f2 = (float)(this.getEndSlot() + 1) / 2.0f;
        float f3 = (float)(this.getStartSlot() + 1) / 2.0f;
        boolean bl = this.isStartHandle();
        stringBuilder2.append("[\n\t");
        boolean bl2 = true;
        List<SelectableInfo> list = this.infoList;
        int n2 = ((Collection)list).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SelectableInfo selectableInfo = list.get(i2);
            int n3 = i2;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder2.append(",\n\t");
            }
            stringBuilder2.append(n3 + 1 + " -> " + selectableInfo);
        }
        stringBuilder2.append("\n]");
        return "MultiSelectionLayout(isStartHandle=" + bl + ", startPosition=" + f3 + ", endPosition=" + f2 + ", crossed=" + crossStatus + ", infos=" + stringBuilder.toString() + ")";
    }

    private final int startOrEndSlotToIndex(int n2, boolean bl) {
        boolean bl2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = bl;
                break;
            }
            case 3: {
                if (!bl) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex(n2, bl2);
    }

    private final int slotToIndex(int n2, boolean bl) {
        bl = !bl;
        return (n2 - bl) / 2;
    }

    private final int getInfoListIndexBySelectableId(long l2) {
        int n2;
        try {
            n2 = this.selectableIdToInfoListIndex.a(l2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("Invalid selectableId: " + l2, noSuchElementException);
        }
        return n2;
    }

    private static final Unit createSubSelections$lambda$5$lambda$3(MultiSelectionLayout multiSelectionLayout, H h2, Selection selection, SelectableInfo selectableInfo) {
        Intrinsics.checkNotNullParameter((Object)selectableInfo, (String)"");
        multiSelectionLayout.createAndPutSubSelection((H<Selection>)h2, selection, selectableInfo, 0, selectableInfo.getTextLength());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

