/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItem
implements MenuItemPeer {
    static ImageIcon transparentIcon = null;
    protected final SwingMenu parent;
    protected final JMenuItem _native = new JMenuItem();
    protected volatile ActionListener callback;

    static void createTransparentIcon(int n, ImageResizeUtil imageResizeUtil) {
        if (transparentIcon == null) {
            try {
                JMenuItem jMenuItem = new JMenuItem();
                if (SystemTray.SWING_UI != null) {
                    jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                }
                transparentIcon = new ImageIcon(imageResizeUtil.getTransparentImage(n).getAbsolutePath());
                return;
            }
            catch (Exception exception) {
                SystemTray.logger.error("Error creating transparent image.", (Throwable)exception);
            }
        }
    }

    SwingMenuItem(SwingMenu swingMenu, Entry entry, int n) {
        this.parent = swingMenu;
        if (SystemTray.SWING_UI != null) {
            this._native.setUI(SystemTray.SWING_UI.getItemUI(this._native, entry));
        }
        this._native.setHorizontalAlignment(2);
        swingMenu._native.add((Component)this._native, n);
        this._native.setIcon(transparentIcon);
    }

    @Override
    public void setImage(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> {
            if ((menuItem = ((MenuItem)menuItem).getImage()) != null) {
                menuItem = new ImageIcon(((File)((Object)menuItem)).getAbsolutePath());
                this._native.setIcon((Icon)((Object)menuItem));
                return;
            }
            this._native.setIcon(transparentIcon);
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setText(menuItem.getText()));
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    1 v0 = this;
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(v0.menuItem, 1001, ""));
                            return;
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)v0.menuItem.getText(), (Object)throwable);
                            return;
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int n = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setMnemonic(n));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setToolTipText(menuItem.getTooltip()));
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            if (this.callback != null) {
                this._native.removeActionListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeAll();
        });
    }
}

