/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private int hash = 0;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = byteString.size();
        this.totalLength = this.leftLength + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        RopeByteString ropeByteString;
        RopeByteString ropeByteString2 = ropeByteString = byteString instanceof RopeByteString ? (RopeByteString)byteString : null;
        if (byteString2.size() != 0) {
            if (byteString.size() == 0) {
                byteString = byteString2;
            } else {
                int n = byteString.size() + byteString2.size();
                if (n < 128) {
                    byteString = RopeByteString.concatenateBytes(byteString, byteString2);
                } else if (ropeByteString != null && ropeByteString.right.size() + byteString2.size() < 128) {
                    LiteralByteString literalByteString = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                    byteString = new RopeByteString(ropeByteString.left, literalByteString);
                } else if (ropeByteString != null && ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                    RopeByteString ropeByteString3 = new RopeByteString(ropeByteString.right, byteString2);
                    byteString = new RopeByteString(ropeByteString.left, ropeByteString3);
                } else {
                    int n2 = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
                    byteString = n >= minLengthByDepth[n2] ? new RopeByteString(byteString, byteString2) : new Balancer().balance(byteString, byteString2);
                }
            }
        }
        return byteString;
    }

    private static LiteralByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        int n = byteString.size();
        int n2 = byteString2.size();
        byte[] byArray = new byte[n + n2];
        byteString.copyTo(byArray, 0, 0, n);
        byteString2.copyTo(byArray, 0, n, n2);
        return new LiteralByteString(byArray);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        if (n + n3 <= this.leftLength) {
            this.left.copyToInternal(byArray, n, n2, n3);
            return;
        }
        if (n >= this.leftLength) {
            this.right.copyToInternal(byArray, n - this.leftLength, n2, n3);
            return;
        }
        int n4 = this.leftLength - n;
        this.left.copyToInternal(byArray, n, n2, n4);
        this.right.copyToInternal(byArray, 0, n2 + n4, n3 - n4);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        if (n + n2 <= this.leftLength) {
            this.left.writeToInternal(outputStream, n, n2);
            return;
        }
        if (n >= this.leftLength) {
            this.right.writeToInternal(outputStream, n - this.leftLength, n2);
            return;
        }
        int n3 = this.leftLength - n;
        this.left.writeToInternal(outputStream, n, n3);
        this.right.writeToInternal(outputStream, 0, n2 - n3);
    }

    @Override
    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }

    @Override
    public boolean isValidUtf8() {
        int n = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        return (n = this.right.partialIsValidUtf8(n, 0, this.right.size())) == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialIsValidUtf8(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialIsValidUtf8(n, n2 - this.leftLength, n3);
        }
        n4 = this.leftLength - n2;
        n = this.left.partialIsValidUtf8(n, n2, n4);
        return this.right.partialIsValidUtf8(n, 0, n3 - n4);
    }

    public boolean equals(Object object) {
        int n;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (this.totalLength != ((ByteString)(object = (ByteString)object)).size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (n = ((ByteString)object).peekCachedHashCode()) != 0 && this.hash != n) {
            return false;
        }
        return this.equalsFragments((ByteString)object);
    }

    private boolean equalsFragments(ByteString object) {
        int n = 0;
        PieceIterator pieceIterator = new PieceIterator(this);
        LiteralByteString literalByteString = (LiteralByteString)pieceIterator.next();
        int n2 = 0;
        object = new PieceIterator((ByteString)object);
        LiteralByteString literalByteString2 = (LiteralByteString)object.next();
        int n3 = 0;
        while (true) {
            int n4 = ((ByteString)literalByteString).size() - n;
            int n5 = ((ByteString)literalByteString2).size() - n2;
            int n6 = Math.min(n4, n5);
            boolean bl = n == 0 ? literalByteString.equalsRange(literalByteString2, n2, n6) : literalByteString2.equalsRange(literalByteString, n, n6);
            if (!bl) {
                return false;
            }
            if ((n3 += n6) >= this.totalLength) {
                if (n3 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                literalByteString = (LiteralByteString)pieceIterator.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                n2 = 0;
                literalByteString2 = (LiteralByteString)object.next();
                continue;
            }
            n2 += n6;
        }
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.totalLength;
            if ((n = this.partialHash(n, 0, this.totalLength)) == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialHash(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialHash(n, n2 - this.leftLength, n3);
        }
        n4 = this.leftLength - n2;
        n = this.left.partialHash(n, n2, n4);
        return this.right.partialHash(n, 0, n3 - n4);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(new RopeInputStream());
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new RopeByteIterator();
    }

    static {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 1;
        int n3 = 1;
        while (n3 > 0) {
            arrayList.add(n3);
            n = n2 + n3;
            n2 = n3;
            n3 = n;
        }
        arrayList.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[arrayList.size()];
        for (n = 0; n < minLengthByDepth.length; ++n) {
            RopeByteString.minLengthByDepth[n] = (Integer)arrayList.get(n);
        }
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private LiteralByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            return this.readSkipInternal(byArray, n, n2);
        }

        @Override
        public long skip(long l) {
            if (l < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)l);
        }

        private int readSkipInternal(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            for (n3 = n2; n3 > 0; n3 -= n4) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) {
                    if (n3 != n2) break;
                    return -1;
                }
                n4 = this.currentPieceSize - this.currentPieceIndex;
                n4 = Math.min(n4, n3);
                if (byArray != null) {
                    this.currentPiece.copyTo(byArray, this.currentPieceIndex, n, n4);
                    n += n4;
                }
                this.currentPieceIndex += n4;
            }
            return n2 - n3;
        }

        @Override
        public int read() {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() {
            int n = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return ((ByteString)RopeByteString.this).size() - n;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = ((ByteString)this.currentPiece).size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = ((ByteString)this.currentPiece).size();
                    return;
                }
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }
    }

    private class RopeByteIterator
    implements ByteString.ByteIterator {
        private final PieceIterator pieces;
        private ByteString.ByteIterator bytes;
        int bytesRemaining;

        private RopeByteIterator() {
            this.pieces = new PieceIterator(RopeByteString.this);
            this.bytes = ((ByteString)this.pieces.next()).iterator();
            this.bytesRemaining = ((ByteString)RopeByteString.this).size();
        }

        @Override
        public boolean hasNext() {
            return this.bytesRemaining > 0;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (!this.bytes.hasNext()) {
                this.bytes = ((ByteString)this.pieces.next()).iterator();
            }
            --this.bytesRemaining;
            return this.bytes.nextByte();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PieceIterator
    implements Iterator<LiteralByteString> {
        private final Stack<RopeByteString> breadCrumbs = new Stack();
        private LiteralByteString next;

        private PieceIterator(ByteString byteString) {
            this.next = this.getLeafByLeft(byteString);
        }

        private LiteralByteString getLeafByLeft(ByteString byteString) {
            while (byteString instanceof RopeByteString) {
                byteString = (RopeByteString)byteString;
                this.breadCrumbs.push((RopeByteString)byteString);
                byteString = ((RopeByteString)byteString).left;
            }
            return (LiteralByteString)byteString;
        }

        private LiteralByteString getNextNonEmptyLeaf() {
            PieceIterator pieceIterator;
            LiteralByteString literalByteString;
            do {
                if (this.breadCrumbs.isEmpty()) {
                    return null;
                }
                pieceIterator = this;
            } while ((literalByteString = pieceIterator.getLeafByLeft(pieceIterator.breadCrumbs.pop().right)).isEmpty());
            return literalByteString;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LiteralByteString next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LiteralByteString literalByteString = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return literalByteString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final Stack<ByteString> prefixesStack = new Stack();

        private Balancer() {
        }

        private ByteString balance(ByteString byteString, ByteString byteString2) {
            this.doBalance(byteString);
            this.doBalance(byteString2);
            byteString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                byteString2 = this.prefixesStack.pop();
                byteString = new RopeByteString(byteString2, byteString);
            }
            return byteString;
        }

        private void doBalance(ByteString object) {
            if (((ByteString)object).isBalanced()) {
                this.insert((ByteString)object);
                return;
            }
            if (object instanceof RopeByteString) {
                object = (RopeByteString)object;
                this.doBalance(((RopeByteString)object).left);
                this.doBalance(((RopeByteString)object).right);
                return;
            }
            object = String.valueOf(String.valueOf(object.getClass()));
            throw new IllegalArgumentException(new StringBuilder(49 + ((String)object).length()).append("Has a new type of ByteString been created? Found ").append((String)object).toString());
        }

        private void insert(ByteString byteString) {
            int n = this.getDepthBinForLength(byteString.size());
            int n2 = minLengthByDepth[n + 1];
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= n2) {
                this.prefixesStack.push(byteString);
                return;
            }
            n = minLengthByDepth[n];
            ByteString byteString2 = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < n) {
                ByteString byteString3 = this.prefixesStack.pop();
                byteString2 = new RopeByteString(byteString3, byteString2);
            }
            byteString2 = new RopeByteString(byteString2, byteString);
            while (!this.prefixesStack.isEmpty()) {
                n = this.getDepthBinForLength(byteString2.size());
                n2 = minLengthByDepth[n + 1];
                if (this.prefixesStack.peek().size() >= n2) break;
                ByteString byteString4 = this.prefixesStack.pop();
                byteString2 = new RopeByteString(byteString4, byteString2);
            }
            this.prefixesStack.push(byteString2);
        }

        private int getDepthBinForLength(int n) {
            n = Arrays.binarySearch(minLengthByDepth, n);
            if (n < 0) {
                n = -(n + 1);
                --n;
            }
            return n;
        }
    }
}

