/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    private final TypeSystemContext typeSystemContext;
    private final AbstractTypePreparator kotlinTypePreparator;
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<RigidTypeMarker> supertypesDeque;
    private Set<RigidTypeMarker> supertypesSet;

    public TypeCheckerState(boolean bl, boolean bl2, boolean bl3, TypeSystemContext typeSystemContext, AbstractTypePreparator abstractTypePreparator, AbstractTypeRefiner abstractTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractTypePreparator, (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractTypeRefiner, (String)"");
        this.isErrorTypeEqualsToAnything = bl;
        this.isStubTypeEqualsToAnything = bl2;
        this.allowedTypeVariable = bl3;
        this.typeSystemContext = typeSystemContext;
        this.kotlinTypePreparator = abstractTypePreparator;
        this.kotlinTypeRefiner = abstractTypeRefiner;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    public final KotlinTypeMarker refineType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.kotlinTypeRefiner.refineType(kotlinTypeMarker);
    }

    public final KotlinTypeMarker prepareType(KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.kotlinTypePreparator.prepareType(kotlinTypeMarker);
    }

    public boolean customIsSubtypeOf(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return true;
    }

    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(RigidTypeMarker rigidTypeMarker, CapturedTypeMarker capturedTypeMarker) {
        Intrinsics.checkNotNullParameter((Object)rigidTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)capturedTypeMarker, (String)"");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    public Boolean addSubtypeConstraint(KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker2, (String)"");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    public boolean runForkingPoint(Function1<? super ForkPointContext, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        ForkPointContext.Default default_ = new ForkPointContext.Default();
        function1.invoke((Object)default_);
        return default_.getResult();
    }

    public final ArrayDeque<RigidTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    public final Set<RigidTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new AssertionError((Object)string);
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = (Set)((Object)SmartSet.Companion.create());
        }
    }

    public final void clear() {
        ArrayDeque<RigidTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<RigidTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean isAllowedTypeVariable(KotlinTypeMarker kotlinTypeMarker) {
        TypeSystemContext typeSystemContext;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        return this.allowedTypeVariable && (typeSystemContext = this.typeSystemContext).isTypeVariableType(kotlinTypeMarker);
    }

    public static final /* synthetic */ int access$getArgumentsDepth(TypeCheckerState typeCheckerState) {
        return typeCheckerState.argumentsDepth;
    }

    public static final /* synthetic */ void access$setArgumentsDepth(TypeCheckerState typeCheckerState, int n) {
        typeCheckerState.argumentsDepth = n;
    }

    public static interface ForkPointContext {
        public void fork(Function0<Boolean> var1);

        public static final class Default
        implements ForkPointContext {
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            @Override
            public final void fork(Function0<Boolean> function0) {
                Intrinsics.checkNotNullParameter(function0, (String)"");
                if (this.result) {
                    return;
                }
                this.result = (Boolean)function0.invoke();
            }
        }
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER = new LowerCapturedTypePolicy();
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String string) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, string);
        }

        private static final /* synthetic */ LowerCapturedTypePolicy[] $values() {
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[3];
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray2 = lowerCapturedTypePolicyArray;
            lowerCapturedTypePolicyArray[0] = CHECK_ONLY_LOWER;
            lowerCapturedTypePolicyArray2[1] = CHECK_SUBTYPE_AND_LOWER;
            lowerCapturedTypePolicyArray2[2] = SKIP_LOWER;
            return lowerCapturedTypePolicyArray2;
        }

        static {
            $VALUES = LowerCapturedTypePolicy.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static abstract class SupertypesPolicy {
        private SupertypesPolicy() {
        }

        public abstract RigidTypeMarker transformType(TypeCheckerState var1, KotlinTypeMarker var2);

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public static abstract class DoCustomTransform
        extends SupertypesPolicy {
            public DoCustomTransform() {
                super(null);
            }
        }

        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE = new LowerIfFlexible();

            private LowerIfFlexible() {
                super(null);
            }

            @Override
            public final RigidTypeMarker transformType(TypeCheckerState object, KotlinTypeMarker kotlinTypeMarker) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
                object = ((TypeCheckerState)object).getTypeSystemContext();
                return object.lowerBoundIfFlexible(kotlinTypeMarker);
            }
        }

        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            public final Void transformType(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker) {
                Intrinsics.checkNotNullParameter((Object)typeCheckerState, (String)"");
                Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
                throw new UnsupportedOperationException("Should not be called");
            }
        }

        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE = new UpperIfFlexible();

            private UpperIfFlexible() {
                super(null);
            }

            @Override
            public final RigidTypeMarker transformType(TypeCheckerState object, KotlinTypeMarker kotlinTypeMarker) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
                object = ((TypeCheckerState)object).getTypeSystemContext();
                return object.upperBoundIfFlexible(kotlinTypeMarker);
            }
        }
    }
}

