/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectMap;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u0000 p*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006pqrstuB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010H\u001a\u00020IH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0003H\u0016J\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020\u0003H\u0016J\u0015\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010OJ\u001a\u0010M\u001a\u00020\f2\b\u0010N\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\fH\u0016J\u000e\u0010R\u001a\u00020I2\u0006\u0010S\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0018H\u0016J\u0013\u0010T\u001a\u00020\f2\b\u0010U\u001a\u0004\u0018\u00010PH\u0096\u0002J\u0012\u0010V\u001a\u00020\f2\b\u0010U\u001a\u0004\u0018\u00010PH\u0016J\u001f\u0010W\u001a\u0004\u0018\u00010\u00032\b\u0010N\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\f\u00a2\u0006\u0002\u0010XJ \u0010W\u001a\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\u0003J\u0018\u0010Z\u001a\u0004\u0018\u00018\u00002\u0006\u0010L\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010[J \u0010Z\u001a\u0004\u0018\u00018\u00002\u0006\u0010L\u001a\u00020\u00032\u0006\u0010\\\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010]J\b\u0010^\u001a\u00020\u0003H\u0016J\b\u0010_\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020&H\u0016J\u0010\u0010`\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u0003H\u0002J\u0006\u0010a\u001a\u00020\fJ\u0010\u0010b\u001a\u00020\u00032\u0006\u0010c\u001a\u00020\u0003H\u0004J\u001f\u0010d\u001a\u0004\u0018\u00018\u00002\u0006\u0010L\u001a\u00020\u00032\u0006\u0010N\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010]J\u0018\u0010e\u001a\u00020I2\u000e\u0010f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010e\u001a\u00020I2\u0014\u0010f\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000gH\u0016J\u001f\u0010h\u001a\u00020I2\u0006\u0010L\u001a\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010iJ\u0017\u0010j\u001a\u0004\u0018\u00018\u00002\u0006\u0010L\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010[J\u0010\u0010k\u001a\u00020I2\u0006\u0010l\u001a\u00020\u0003H\u0002J\u0010\u0010m\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0003H\u0016J\b\u0010n\u001a\u00020oH\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000@H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00130\u00128VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0004\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u0014\u00100\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010*R\u000e\u00102\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010:\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0016\u0010?\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010B\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010G\u001a\u0004\bC\u0010D\"\u0004\bE\u0010F\u00a8\u0006v"}, d2={"Ldorkbox/collections/IntMap;", "V", "", "", "()V", "initialCapacity", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/IntMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/IntMap$Entries;", "entries2", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/IntMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[Ljava/lang/Object;", "setValueTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/IntMap$Values;", "values2", "zeroValue", "getZeroValue", "()Ljava/lang/Object;", "setZeroValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Integer;", "notFound", "get", "(I)Ljava/lang/Object;", "defaultValue", "(ILjava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(ILjava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public class IntMap<V>
implements Map<Integer, V>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private int[] keyTable;
    private V[] valueTable;
    private V zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries<V> entries1;
    private transient Entries<V> entries2;
    private transient Values<V> values1;
    private transient Values<V> values2;
    private transient Keys keys1;
    private transient Keys keys2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.keyTable = nArray;
    }

    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"");
        this.valueTable = VArray;
    }

    public final V getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(V v) {
        this.zeroValue = v;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        n = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n * f);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n];
        this.valueTable = new Object[n];
    }

    public /* synthetic */ IntMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntMap(IntMap<? extends V> intMap) {
        Intrinsics.checkNotNullParameter(intMap, (String)"");
        this((int)((float)intMap.keyTable.length * intMap.loadFactor), intMap.loadFactor);
        System.arraycopy(intMap.keyTable, 0, this.keyTable, 0, intMap.keyTable.length);
        System.arraycopy(intMap.valueTable, 0, this.valueTable, 0, intMap.valueTable.length);
        this.size_ = intMap.size_;
        this.zeroValue = intMap.zeroValue;
        this.hasZeroValue = intMap.hasZeroValue;
    }

    protected final int place(int n) {
        return (int)((long)n * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        int n3;
        while ((n3 = nArray[n2]) != 0) {
            if (n3 == n) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    @Override
    public V put(int n, V v) {
        if (n == 0) {
            V v2 = this.zeroValue;
            this.zeroValue = v;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                n = this.size_;
                this.size_ = n + 1;
            }
            return v2;
        }
        int n2 = this.locateKey(n);
        if (n2 >= 0) {
            V v3 = this.valueTable[n2];
            this.valueTable[n2] = v;
            return v3;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = n;
        this.valueTable[n2] = v;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            IntMap intMap = this;
            intMap.resize(intMap.keyTable.length << 1);
        }
        return null;
    }

    public void putAll(IntMap<? extends V> VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"");
        this.ensureCapacity(VArray.size_);
        if (VArray.hasZeroValue) {
            V v = VArray.zeroValue;
            Intrinsics.checkNotNull(v);
            this.put(0, v);
        }
        int[] nArray = VArray.keyTable;
        VArray = VArray.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            V v = VArray[i];
            Intrinsics.checkNotNull(v);
            this.put(n2, v);
        }
    }

    private final void putResize(int n, V v) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        while (true) {
            if (nArray[n2] == 0) {
                nArray[n2] = n;
                this.valueTable[n2] = v;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public V get(int n) {
        if (n == 0) {
            if (this.hasZeroValue) {
                return this.zeroValue;
            }
            return null;
        }
        if ((n = this.locateKey(n)) >= 0) {
            return this.valueTable[n];
        }
        return null;
    }

    public final V get(int n, V v) {
        if (n == 0) {
            if (this.hasZeroValue) {
                V v2 = this.zeroValue;
                Intrinsics.checkNotNull(v2);
                return v2;
            }
            return v;
        }
        if ((n = this.locateKey(n)) >= 0) {
            return this.valueTable[n];
        }
        return v;
    }

    public V remove(int n) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V v = this.zeroValue;
            this.zeroValue = null;
            int n3 = this.size_;
            this.size_ = n3 + -1;
            return v;
        }
        if ((n = this.locateKey(n)) < 0) {
            return null;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v = this.valueTable[n];
        int n4 = this.mask;
        int n5 = n + 1 & n4;
        while (true) {
            int n6 = n2 = nArray[n5];
            n6 = n2;
            if (n2 == 0) break;
            n2 = this.place(n6);
            if ((n5 - n2 & n4) > (n - n2 & n4)) {
                nArray[n] = n6;
                VArray[n] = VArray[n5];
                n = n5;
            }
            n5 = n5 + 1 & n4;
        }
        nArray[n] = 0;
        VArray[n] = null;
        n2 = this.size_;
        this.size_ = n2 + -1;
        return v;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"");
        this.ensureCapacity(iterator.size());
        iterator = iterator.entrySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (Map.Entry)object;
            int n = ((Number)object.getKey()).intValue();
            object = object.getValue();
            this.put(n, object);
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        if (this.keyTable.length > (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.resize(n);
        }
    }

    public void clear(int n) {
        if (this.keyTable.length <= (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(n);
    }

    public Set<Map.Entry<Integer, V>> getEntries() {
        Entries<V> entries = this.entries();
        Intrinsics.checkNotNull(entries);
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    public Set<Integer> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue(object, false);
    }

    public boolean containsValue(Object object, boolean n) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] nArray = this.keyTable;
            int n2 = VArray.length + -1;
            if (n2 >= 0) {
                do {
                    int n3;
                    if (nArray[n3 = n2--] == 0 || VArray[n3] != null) continue;
                    return true;
                } while (n2 >= 0);
            }
        } else if (n != 0) {
            if (object == this.zeroValue) {
                return true;
            }
            n = VArray.length + -1;
            if (n >= 0) {
                do {
                    int n4;
                    if (VArray[n4 = n--] != object) continue;
                    return true;
                } while (n >= 0);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)object, this.zeroValue)) {
                return true;
            }
            n = VArray.length + -1;
            if (n >= 0) {
                do {
                    int n5;
                    if (!Intrinsics.areEqual((Object)object, VArray[n5 = n--])) continue;
                    return true;
                } while (n >= 0);
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(n) >= 0;
    }

    public final Integer findKey(Object object, boolean n) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] nArray = this.keyTable;
            int n2 = VArray.length + -1;
            if (n2 >= 0) {
                do {
                    int n3;
                    if (nArray[n3 = n2--] == 0 || VArray[n3] != null) continue;
                    return nArray[n3];
                } while (n2 >= 0);
            }
        } else if (n != 0) {
            if (object == this.zeroValue) {
                return 0;
            }
            n = VArray.length + -1;
            if (n >= 0) {
                do {
                    int n4;
                    if (VArray[n4 = n--] != object) continue;
                    return this.keyTable[n4];
                } while (n >= 0);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)object, this.zeroValue)) {
                return 0;
            }
            n = VArray.length + -1;
            if (n >= 0) {
                do {
                    int n5;
                    if (!Intrinsics.areEqual((Object)object, VArray[n5 = n--])) continue;
                    return this.keyTable[n5];
                } while (n >= 0);
            }
        }
        return null;
    }

    public final int findKey(Object object, boolean bl, int n) {
        Integer n2 = this.findKey(object, bl);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public final void ensureCapacity(int n) {
        if (this.keyTable.length < (n = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor))) {
            this.resize(n);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new int[n];
        this.valueTable = new Object[n];
        if (this.size_ > 0) {
            for (n = 0; n < n2; ++n) {
                int n3 = nArray[n];
                if (n3 == 0) continue;
                this.putResize(n3, VArray[n]);
            }
        }
    }

    @Override
    public int hashCode() {
        int n = this.size_;
        if (this.hasZeroValue && this.zeroValue != null) {
            V v = this.zeroValue;
            n += v != null ? v.hashCode() : 0;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            n += n3 * 31;
            V v = VArray[i];
            if (v == null) continue;
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        IntMap cfr_ignored_0 = (IntMap)object;
        if (((IntMap)object).size_ != this.size_) {
            return false;
        }
        if (((IntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntMap)object).zeroValue == null ? this.zeroValue != null : !Intrinsics.areEqual(((IntMap)object).zeroValue, this.zeroValue))) {
            return false;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            V v;
            int n2 = nArray[i];
            if (n2 == 0 || !((v = VArray[i]) == null ? ((IntMap)object).get(n2, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(v, ((IntMap)object).get((Object)n2)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        IntMap cfr_ignored_0 = (IntMap)object;
        if (((IntMap)object).size_ != this.size_) {
            return false;
        }
        if (((IntMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((IntMap)object).zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0 || VArray[i] == ((IntMap)object).get(n2, ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public Entries<V> entries() {
        if (this.allocateIterators) {
            Intrinsics.checkNotNull((Object)this);
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this);
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        Entries<V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    @Override
    public Values<V> values() {
        if (this.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5);
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9);
        return values9;
    }

    public Keys keys() {
        if (this.allocateIterators) {
            return new Keys((IntMap<?>)this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys((IntMap<?>)this);
            this.keys2 = new Keys((IntMap<?>)this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        return this.put(((Number)object).intValue(), object2);
    }

    @Override
    public final V get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final V remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final Set<Map.Entry<Integer, V>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<Integer> keySet() {
        return this.getKeys();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Override
    public final boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.containsKey(((Number)object).intValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/IntMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u00022\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\t\u0010\u0017\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0017\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u001aH\u0096\u0002J\u0011\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u001d\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\u001e\u0010\u001e\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Ldorkbox/collections/IntMap$Entries;", "V", "", "Ldorkbox/collections/IntMap$Entry;", "Ldorkbox/collections/IntMap$MapIterator;", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "entry", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static final class Entries<V>
    extends MapIterator<V, Entry<V>>
    implements Set<Entry<V>>,
    KMutableSet {
        private final Entry<V> entry;

        public Entries(IntMap<V> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"");
            super(intMap);
            this.entry = new Entry<V>(intMap);
        }

        @Override
        public final Entry<V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(nArray[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            Entries entries = this;
            entries.setCurrentIndex(entries.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final boolean add(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue());
            return true;
        }

        @Override
        public final boolean addAll(Collection<? extends Entry<V>> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                this.getMap().put(((Entry)object2).getKey(), ((Entry)object2).getValue());
                bl = true;
            }
            return bl;
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                int n = ((Number)((Map.Entry)object2).getKey()).intValue();
                object2 = ((Map.Entry)object2).getValue();
                if (Intrinsics.areEqual(this.getMap().get((Object)n), object2)) continue;
                return false;
            }
            return true;
        }

        public final boolean contains(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            return Intrinsics.areEqual(this.getMap().get(entry.getKey()), entry.getValue());
        }

        @Override
        public final Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            if (this.getMap().getHasZeroValue()) {
                boolean bl2;
                Object v0;
                block5: {
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        if (!(entry.getKey() == 0)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                if (bl2 = v0 != null) {
                    bl = this.getMap().remove((Object)0) != null;
                }
            }
            int[] nArray = this.getMap().getKeyTable();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object v1;
                int n2;
                int n3;
                block6: {
                    n2 = n3 = nArray[i];
                    if (n3 == 0) continue;
                    Object object = collection;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Entry entry = (Entry)e;
                        if (!(entry.getKey() == n2)) continue;
                        v1 = e;
                        break block6;
                    }
                    v1 = null;
                }
                if ((n3 = v1 != null ? 1 : 0) != 0) continue;
                bl = this.getMap().remove((Object)n2) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                int n = ((Number)((Map.Entry)object2).getKey()).intValue();
                bl = this.getMap().remove((Object)n) != null || bl;
            }
            this.reset();
            return bl;
        }

        public final boolean remove(Entry<V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"");
            boolean bl = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ldorkbox/collections/IntMap$Entry;", "V", "", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "key", "getKey", "()Ljava/lang/Integer;", "setKey", "(I)V", "getMap", "()Ldorkbox/collections/IntMap;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<V>
    implements Map.Entry<Integer, V>,
    KMutableMap.Entry {
        private final IntMap<V> map;
        private int key;
        private V value;

        public Entry(IntMap<V> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"");
            this.map = intMap;
        }

        public final IntMap<V> getMap() {
            return this.map;
        }

        @Override
        public final Integer getKey() {
            return this.key;
        }

        public final void setKey(int n) {
            this.key = n;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final void setValue(V v) {
            this.value = v;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.getValue();
            ((Map)this.map).put(this.getKey(), v);
            this.setValue(v);
            return v2;
        }

        public final String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\t\u0010\u0015\u001a\u00020\fH\u0096\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/IntMap$Keys;", "", "", "Ldorkbox/collections/IntMap$MapIterator;", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    public static final class Keys
    extends MapIterator<Object, Integer>
    implements Set<Integer>,
    KMutableSet {
        public Keys(IntMap<?> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"");
            super(intMap);
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.getNextIndex() == -1 ? 0 : this.getMap().getKeyTable()[this.getNextIndex()];
            Keys keys = this;
            keys.setCurrentIndex(keys.getNextIndex());
            this.findNextIndex();
            return n;
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
        }

        @Override
        public final boolean addAll(Collection<? extends Integer> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                bl = bl || this.getMap().put(n, (Object)null) == null;
            }
            return bl;
        }

        @Override
        public final boolean add(int n) {
            return this.getMap().put(n, (Object)null) == null;
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                if (this.getMap().containsKey((Object)n)) continue;
                return false;
            }
            return true;
        }

        public final boolean contains(int n) {
            return this.getMap().containsKey((Object)n);
        }

        @Override
        public final Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (int n : this.getMap().getKeyTable()) {
                if (collection.contains(n) || this.getMap().remove((Object)n) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                if (this.getMap().remove((Object)n) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        public final boolean remove(Integer n) {
            return this.getMap().remove(n) == null;
        }

        public final int[] toArray() {
            int[] nArray = new int[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        public final int[] toArray(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).intValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Integer)) {
                return false;
            }
            return this.contains(((Number)object).intValue());
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/IntMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final IntMap<V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(IntMap<V> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"");
            this.map = intMap;
            this.valid = true;
            this.reset();
        }

        public final IntMap<V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
                return;
            }
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                int[] nArray = this.map.getKeyTable();
                int n = nArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n;
            int n2 = this.currentIndex;
            if (n2 == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(null);
                return;
            }
            if (n2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            int[] nArray = this.map.getKeyTable();
            V[] VArray = this.map.getValueTable();
            int n3 = this.map.getMask();
            int n4 = n2 + 1 & n3;
            while (true) {
                int n5;
                n = n5 = nArray[n4];
                n = n5;
                if (n5 == 0) break;
                n5 = this.map.place(n);
                if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                    nArray[n2] = n;
                    VArray[n2] = VArray[n4];
                    n2 = n4;
                }
                n4 = n4 + 1 & n3;
            }
            nArray[n2] = 0;
            VArray[n2] = null;
            if (n2 != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -2;
            IntMap<V> intMap = this.map;
            n = ((IntMap)intMap).size_;
            ((IntMap)intMap).size_ = n + -1;
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\t\u0010\u0016\u001a\u00020\fH\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\u0002\u0010!R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/IntMap$Values;", "V", "", "Ldorkbox/collections/IntMap$MapIterator;", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    public static final class Values<V>
    extends MapIterator<V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(IntMap<V> intMap) {
            Intrinsics.checkNotNullParameter(intMap, (String)"");
            super(intMap);
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            Values values = this;
            values.setCurrentIndex(values.getNextIndex());
            this.findNextIndex();
            Object v2 = v;
            Intrinsics.checkNotNull(v2);
            return v2;
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public final boolean addAll(Collection<? extends V> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public final boolean add(V v) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.getMap().containsValue(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean contains(Object object) {
            return this.getMap().containsValue(object);
        }

        @Override
        public final Iterator<V> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (int n : this.getMap().getKeyTable()) {
                Object v;
                int n2 = n;
                n2 = n;
                if (n == 0 || CollectionsKt.contains((Iterable)collection, v = this.getMap().get((Object)n2))) continue;
                this.getMap().remove((Object)n2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = this.getMap().findKey(object2, false);
                if (object2 == null) continue;
                bl = this.getMap().remove(object2) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean remove(Object object) {
            boolean bl = false;
            object = this.getMap().findKey(object, false);
            if (object != null) {
                bl = this.getMap().remove(object) != null;
            }
            this.reset();
            return bl;
        }

        @Override
        public final V[] toArray() {
            int n = 0;
            int n2 = this.getMap().size_;
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next());
            }
            return objectArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }
    }
}

