/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor.listener;

import dorkbox.executor.Executor;
import dorkbox.executor.listener.ProcessListener;
import dorkbox.executor.processResults.ProcessResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0015\u001a\u00020\tJ\b\u0010\u0016\u001a\u00020\u0000H\u0016J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001J\u0016\u0010\u0018\u001a\u00020\t2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldorkbox/executor/listener/CompositeProcessListener;", "Ldorkbox/executor/listener/ProcessListener;", "", "()V", "children", "", "(Ljava/util/List;)V", "", "add", "", "listener", "afterFinish", "process", "Ljava/lang/Process;", "result", "Ldorkbox/executor/processResults/ProcessResult;", "afterStart", "executor", "Ldorkbox/executor/Executor;", "afterStop", "beforeStart", "clear", "clone", "remove", "removeAll", "type", "Ljava/lang/Class;", "Executor"})
public final class CompositeProcessListener
extends ProcessListener
implements Cloneable {
    private final List<ProcessListener> children;

    public CompositeProcessListener() {
        this.children = new CopyOnWriteArrayList();
    }

    public CompositeProcessListener(List<? extends ProcessListener> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.children = new CopyOnWriteArrayList();
        this.children.addAll((Collection<ProcessListener>)list);
    }

    public final void add(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.children.add(processListener);
    }

    public final void remove(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.children.remove(processListener);
    }

    public final void removeAll(Class<? extends ProcessListener> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Iterator<ProcessListener> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            if (!clazz.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public final CompositeProcessListener clone() {
        return new CompositeProcessListener(this.children);
    }

    @Override
    public final void beforeStart(Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"");
        Object object = this.children;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (ProcessListener)object2;
            ((ProcessListener)object2).beforeStart(executor);
        }
    }

    @Override
    public final void afterStart(Process process, Executor executor) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"");
        Object object = this.children;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (ProcessListener)object2;
            ((ProcessListener)object2).afterStart(process, executor);
        }
    }

    @Override
    public final void afterFinish(Process process, ProcessResult processResult) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"");
        Intrinsics.checkNotNullParameter((Object)processResult, (String)"");
        Object object = this.children;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (ProcessListener)object2;
            ((ProcessListener)object2).afterFinish(process, processResult);
        }
    }

    @Override
    public final void afterStop(Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"");
        Object object = this.children;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (ProcessListener)object2;
            ((ProcessListener)object2).afterStop(process);
        }
    }
}

