/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
extends ChannelInboundHandlerAdapter {
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        this.handleNewChannel(channelHandlerContext);
        channelHandlerContext.fireChannelRegistered();
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (!this.handleNewChannel(channelHandlerContext)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + channelHandlerContext.channel());
        }
        channelHandlerContext.fireChannelActive();
    }

    private boolean handleNewChannel(ChannelHandlerContext channelHandlerContext) {
        SocketAddress socketAddress = channelHandlerContext.channel().remoteAddress();
        if (socketAddress == null) {
            return false;
        }
        channelHandlerContext.pipeline().remove((ChannelHandler)this);
        if (this.accept(channelHandlerContext, socketAddress)) {
            this.channelAccepted(channelHandlerContext, socketAddress);
        } else if ((socketAddress = this.channelRejected(channelHandlerContext, socketAddress)) != null) {
            socketAddress.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.close();
        }
        return true;
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2);

    protected void channelAccepted(ChannelHandlerContext channelHandlerContext, T t) {
    }

    protected ChannelFuture channelRejected(ChannelHandlerContext channelHandlerContext, T t) {
        return null;
    }
}

