/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.b.a.a.a;
import org.b.a.a.b;
import org.b.a.a.c;

abstract class JettyAlpnSslEngine
extends JdkSslEngine {
    private static final boolean available = JettyAlpnSslEngine.initAvailable();

    static boolean isAvailable() {
        return available;
    }

    private static boolean initAvailable() {
        if (PlatformDependent.javaVersion() <= 8) {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    static JettyAlpnSslEngine newClientEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    static JettyAlpnSslEngine newServerEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    private JettyAlpnSslEngine(SSLEngine sSLEngine) {
        super(sSLEngine);
    }

    private static final class ServerEngine
    extends JettyAlpnSslEngine {
        ServerEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator object) {
            super(sSLEngine);
            ObjectUtil.checkNotNull((Object)object, (String)"applicationNegotiator");
            object = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)object.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(object.protocols())), (String)"protocolSelector");
            a.a((SSLEngine)sSLEngine, (a.a)new c((JdkApplicationProtocolNegotiator.ProtocolSelector)object){
                final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelector val$protocolSelector;
                {
                    this.val$protocolSelector = protocolSelector;
                }

                public String select(List<String> object) {
                    try {
                        return this.val$protocolSelector.select((List<String>)object);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw SslUtils.toSSLHandshakeException(throwable);
                    }
                }

                public void unsupported() {
                    this.val$protocolSelector.unsupported();
                }
            });
        }

        @Override
        public final void closeInbound() {
            try {
                a.a((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        @Override
        public final void closeOutbound() {
            try {
                a.a((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }

    private static final class ClientEngine
    extends JettyAlpnSslEngine {
        ClientEngine(SSLEngine sSLEngine, final JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine);
            ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator, (String)"applicationNegotiator");
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolSelectionListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), (String)"protocolListener");
            a.a((SSLEngine)sSLEngine, (a.a)new b(){

                public List<String> protocols() {
                    return jdkApplicationProtocolNegotiator.protocols();
                }

                public void selected(String object) {
                    try {
                        protocolSelectionListener.selected((String)object);
                        return;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw SslUtils.toSSLHandshakeException(throwable);
                    }
                }

                public void unsupported() {
                    protocolSelectionListener.unsupported();
                }
            });
        }

        @Override
        public final void closeInbound() {
            try {
                a.a((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        @Override
        public final void closeOutbound() {
            try {
                a.a((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }
}

