/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.InnerShadowScope;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.graphics.shadow.InnerShadowPainter;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.ObserverModifierNode;
import androidx.compose.ui.node.ObserverModifierNodeKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B(\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010@\u001a\u00020\tH\u0016J\b\u0010A\u001a\u00020\tH\u0016J\b\u0010B\u001a\u00020\tH\u0002J'\u0010C\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\nJ\f\u0010D\u001a\u00020\t*\u00020EH\u0016J\b\u0010F\u001a\u00020\u0012H\u0002J\b\u0010G\u001a\u00020\tH\u0016J\b\u0010H\u001a\u00020\tH\u0002J\u0013\u0010I\u001a\u00020\u00142\b\u0010J\u001a\u0004\u0018\u00010KH\u0096\u0002J\b\u0010L\u001a\u00020MH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR$\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010!R&\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020%@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010-\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020,@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b.\u0010(\"\u0004\b/\u0010*R(\u00101\u001a\u0004\u0018\u0001002\b\u0010\u0015\u001a\u0004\u0018\u000100@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001b\"\u0004\b8\u0010!R&\u0010:\u001a\u0002092\u0006\u0010\u0015\u001a\u000209@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010?\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006N"}, d2={"Landroidx/compose/ui/draw/BlockInnerShadowNode;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/ObserverModifierNode;", "Landroidx/compose/ui/draw/InnerShadowScope;", "shape", "Landroidx/compose/ui/graphics/Shape;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Landroidx/compose/ui/graphics/Shape;Lkotlin/jvm/functions/Function1;)V", "densityObject", "Landroidx/compose/ui/unit/Density;", "targetShadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "shadowPainter", "Landroidx/compose/ui/graphics/shadow/InnerShadowPainter;", "blockRead", "", "value", "setBlock", "(Lkotlin/jvm/functions/Function1;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "radius", "getRadius", "setRadius", "(F)V", "spread", "getSpread", "setSpread", "Landroidx/compose/ui/geometry/Offset;", "offset", "getOffset-F1C5BW0", "()J", "setOffset-k-4lQ0M", "(J)V", "J", "Landroidx/compose/ui/graphics/Color;", "color", "getColor-0d7_KjU", "setColor-8_81llA", "Landroidx/compose/ui/graphics/Brush;", "brush", "getBrush", "()Landroidx/compose/ui/graphics/Brush;", "setBrush", "(Landroidx/compose/ui/graphics/Brush;)V", "alpha", "getAlpha", "setAlpha", "Landroidx/compose/ui/graphics/BlendMode;", "blendMode", "getBlendMode-0nO6VwU", "()I", "setBlendMode-s9anfk8", "(I)V", "I", "onAttach", "onDensityChange", "updateDensity", "update", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "obtainPainter", "onObservedReadsChanged", "invalidateShadow", "equals", "other", "", "hashCode", "", "ui"})
public final class BlockInnerShadowNode
extends Modifier.Node
implements InnerShadowScope,
DrawModifierNode,
ObserverModifierNode {
    private Shape shape;
    private Density densityObject;
    private Shadow targetShadow;
    private InnerShadowPainter shadowPainter;
    private boolean blockRead;
    private Function1<? super InnerShadowScope, Unit> block;
    private float radius;
    private float spread;
    private long offset;
    private long color;
    private Brush brush;
    private float alpha;
    private int blendMode;
    public static final int $stable;

    public BlockInnerShadowNode(Shape shape, Function1<? super InnerShadowScope, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.shape = shape;
        this.block = function1;
        this.offset = Offset.Companion.getZero-F1C5BW0();
        this.color = Color.Companion.getBlack-0d7_KjU();
        this.alpha = 1.0f;
        this.blendMode = BlendMode.Companion.getSrcOver-0nO6VwU();
    }

    private final void setBlock(Function1<? super InnerShadowScope, Unit> function1) {
        if (this.block != function1) {
            this.block = function1;
            this.blockRead = false;
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    public final float getDensity() {
        Density density = this.densityObject;
        if (density != null) {
            return density.getDensity();
        }
        return 1.0f;
    }

    public final float getFontScale() {
        Density density = this.densityObject;
        if (density != null) {
            return density.getFontScale();
        }
        return 1.0f;
    }

    @Override
    public final float getRadius() {
        return this.radius;
    }

    @Override
    public final void setRadius(float f2) {
        if (!(this.radius == f2)) {
            this.radius = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public final float getSpread() {
        return this.spread;
    }

    @Override
    public final void setSpread(float f2) {
        if (!(this.spread == f2)) {
            this.spread = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public final long getOffset-F1C5BW0() {
        return this.offset;
    }

    @Override
    public final void setOffset-k-4lQ0M(long l2) {
        if (!Offset.equals-impl0((long)this.offset, (long)l2)) {
            this.offset = l2;
            this.invalidateShadow();
        }
    }

    @Override
    public final long getColor-0d7_KjU() {
        return this.color;
    }

    @Override
    public final void setColor-8_81llA(long l2) {
        long l3;
        long l4 = l3 = l2 != 16L ? l2 : Color.Companion.getBlack-0d7_KjU();
        if (!Color.equals-impl0((long)this.color, (long)l3)) {
            this.color = l3;
            this.invalidateShadow();
        }
    }

    @Override
    public final Brush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(Brush brush) {
        if (!Intrinsics.areEqual((Object)this.brush, (Object)brush)) {
            this.brush = brush;
            this.invalidateShadow();
        }
    }

    @Override
    public final float getAlpha() {
        return this.alpha;
    }

    @Override
    public final void setAlpha(float f2) {
        if (!(this.alpha == f2)) {
            this.alpha = f2;
            this.invalidateShadow();
        }
    }

    @Override
    public final int getBlendMode-0nO6VwU() {
        return this.blendMode;
    }

    @Override
    public final void setBlendMode-s9anfk8(int n) {
        if (!BlendMode.equals-impl0((int)this.blendMode, (int)n)) {
            this.blendMode = n;
            this.invalidateShadow();
        }
    }

    @Override
    public final void onAttach() {
        super.onAttach();
        this.updateDensity();
    }

    @Override
    public final void onDensityChange() {
        if (this.isAttached()) {
            this.updateDensity();
        }
    }

    private final void updateDensity() {
        Density density = DelegatableNodeKt.requireDensity(this);
        if (!Intrinsics.areEqual((Object)this.densityObject, (Object)density)) {
            this.densityObject = density;
            this.block.invoke((Object)this);
            this.invalidateShadow();
        }
    }

    public final void update(Shape shape, Function1<? super InnerShadowScope, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.shape = shape;
        this.setBlock(function1);
    }

    @Override
    public final void draw(ContentDrawScope contentDrawScope) {
        Intrinsics.checkNotNullParameter((Object)contentDrawScope, (String)"");
        InnerShadowPainter innerShadowPainter = this.obtainPainter();
        Painter.draw-x_KDEd0$default((Painter)((Painter)innerShadowPainter), (DrawScope)((DrawScope)contentDrawScope), (long)contentDrawScope.getSize-NH-jbRc(), (float)0.0f, null, (int)6, null);
        contentDrawScope.drawContent();
    }

    private final InnerShadowPainter obtainPainter() {
        if (!this.blockRead) {
            this.blockRead = true;
            ObserverModifierNodeKt.observeReads((Modifier.Node)this, (Function0<Unit>)((Function0)() -> BlockInnerShadowNode.obtainPainter$lambda$1(this)));
        }
        Shadow shadow = this.targetShadow;
        InnerShadowPainter innerShadowPainter = this.shadowPainter;
        Brush brush = this.getBrush();
        BlockInnerShadowNode blockInnerShadowNode = this;
        float f2 = blockInnerShadowNode.toDp-u2uoSUM(blockInnerShadowNode.getRadius());
        BlockInnerShadowNode blockInnerShadowNode2 = this;
        float f3 = blockInnerShadowNode2.toDp-u2uoSUM(blockInnerShadowNode2.getSpread());
        BlockInnerShadowNode blockInnerShadowNode3 = this;
        long l2 = blockInnerShadowNode3.getOffset-F1C5BW0();
        int n = (int)(l2 >> 32);
        float f4 = blockInnerShadowNode3.toDp-u2uoSUM(Float.intBitsToFloat(n));
        BlockInnerShadowNode blockInnerShadowNode4 = this;
        long l3 = blockInnerShadowNode4.getOffset-F1C5BW0();
        int n2 = (int)l3;
        float f5 = blockInnerShadowNode4.toDp-u2uoSUM(Float.intBitsToFloat(n2));
        long l4 = Float.floatToRawIntBits(f4);
        long l5 = Float.floatToRawIntBits(f5);
        long l6 = DpOffset.constructor-impl((long)(l4 << 32 | l5 & 0xFFFFFFFFL));
        if (!(innerShadowPainter != null && shadow != null && Dp.equals-impl0((float)shadow.getRadius-D9Ej5fM(), (float)f2) && Dp.equals-impl0((float)shadow.getSpread-D9Ej5fM(), (float)f3) && Color.equals-impl0((long)shadow.getColor-0d7_KjU(), (long)this.getColor-0d7_KjU()) && Intrinsics.areEqual((Object)shadow.getBrush(), (Object)brush) && shadow.getAlpha() == this.getAlpha() && BlendMode.equals-impl0((int)shadow.getBlendMode-0nO6VwU(), (int)this.getBlendMode-0nO6VwU()) && DpOffset.equals-impl0((long)shadow.getOffset-RKDOV3M(), (long)l6))) {
            Shadow shadow2;
            Shadow shadow3 = brush != null ? new Shadow(f2, brush, f3, l6, this.getAlpha(), this.getBlendMode-0nO6VwU(), null) : new Shadow(f2, this.getColor-0d7_KjU(), f3, l6, this.getAlpha(), this.getBlendMode-0nO6VwU(), null);
            this.targetShadow = shadow2 = shadow3;
            shadow = shadow3;
            shadow2 = shadow3 = DelegatableNodeKt.requireGraphicsContext(this).getShadowContext().createInnerShadowPainter(this.shape, shadow);
            this.shadowPainter = shadow2;
            innerShadowPainter = shadow3;
        }
        return innerShadowPainter;
    }

    @Override
    public final void onObservedReadsChanged() {
        this.invalidateShadow();
        this.blockRead = false;
    }

    private final void invalidateShadow() {
        this.targetShadow = null;
        this.shadowPainter = null;
        DrawModifierNodeKt.invalidateDraw(this);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BlockInnerShadowNode)) {
            return false;
        }
        if (!(this.getAlpha() == ((BlockInnerShadowNode)object).getAlpha())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shape, (Object)((BlockInnerShadowNode)object).shape)) {
            return false;
        }
        if (this.block != ((BlockInnerShadowNode)object).block) {
            return false;
        }
        if (!(this.getRadius() == ((BlockInnerShadowNode)object).getRadius())) {
            return false;
        }
        if (!(this.getSpread() == ((BlockInnerShadowNode)object).getSpread())) {
            return false;
        }
        if (!Offset.equals-impl0((long)this.getOffset-F1C5BW0(), (long)((BlockInnerShadowNode)object).getOffset-F1C5BW0())) {
            return false;
        }
        if (!Color.equals-impl0((long)this.getColor-0d7_KjU(), (long)((BlockInnerShadowNode)object).getColor-0d7_KjU())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBrush(), (Object)((BlockInnerShadowNode)object).getBrush())) {
            return false;
        }
        return BlendMode.equals-impl0((int)this.getBlendMode-0nO6VwU(), (int)((BlockInnerShadowNode)object).getBlendMode-0nO6VwU());
    }

    public final int hashCode() {
        int n = Float.hashCode(this.getAlpha());
        n = n * 31 + this.shape.hashCode();
        n = n * 31 + this.block.hashCode();
        n = n * 31 + Float.hashCode(this.getRadius());
        n = n * 31 + Float.hashCode(this.getSpread());
        n = n * 31 + Offset.hashCode-impl((long)this.getOffset-F1C5BW0());
        n = n * 31 + Color.hashCode-impl((long)this.getColor-0d7_KjU());
        Brush brush = this.getBrush();
        n = n * 31 + (brush != null ? brush.hashCode() : 0);
        n = n * 31 + BlendMode.hashCode-impl((int)this.getBlendMode-0nO6VwU());
        return n;
    }

    private static final Unit obtainPainter$lambda$1(BlockInnerShadowNode blockInnerShadowNode) {
        blockInnerShadowNode.block.invoke((Object)blockInnerShadowNode);
        return Unit.INSTANCE;
    }
}

