/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.graphics.shadow.DropShadowPainter;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.ObserverModifierNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/draw/SimpleDropShadowNode;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/ObserverModifierNode;", "shape", "Landroidx/compose/ui/graphics/Shape;", "shadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "<init>", "(Landroidx/compose/ui/graphics/Shape;Landroidx/compose/ui/graphics/shadow/Shadow;)V", "shadowPainter", "Landroidx/compose/ui/graphics/shadow/DropShadowPainter;", "update", "", "obtainPainter", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "onObservedReadsChanged", "equals", "", "other", "", "hashCode", "", "ui"})
public final class SimpleDropShadowNode
extends Modifier.Node
implements DrawModifierNode,
ObserverModifierNode {
    private Shape shape;
    private Shadow shadow;
    private DropShadowPainter shadowPainter;
    public static final int $stable = 8;

    public SimpleDropShadowNode(Shape shape, Shadow shadow) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"");
        this.shape = shape;
        this.shadow = shadow;
    }

    public final void update(Shape shape, Shadow shadow) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"");
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"");
        boolean bl = !Intrinsics.areEqual((Object)this.shape, (Object)shape) || !Intrinsics.areEqual((Object)this.shadow, (Object)shadow);
        if (bl) {
            this.shadowPainter = null;
        }
        this.shape = shape;
        this.shadow = shadow;
    }

    private final DropShadowPainter obtainPainter() {
        DropShadowPainter dropShadowPainter = this.shadowPainter;
        if (dropShadowPainter == null) {
            DropShadowPainter dropShadowPainter2;
            DropShadowPainter dropShadowPainter3;
            this.shadowPainter = dropShadowPainter3 = (dropShadowPainter2 = DelegatableNodeKt.requireGraphicsContext(this).getShadowContext().createDropShadowPainter(this.shape, this.shadow));
            dropShadowPainter = dropShadowPainter2;
        }
        return dropShadowPainter;
    }

    @Override
    public final void draw(ContentDrawScope contentDrawScope) {
        Intrinsics.checkNotNullParameter((Object)contentDrawScope, (String)"");
        DropShadowPainter dropShadowPainter = this.obtainPainter();
        Painter.draw-x_KDEd0$default((Painter)((Painter)dropShadowPainter), (DrawScope)((DrawScope)contentDrawScope), (long)contentDrawScope.getSize-NH-jbRc(), (float)0.0f, null, (int)6, null);
        contentDrawScope.drawContent();
    }

    @Override
    public final void onObservedReadsChanged() {
        this.shadowPainter = null;
        DrawModifierNodeKt.invalidateDraw(this);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SimpleDropShadowNode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shape, (Object)((SimpleDropShadowNode)object).shape)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.shadow, (Object)((SimpleDropShadowNode)object).shadow);
    }

    public final int hashCode() {
        int n = this.shape.hashCode();
        n = n * 31 + this.shadow.hashCode();
        return n;
    }
}

