/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.b.J;
import androidx.b.Q;
import androidx.b.R;
import androidx.b.a.d;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSetKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\bJ\"\u0010\u0011\u001a\u00020\u000e2\u0014\b\u0004\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u0086\bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/node/DepthSortedSet;", "", "extraAssertions", "", "<init>", "(Z)V", "mapOfOriginalDepth", "Landroidx/collection/MutableObjectIntMap;", "Landroidx/compose/ui/node/LayoutNode;", "set", "Landroidx/compose/ui/node/SortedSet;", "contains", "node", "add", "", "remove", "pop", "popEach", "block", "Lkotlin/Function1;", "isEmpty", "isNotEmpty", "safeMapOfOriginalDepth", "toString", "", "ui"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    private J<LayoutNode> mapOfOriginalDepth;
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    public DepthSortedSet(boolean bl) {
        this.extraAssertions = bl;
        this.set = new SortedSet(DepthSortedSetKt.access$getDepthComparator$p());
    }

    public final boolean contains(LayoutNode layoutNode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"");
        boolean bl2 = this.set.contains(layoutNode);
        if (this.extraAssertions && !(bl = bl2 == this.safeMapOfOriginalDepth().a(layoutNode))) {
            InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
        }
        return bl2;
    }

    public final void add(LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"");
        boolean bl = layoutNode.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            J<LayoutNode> j = this.safeMapOfOriginalDepth();
            int n2 = j.b((Object)layoutNode, Integer.MAX_VALUE);
            if (n2 == Integer.MAX_VALUE) {
                LayoutNode layoutNode2 = layoutNode;
                j.a((Object)layoutNode2, layoutNode2.getDepth$ui());
            } else {
                boolean bl2 = n2 == layoutNode.getDepth$ui();
                if (!bl2) {
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add(layoutNode);
    }

    public final boolean remove(LayoutNode layoutNode) {
        J<LayoutNode> j;
        Q q;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"");
        boolean bl = layoutNode.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        bl = this.set.remove(layoutNode);
        if (this.extraAssertions && (q = (Q)(j = this.safeMapOfOriginalDepth())).a(layoutNode)) {
            boolean bl2;
            J<LayoutNode> j2 = j;
            LayoutNode layoutNode2 = layoutNode;
            int n2 = j2.a((Object)layoutNode2);
            if (n2 < 0) {
                d.c((String)("There is no key " + layoutNode2 + " in the map"));
            }
            int n3 = j2.c[n2];
            j2 = j;
            layoutNode2 = layoutNode;
            n2 = j2.a((Object)layoutNode2);
            if (n2 >= 0) {
                j2.a(n2);
            }
            if (!(bl2 = n3 == (bl ? layoutNode.getDepth$ui() : Integer.MAX_VALUE))) {
                InlineClassHelperKt.throwIllegalStateException("invalid node depth");
            }
        }
        return bl;
    }

    public final LayoutNode pop() {
        LayoutNode layoutNode = (LayoutNode)this.set.first();
        this.remove(layoutNode);
        return layoutNode;
    }

    public final void popEach(Function1<? super LayoutNode, Unit> function1) {
        Object object;
        Intrinsics.checkNotNullParameter(function1, (String)"");
        while (!((DepthSortedSet)(object = this)).isEmpty()) {
            object = this.pop();
            function1.invoke(object);
        }
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private final J<LayoutNode> safeMapOfOriginalDepth() {
        if (this.mapOfOriginalDepth == null) {
            this.mapOfOriginalDepth = R.b();
        }
        J<LayoutNode> j = this.mapOfOriginalDepth;
        Intrinsics.checkNotNull(j);
        return j;
    }

    public final String toString() {
        return this.set.toString();
    }
}

