/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.b.D;
import androidx.b.k;
import androidx.b.l;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.semantics.LtrBoundsComparator;
import androidx.compose.ui.semantics.RtlBoundsComparator;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.TopBottomBoundsComparator;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a`\u0010\b\u001a\u00020\t*\u00020\u00022\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\f2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u000eH\u0002\u001aL\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0012H\u0000\u001aL\u0010\u0013\u001a\u00020\u00052:\u0010\u0014\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00150\u000bj\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u0015`\f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\"&\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u001bj\b\u0012\u0004\u0012\u00020\u0002`\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\" \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"subtreeSortedByGeometryGrouping", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "isVisible", "Lkotlin/Function1;", "", "isFocusableContainer", "listToSort", "geometryDepthFirstSearch", "", "geometryList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "containerMapToChildren", "Landroidx/collection/MutableIntObjectMap;", "sortByGeometryGroupings", "parentListToSort", "containerChildrenMapping", "Landroidx/collection/IntObjectMap;", "placedEntryRowOverlaps", "rowGroupings", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "", "node", "semanticComparators", "", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "[Ljava/util/Comparator;", "UnmergedConfigComparator", "Lkotlin/Function2;", "", "ui"})
public final class SemanticsSortKt {
    private static final Comparator<SemanticsNode>[] semanticComparators;
    private static final Function2<SemanticsNode, SemanticsNode, Integer> UnmergedConfigComparator;

    public static final List<SemanticsNode> subtreeSortedByGeometryGrouping(SemanticsNode semanticsNode, Function1<? super SemanticsNode, Boolean> function1, Function1<? super SemanticsNode, Boolean> function12, List<SemanticsNode> list) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(function12, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        D d2 = l.c();
        ArrayList<SemanticsNode> arrayList = new ArrayList<SemanticsNode>();
        int n2 = ((Collection)list).size();
        for (int j = 0; j < n2; ++j) {
            SemanticsNode semanticsNode2 = list.get(j);
            SemanticsNode semanticsNode3 = semanticsNode2;
            semanticsNode3 = semanticsNode2;
            SemanticsSortKt.geometryDepthFirstSearch(semanticsNode2, arrayList, function1, function12, (D<List<SemanticsNode>>)d2);
        }
        return SemanticsSortKt.sortByGeometryGroupings(semanticsNode, (List<SemanticsNode>)arrayList, function12, (k<List<SemanticsNode>>)((k)d2));
    }

    private static final void geometryDepthFirstSearch(SemanticsNode object, ArrayList<SemanticsNode> arrayList, Function1<? super SemanticsNode, Boolean> function1, Function1<? super SemanticsNode, Boolean> function12, D<List<SemanticsNode>> d2) {
        int n2 = ((SemanticsNode)object).getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getIsTraversalGroup(), SemanticsSortKt::geometryDepthFirstSearch$lambda$1).booleanValue();
        if ((n2 != 0 || ((Boolean)function12.invoke(object)).booleanValue()) && ((Boolean)function1.invoke(object)).booleanValue()) {
            arrayList.add((SemanticsNode)object);
        }
        if (n2 != 0) {
            d2.a(((SemanticsNode)object).getId(), SemanticsSortKt.subtreeSortedByGeometryGrouping((SemanticsNode)object, function1, function12, ((SemanticsNode)object).getChildren()));
            return;
        }
        object = ((SemanticsNode)object).getChildren();
        int n3 = ((Collection)object).size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object object2 = object.get(n2);
            object2 = (SemanticsNode)object2;
            SemanticsSortKt.geometryDepthFirstSearch((SemanticsNode)object2, arrayList, function1, function12, d2);
        }
    }

    public static final List<SemanticsNode> sortByGeometryGroupings(SemanticsNode semanticsNode, List<SemanticsNode> object, Function1<? super SemanticsNode, Boolean> function1, k<List<SemanticsNode>> k2) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Intrinsics.checkNotNullParameter(k2, (String)"");
        int n2 = semanticsNode.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl ? 1 : 0;
        ArrayList<Pair<Rect, List<SemanticsNode>>> arrayList = new ArrayList<Pair<Rect, List<SemanticsNode>>>(object.size() / 2);
        int n3 = 0;
        int n4 = CollectionsKt.getLastIndex(object);
        if (n4 >= 0) {
            while (true) {
                object2 = object.get(n3);
                if (n3 == 0 || !SemanticsSortKt.placedEntryRowOverlaps(arrayList, (SemanticsNode)object2)) {
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray = ((SemanticsNode)object2).getBoundsInWindow();
                    Object[] objectArray3 = new SemanticsNode[1];
                    objectArray = objectArray3;
                    objectArray3[0] = object2;
                    arrayList.add((Pair<Rect, List<SemanticsNode>>)new Pair((Object)objectArray2, (Object)CollectionsKt.mutableListOf((Object[])objectArray)));
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        CollectionsKt.sortWith((List)arrayList, (Comparator)TopBottomBoundsComparator.INSTANCE);
        ArrayList arrayList2 = new ArrayList();
        Comparator<SemanticsNode> comparator = semanticComparators[n2 != 0 ? 0 : 1];
        object2 = arrayList;
        n2 = ((Collection)object2).size();
        for (int j = 0; j < n2; ++j) {
            object = object2.get(j);
            object = object;
            CollectionsKt.sortWith((List)((List)object.getSecond()), comparator);
            arrayList2.addAll((Collection)object.getSecond());
        }
        CollectionsKt.sortWith((List)arrayList2, (arg_0, arg_1) -> SemanticsSortKt.sortByGeometryGroupings$lambda$5(UnmergedConfigComparator, arg_0, arg_1));
        int n5 = 0;
        while (n5 <= CollectionsKt.getLastIndex((List)arrayList2)) {
            int n6 = ((SemanticsNode)arrayList2.get(n5)).getId();
            List list = (List)k2.a(n6);
            if (list != null) {
                Object e2 = arrayList2.get(n5);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"");
                boolean bl = (Boolean)function1.invoke(e2);
                n2 = bl ? 1 : 0;
                if (!bl) {
                    object = arrayList2.remove(n5);
                    Intrinsics.checkNotNull(object);
                } else {
                    ++n5;
                }
                arrayList2.addAll(n5, list);
                n5 += list.size();
                continue;
            }
            ++n5;
        }
        return arrayList2;
    }

    public static /* synthetic */ List sortByGeometryGroupings$default(SemanticsNode semanticsNode, List list, Function1 function1, k k2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = SemanticsSortKt::sortByGeometryGroupings$lambda$3;
        }
        if ((n2 & 4) != 0) {
            k2 = l.b();
        }
        return SemanticsSortKt.sortByGeometryGroupings(semanticsNode, list, (Function1<? super SemanticsNode, Boolean>)function1, (k<List<SemanticsNode>>)k2);
    }

    private static final boolean placedEntryRowOverlaps(ArrayList<Pair<Rect, List<SemanticsNode>>> arrayList, SemanticsNode semanticsNode) {
        float f2;
        float f3 = semanticsNode.getBoundsInWindow().getTop();
        boolean bl = f3 >= (f2 = semanticsNode.getBoundsInWindow().getBottom());
        int n2 = 0;
        int n3 = CollectionsKt.getLastIndex((List)arrayList);
        if (n3 >= 0) {
            while (true) {
                Rect rect;
                Rect rect2 = (Rect)arrayList.get(n2).getFirst();
                boolean bl2 = rect.getTop() >= rect2.getBottom();
                bl2 = !bl && !bl2 && Math.max(f3, rect2.getTop()) < Math.min(f2, rect2.getBottom());
                if (bl2) {
                    Rect rect3 = rect2.intersect(0.0f, f3, Float.POSITIVE_INFINITY, f2);
                    arrayList.set(n2, (Pair<Rect, List<SemanticsNode>>)new Pair((Object)rect3, arrayList.get(n2).getSecond()));
                    ((List)arrayList.get(n2).getSecond()).add(semanticsNode);
                    return true;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        return false;
    }

    private static final boolean geometryDepthFirstSearch$lambda$1() {
        return false;
    }

    private static final boolean sortByGeometryGroupings$lambda$3(SemanticsNode semanticsNode) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        return false;
    }

    private static final int sortByGeometryGroupings$lambda$5(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final float UnmergedConfigComparator$lambda$10$lambda$8() {
        return 0.0f;
    }

    private static final float UnmergedConfigComparator$lambda$10$lambda$9() {
        return 0.0f;
    }

    private static final int UnmergedConfigComparator$lambda$10(SemanticsNode semanticsNode, SemanticsNode semanticsNode2) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)semanticsNode2, (String)"");
        return Float.compare(((Number)semanticsNode.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getTraversalIndex(), SemanticsSortKt::UnmergedConfigComparator$lambda$10$lambda$8)).floatValue(), ((Number)semanticsNode2.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getTraversalIndex(), SemanticsSortKt::UnmergedConfigComparator$lambda$10$lambda$9)).floatValue());
    }

    static {
        Comparator[] comparatorArray = new Comparator[2];
        for (int j = 0; j < 2; ++j) {
            int n2;
            int n3 = n2 = j;
            Comparator comparator = n3 == 0 ? (Comparator)RtlBoundsComparator.INSTANCE : (Comparator)LtrBoundsComparator.INSTANCE;
            comparator = comparator;
            Comparator<LayoutNode> comparator2 = LayoutNode.Companion.getZComparator$ui();
            comparator = new Comparator(comparator, comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ Comparator $comparator;
                {
                    this.$this_thenBy = comparator;
                    this.$comparator = comparator2;
                }

                public final int compare(T object, T object2) {
                    int n2 = this.$this_thenBy.compare(object, object2);
                    if (n2 != 0) {
                        return n2;
                    }
                    object = (SemanticsNode)object;
                    Comparator comparator = this.$comparator;
                    object = (SemanticsNode)object2;
                    object2 = ((SemanticsNode)object).getLayoutNode$ui();
                    object = ((SemanticsNode)object).getLayoutNode$ui();
                    return comparator.compare(object2, object);
                }
            };
            comparatorArray[n3] = new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = comparator;
                }

                public final int compare(T object, T object2) {
                    int n2 = this.$this_thenBy.compare(object, object2);
                    if (n2 != 0) {
                        return n2;
                    }
                    SemanticsNode semanticsNode = (SemanticsNode)object;
                    object = semanticsNode;
                    object = (SemanticsNode)object2;
                    object2 = semanticsNode.getId();
                    return ComparisonsKt.compareValues(object2, (Comparable)Integer.valueOf(((SemanticsNode)object).getId()));
                }
            };
        }
        semanticComparators = comparatorArray;
        UnmergedConfigComparator = SemanticsSortKt::UnmergedConfigComparator$lambda$10;
    }
}

