/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;

public class Java7ZlibInputOutputStream
extends XMPPInputOutputStream {
    private static final int compressionLevel = -1;

    public Java7ZlibInputOutputStream() {
        super("zlib");
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream) {
        return new InflaterInputStream(inputStream, new Inflater(), 512){

            @Override
            public int available() {
                if (this.inf.needsInput()) {
                    return 0;
                }
                return super.available();
            }
        };
    }

    @Override
    public OutputStream getOutputStream(OutputStream outputStream) {
        int n;
        switch (flushMethod) {
            case SYNC_FLUSH: {
                n = 2;
                break;
            }
            case FULL_FLUSH: {
                n = 3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new DeflaterOutputStream(outputStream, new Deflater(-1)){

            @Override
            public void flush() {
                int n2;
                while ((n2 = this.def.deflate(this.buf, 0, this.buf.length, n)) > 0) {
                    this.out.write(this.buf, 0, n2);
                }
                super.flush();
            }
        };
    }
}

