/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

public class HashCode {
    private static final int MULTIPLIER_VALUE = 37;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int hashcode = 17;

        private void applyHash() {
            this.applyHash(0);
        }

        private void applyHash(int n) {
            this.hashcode = 37 * this.hashcode + n;
        }

        public Builder append(Object object) {
            if (object == null) {
                this.applyHash();
                return this;
            }
            if (object.getClass().isArray()) {
                if (object instanceof int[]) {
                    this.append((Object)((int[])object));
                } else if (object instanceof long[]) {
                    this.append((long[])object);
                } else if (object instanceof boolean[]) {
                    this.append((boolean[])object);
                } else if (object instanceof double[]) {
                    this.append((double[])object);
                } else if (object instanceof float[]) {
                    this.append((float[])object);
                } else if (object instanceof short[]) {
                    this.append((Object)((short[])object));
                } else if (object instanceof char[]) {
                    this.append((char[])object);
                } else if (object instanceof byte[]) {
                    this.append((byte[])object);
                } else {
                    this.append((Object[])object);
                }
            }
            this.applyHash(object.hashCode());
            return this;
        }

        public Builder append(boolean bl) {
            this.applyHash(bl ? 0 : 1);
            return this;
        }

        public Builder append(boolean[] blArray) {
            if (blArray == null) {
                this.applyHash();
                return this;
            }
            for (boolean bl : blArray) {
                this.append(bl);
            }
            return this;
        }

        public Builder append(byte by) {
            this.applyHash(by);
            return this;
        }

        public Builder append(byte[] byArray) {
            if (byArray == null) {
                this.applyHash();
                return this;
            }
            for (byte by : byArray) {
                this.append(by);
            }
            return this;
        }

        public Builder append(char c2) {
            this.applyHash(c2);
            return this;
        }

        public Builder append(char[] cArray) {
            if (cArray == null) {
                this.applyHash();
                return this;
            }
            for (char c2 : cArray) {
                this.append(c2);
            }
            return this;
        }

        public Builder append(double d2) {
            return this.append(Double.doubleToLongBits(d2));
        }

        public Builder append(double[] dArray) {
            if (dArray == null) {
                this.applyHash();
                return this;
            }
            for (double d2 : dArray) {
                this.append(d2);
            }
            return this;
        }

        public Builder append(float f2) {
            return this.append(Float.floatToIntBits(f2));
        }

        public Builder append(float[] fArray) {
            if (fArray == null) {
                this.applyHash();
                return this;
            }
            for (float f2 : fArray) {
                this.append(f2);
            }
            return this;
        }

        public Builder append(long l) {
            long l2 = l;
            this.applyHash((int)(l2 ^ l2 >>> 32));
            return this;
        }

        public Builder append(long[] lArray) {
            if (lArray == null) {
                this.applyHash();
                return this;
            }
            for (long l : lArray) {
                this.append(l);
            }
            return this;
        }

        public Builder append(Object[] objectArray) {
            if (objectArray == null) {
                this.applyHash();
                return this;
            }
            for (Object object : objectArray) {
                this.append(object);
            }
            return this;
        }

        public int build() {
            return this.hashcode;
        }
    }

    @FunctionalInterface
    public static interface Calculator {
        public void calculateHash(Builder var1);
    }

    public static class Cache {
        private boolean calculated;
        private int hashcode;

        public int getHashCode(Calculator calculator) {
            if (this.calculated) {
                return this.hashcode;
            }
            Builder builder = new Builder();
            calculator.calculateHash(builder);
            this.calculated = true;
            this.hashcode = builder.hashcode;
            return this.hashcode;
        }
    }
}

