/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.bind2.Bind2ModuleDescriptor;
import org.jivesoftware.smack.compress.provider.CompressedProvider;
import org.jivesoftware.smack.compress.provider.FailureProvider;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.compression.Java7ZlibInputOutputStream;
import org.jivesoftware.smack.compression.XmppCompressionManager;
import org.jivesoftware.smack.compression.zlib.ZlibXmppCompressionFactory;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.isr.InstantStreamResumptionModuleDescriptor;
import org.jivesoftware.smack.provider.BindIQProvider;
import org.jivesoftware.smack.provider.BodyElementProvider;
import org.jivesoftware.smack.provider.MessageSubjectElementProvider;
import org.jivesoftware.smack.provider.MessageThreadElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.provider.SaslChallengeProvider;
import org.jivesoftware.smack.provider.SaslFailureProvider;
import org.jivesoftware.smack.provider.SaslSuccessProvider;
import org.jivesoftware.smack.provider.TlsFailureProvider;
import org.jivesoftware.smack.provider.TlsProceedProvider;
import org.jivesoftware.smack.sasl.core.SASLAnonymous;
import org.jivesoftware.smack.sasl.core.SASLXOauth2Mechanism;
import org.jivesoftware.smack.sasl.core.SCRAMSHA1Mechanism;
import org.jivesoftware.smack.sasl.core.ScramSha1PlusMechanism;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public final class SmackInitialization {
    static final String SMACK_VERSION;
    private static final String DEFAULT_CONFIG_FILE = "org.jivesoftware.smack/smack-config.xml";
    private static final Logger LOGGER;

    public static void processConfigFile(InputStream inputStream, Collection<Exception> collection) {
        SmackInitialization.processConfigFile(inputStream, collection, SmackInitialization.class.getClassLoader());
    }

    public static void processConfigFile(InputStream inputStream, Collection<Exception> collection, ClassLoader classLoader) {
        XmlPullParser xmlPullParser = PacketParserUtils.getParserFor(inputStream);
        XmlPullParser.Event event = xmlPullParser.getEventType();
        do {
            if (event != XmlPullParser.Event.START_ELEMENT) continue;
            if (xmlPullParser.getName().equals("startupClasses")) {
                SmackInitialization.parseClassesToLoad(xmlPullParser, false, collection, classLoader);
                continue;
            }
            if (!xmlPullParser.getName().equals("optionalStartupClasses")) continue;
            SmackInitialization.parseClassesToLoad(xmlPullParser, true, collection, classLoader);
        } while ((event = xmlPullParser.next()) != XmlPullParser.Event.END_DOCUMENT);
        CloseableUtil.maybeClose(inputStream, LOGGER);
    }

    private static void parseClassesToLoad(XmlPullParser xmlPullParser, boolean bl, Collection<Exception> collection, ClassLoader classLoader) {
        XmlPullParser.Event event;
        String string = xmlPullParser.getName();
        do {
            String string2;
            if ((event = xmlPullParser.next()) != XmlPullParser.Event.START_ELEMENT || !"className".equals(xmlPullParser.getName()) || SmackConfiguration.isDisabledSmackClass(string2 = xmlPullParser.nextText())) continue;
            try {
                SmackInitialization.loadSmackClass(string2, bl, classLoader);
            }
            catch (Exception exception) {
                if (collection != null) {
                    collection.add(exception);
                    continue;
                }
                throw exception;
            }
        } while (event != XmlPullParser.Event.END_ELEMENT || !string.equals(xmlPullParser.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadSmackClass(String iterator, boolean bl, ClassLoader object) {
        try {
            object = Class.forName(iterator, true, (ClassLoader)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Level level = bl ? Level.FINE : Level.WARNING;
            LOGGER.log(level, "A startup class '" + iterator + "' could not be loaded.");
            if (bl) return;
            throw classNotFoundException;
        }
        if (!SmackInitializer.class.isAssignableFrom((Class<?>)object)) {
            LOGGER.log(Level.FINE, "Loaded " + iterator);
            return;
        }
        List<Exception> list = (object = (SmackInitializer)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0])).initialize();
        if (list == null || list.size() == 0) {
            LOGGER.log(Level.FINE, "Loaded SmackInitializer " + iterator);
            return;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Exception exception = iterator.next();
            LOGGER.log(Level.SEVERE, "Exception in loadSmackClass", exception);
        }
    }

    static {
        Object object;
        LOGGER = Logger.getLogger(SmackInitialization.class.getName());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(FileUtils.getStreamForClasspathFile("org.jivesoftware.smack/version", null), StandardCharsets.UTF_8));
            object = bufferedReader.readLine();
        }
        catch (Exception exception) {
            try {
                LOGGER.log(Level.SEVERE, "Could not determine Smack version", exception);
                object = "unknown";
            }
            catch (Throwable throwable) {
                CloseableUtil.maybeClose(bufferedReader, LOGGER);
                throw throwable;
            }
            CloseableUtil.maybeClose(bufferedReader, LOGGER);
        }
        CloseableUtil.maybeClose(bufferedReader, LOGGER);
        SMACK_VERSION = object;
        object = System.getProperty("smack.disabledClasses");
        if (object != null) {
            String[] stringArray = object.split(",");
            object = stringArray;
            object = stringArray;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string = object[j];
                SmackConfiguration.disabledSmackClasses.add(string);
            }
        }
        try {
            object = FileUtils.getStreamForClasspathFile(DEFAULT_CONFIG_FILE, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not load Smack configuration file", exception);
        }
        try {
            SmackInitialization.processConfigFile((InputStream)object, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not parse Smack configuration file", exception);
        }
        SmackConfiguration.addCompressionHandler(new Java7ZlibInputOutputStream());
        XmppCompressionManager.registerXmppCompressionFactory(ZlibXmppCompressionFactory.INSTANCE);
        try {
            if (Boolean.getBoolean("smack.debugEnabled")) {
                SmackConfiguration.DEBUG = true;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Could not handle debugEnable property on Smack initialization", exception);
        }
        SASLAuthentication.registerSASLMechanism(new SCRAMSHA1Mechanism());
        SASLAuthentication.registerSASLMechanism(new ScramSha1PlusMechanism());
        SASLAuthentication.registerSASLMechanism(new SASLXOauth2Mechanism());
        SASLAuthentication.registerSASLMechanism(new SASLAnonymous());
        ProviderManager.addIQProvider("bind", "urn:ietf:params:xml:ns:xmpp-bind", new BindIQProvider());
        ProviderManager.addExtensionProvider("body", "jabber:client", new BodyElementProvider());
        ProviderManager.addExtensionProvider("thread", "jabber:client", new MessageThreadElementProvider());
        ProviderManager.addExtensionProvider("subject", "jabber:client", new MessageSubjectElementProvider());
        ProviderManager.addNonzaProvider(SaslChallengeProvider.INSTANCE);
        ProviderManager.addNonzaProvider(SaslSuccessProvider.INSTANCE);
        ProviderManager.addNonzaProvider(SaslFailureProvider.INSTANCE);
        ProviderManager.addNonzaProvider(TlsProceedProvider.INSTANCE);
        ProviderManager.addNonzaProvider(TlsFailureProvider.INSTANCE);
        ProviderManager.addNonzaProvider(CompressedProvider.INSTANCE);
        ProviderManager.addNonzaProvider(FailureProvider.INSTANCE);
        SmackConfiguration.addModule(Bind2ModuleDescriptor.class);
        SmackConfiguration.addModule(CompressionModuleDescriptor.class);
        SmackConfiguration.addModule(InstantStreamResumptionModuleDescriptor.class);
        SmackConfiguration.smackInitialized = true;
    }
}

