/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter.jidtype;

import org.e.a.i;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;

public abstract class AbstractJidTypeFilter
implements StanzaFilter {
    private final JidType jidType;

    protected AbstractJidTypeFilter(JidType jidType) {
        this.jidType = Objects.requireNonNull(jidType, "jidType must not be null");
    }

    @Override
    public boolean accept(Stanza stanza) {
        if ((stanza = this.getJidToMatchFrom(stanza)) == null) {
            return false;
        }
        return this.jidType.isTypeOf((i)stanza);
    }

    protected abstract i getJidToMatchFrom(Stanza var1);

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + (Object)((Object)this.jidType);
    }

    public static enum JidType {
        BareJid,
        DomainBareJid,
        DomainFullJid,
        DomainJid,
        EntityBareJid,
        EntityFullJid,
        EntityJid,
        FullJid;


        public final boolean isTypeOf(i i2) {
            if (i2 == null) {
                return false;
            }
            switch (this) {
                case BareJid: {
                    return i2.k();
                }
                case DomainBareJid: {
                    return i2.i();
                }
                case DomainFullJid: {
                    return i2.j();
                }
                case EntityBareJid: {
                    return i2.g();
                }
                case EntityFullJid: {
                    return i2.h();
                }
                case EntityJid: {
                    return i2.f();
                }
                case FullJid: {
                    return i2.l();
                }
            }
            throw new IllegalStateException();
        }
    }
}

