/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket.internals;

import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilderExtensions_jvmKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.a;
import kotlinx.b.q;
import kotlinx.b.t;
import kotlinx.b.v;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a+\u0010\u000f\u001a\u00020\u000e*\u00020\b2\u0006\u0010\t\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Ljava/util/zip/Deflater;", "", "data", "deflateFully", "(Ljava/util/zip/Deflater;[B)[B", "Ljava/util/zip/Inflater;", "inflateFully", "(Ljava/util/zip/Inflater;[B)[B", "Lkotlinx/io/Sink;", "deflater", "Ljava/nio/ByteBuffer;", "buffer", "", "flush", "", "deflateTo", "(Lkotlinx/io/Sink;Ljava/util/zip/Deflater;Ljava/nio/ByteBuffer;Z)I", "PADDED_EMPTY_CHUNK", "[B", "EMPTY_CHUNK", "ktor-websockets"})
public final class DeflaterUtilsKt {
    private static final byte[] PADDED_EMPTY_CHUNK;
    private static final byte[] EMPTY_CHUNK;

    public static final byte[] deflateFully(Deflater deflater, byte[] object) {
        Intrinsics.checkNotNullParameter((Object)deflater, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        deflater.setInput((byte[])object);
        a a2 = new a();
        object = a2;
        q q2 = (q)a2;
        ObjectPool objectPool = ByteBufferPoolKt.getKtorDefaultPool();
        Object object2 = objectPool.borrow();
        try {
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            while (!deflater.needsInput()) {
                DeflaterUtilsKt.deflateTo(q2, deflater, byteBuffer, false);
            }
            while (DeflaterUtilsKt.deflateTo(q2, deflater, byteBuffer, true) != 0) {
            }
        }
        finally {
            objectPool.recycle(object2);
        }
        deflater = (t)object;
        if (BytePacketUtilsKt.endsWith((t)deflater, PADDED_EMPTY_CHUNK)) {
            Deflater deflater2 = deflater;
            object = v.a((t)deflater2, (int)((int)ByteReadPacketKt.getRemaining((t)deflater2) - EMPTY_CHUNK.length));
            deflater.close();
            return object;
        }
        a a3 = new a();
        object = a3;
        q2 = (q)a3;
        BytePacketBuilderKt.writePacket((q)q2, (t)deflater);
        q2.a((byte)0);
        return v.a((t)((t)object));
    }

    public static final byte[] inflateFully(Inflater inflater, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        byArray = ArraysKt.plus((byte[])byArray, (byte[])EMPTY_CHUNK);
        inflater.setInput(byArray);
        a a2 = new a();
        q q2 = (q)a2;
        ObjectPool objectPool = ByteBufferPoolKt.getKtorDefaultPool();
        Object object = objectPool.borrow();
        try {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            long l2 = (long)byArray.length + inflater.getBytesRead();
            while (inflater.getBytesRead() < l2) {
                byteBuffer.clear();
                int n2 = inflater.inflate(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n2);
                byteBuffer.flip();
                BytePacketBuilderExtensions_jvmKt.writeFully((q)q2, (ByteBuffer)byteBuffer);
            }
        }
        finally {
            objectPool.recycle(object);
        }
        inflater = (t)a2;
        return v.a((t)inflater);
    }

    private static final int deflateTo(q q2, Deflater deflater, ByteBuffer byteBuffer, boolean bl) {
        byteBuffer.clear();
        int n2 = bl ? deflater.deflate(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit(), 2) : deflater.deflate(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.position(byteBuffer2.position() + n2);
        byteBuffer.flip();
        BytePacketBuilderExtensions_jvmKt.writeFully((q)q2, (ByteBuffer)byteBuffer);
        return n2;
    }

    static {
        byte[] byArray = new byte[5];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = -1;
        byArray2[4] = -1;
        PADDED_EMPTY_CHUNK = byArray2;
        byte[] byArray3 = new byte[4];
        byArray2 = byArray3;
        byArray3[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = -1;
        byArray2[3] = -1;
        EMPTY_CHUNK = byArray2;
    }
}

