/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\nH\u0016J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0014J\u0014\u0010*\u001a\u00020\n2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0016J\u0006\u0010-\u001a\u00020\nJ\u0006\u0010.\u001a\u00020\nJ\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u00100\u001a\u00020\n*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u00101\u001a\u00020)H\u0014R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u00063"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "fullVersion", "", "getFullVersion$exposed_core", "()Ljava/lang/String;", "fullVersion$delegate", "Lkotlin/Lazy;", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "supportsCreateSequence", "getSupportsCreateSequence", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "fillConstraintCacheForTables", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "setSchema", "metadataMatchesTable", "table", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final Lazy isMysql8$delegate = LazyKt.lazy((Function0)isMysql8.2.INSTANCE);
    private final Lazy fullVersion$delegate = LazyKt.lazy((Function0)fullVersion.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    public final String getFullVersion$exposed_core() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    public final boolean isTimeZoneOffsetSupported() {
        return !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) && this.isMysql8$exposed_core();
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        if (super.isAllowedAsColumnDefault(expression)) {
            return true;
        }
        Object[] objectArray = new String[5];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "CURRENT_TIMESTAMP";
        objectArray2[1] = "CURRENT_TIMESTAMP()";
        objectArray2[2] = "NOW()";
        objectArray2[3] = "CURRENT_TIMESTAMP(6)";
        objectArray2[4] = "NOW(6)";
        return ArraysKt.contains((Object[])objectArray2, (Object)((Object)StringsKt.trim((CharSequence)expression.toString())).toString()) && this.isFractionDateTimeSupported();
    }

    @Override
    protected void fillConstraintCacheForTables(List<? extends Table> object) {
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Set<String> set = (Set<String>)((Object)SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)object));
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)set, (int)10)), (int)16);
        Object object4 = set;
        HashMap<String, Map<String, ForeignKeyConstraint>> hashMap = new LinkedHashMap(n);
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            object4 = object5.next();
            object3 = (Table)object4;
            object2 = hashMap;
            object2.put(((Table)object3).nameInDatabaseCaseUnquoted(), object4);
        }
        object5 = hashMap;
        set = object5.keySet();
        String string = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"','", (CharSequence)" ku.TABLE_NAME IN ('", (CharSequence)"')", (int)0, null, null, (int)56, null);
        Transaction transaction2 = TransactionManager.Companion.current();
        object = (Iterable)object;
        object2 = new StringBuilder("'");
        object4 = object;
        object3 = new ArrayList();
        object = object4;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            object4 = e;
            object4 = e;
            object4 = (Table)e;
            String string2 = ((Table)object4).getSchemaName();
            if (string2 == null) continue;
            object4 = string2;
            object3.add(object4);
        }
        String string3 = (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)object3)));
        if (string3 == null) {
            string3 = this.getDatabase();
        }
        object4 = ((StringBuilder)object2).append(string3).append('\'').toString();
        hashMap = new HashMap<String, Map<String, ForeignKeyConstraint>>();
        Transaction.exec$default(transaction2, StringsKt.trimIndent((String)("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + (String)object4 + "\n                  AND ku.CONSTRAINT_SCHEMA = " + (String)object4 + "\n                  AND rc.CONSTRAINT_SCHEMA = " + (String)object4 + "\n                  AND " + string + "\n                ORDER BY ku.ORDINAL_POSITION\n            ")), null, null, (Function1)new Function1<ResultSet, Unit>(set, this, transaction2, (Map<String, ? extends Table>)object5, hashMap){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, Map<String, ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = set;
                this.this$0 = mysqlDialect;
                this.$tr = transaction2;
                this.$allTables = map;
                this.$constraintsToLoad = hashMap;
                super(1);
            }

            public final void invoke(ResultSet object) {
                Iterator<T> iterator2;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                while (object.next()) {
                    Object object10;
                    Column<Object> column;
                    block7: {
                        Object v1;
                        block6: {
                            Intrinsics.checkNotNull((Object)object.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(object9)) continue;
                            String string = object.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull((Object)string);
                            object8 = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, this.$tr);
                            object7 = ((ColumnSet)((Table)MapsKt.getValue(this.$allTables, (Object)object9))).getColumns();
                            object6 = this.this$0;
                            object5 = this.$tr;
                            object4 = object7.iterator();
                            while (object4.hasNext()) {
                                object3 = object4.next();
                                object2 = (Column)object3;
                                if (!Intrinsics.areEqual((Object)((VendorDialect)object6).quoteIdentifierWhenWrongCaseOrNecessary(((Column)object2).nameInDatabaseCase(), (Transaction)object5), (Object)object8)) continue;
                                v1 = object3;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((object8 = (Column)v1) == null) continue;
                        object7 = object8;
                        object6 = this.this$0;
                        object5 = this.$tr;
                        object8 = this.$allTables;
                        object4 = this.$constraintsToLoad;
                        object3 = object7;
                        Intrinsics.checkNotNull((Object)object.getString("CONSTRAINT_NAME"));
                        String string = object.getString("REFERENCED_TABLE_NAME");
                        Intrinsics.checkNotNull((Object)string);
                        object7 = string;
                        String string2 = object.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull((Object)string2);
                        object2 = ((VendorDialect)object6).quoteIdentifierWhenWrongCaseOrNecessary(string2, (Transaction)object5);
                        object8 = ((ColumnSet)((Table)MapsKt.getValue(object8, (Object)object7))).getColumns();
                        object7 = object8.iterator();
                        while (object7.hasNext()) {
                            object8 = object7.next();
                            column = (Column)object8;
                            if (!Intrinsics.areEqual((Object)((VendorDialect)object6).quoteIdentifierWhenWrongCaseOrNecessary(column.nameInDatabaseCase(), (Transaction)object5), (Object)object2)) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    object2 = (Column)object8;
                    String string = object.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull((Object)string);
                    object8 = ReferenceOption.valueOf(StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    String string3 = object.getString("DELETE_RULE");
                    Intrinsics.checkNotNull((Object)string3);
                    object6 = ReferenceOption.valueOf(StringsKt.replace$default((String)string3, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    object7 = (Map)object4;
                    column = object7.get(object9);
                    if (column == null) {
                        object5 = new LinkedHashMap<K, V>();
                        object7.put(object9, object5);
                        object10 = object5;
                    } else {
                        object10 = column;
                    }
                    ((Map)object10).merge(iterator2, new ForeignKeyConstraint((Column<?>)object2, (Column<?>)object3, (ReferenceOption)((Object)object8), (ReferenceOption)((Object)object6), (String)((Object)iterator2)), (arg_0, arg_1) -> fillConstraintCacheForTables.1.invoke$lambda$4$lambda$3(fillConstraintCacheForTables.2.2.INSTANCE, arg_0, arg_1));
                }
                object9 = this.$constraintsToLoad;
                object = this.this$0.getColumnConstraintsCache();
                object8 = object9;
                object7 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)object9.size()));
                object5 = object8.entrySet();
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    object2 = (Map.Entry)object3;
                    iterator2 = object7;
                    object2 = (Map.Entry)object3;
                    object8 = object2.getKey();
                    object9 = iterator2;
                    object6 = (Map)object2.getValue();
                    object6 = object6.values();
                    object9.put(object8, object6);
                }
                object.putAll(object7);
            }

            private static final ForeignKeyConstraint invoke$lambda$4$lambda$3(Function2 function2, Object object, Object object2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"");
                return (ForeignKeyConstraint)function2.invoke(object, object2);
            }
        }, 6, null);
    }

    @Override
    public String createIndex(Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, (Function1)createIndex.1.INSTANCE, (int)31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(string) + " DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(string2);
    }

    @Override
    public String setSchema(Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "USE " + schema.getIdentifier();
    }

    @Override
    public String createSchema(Schema schema) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        String[] stringArray2 = stringArray = new StringBuilder();
        String[] stringArray3 = new String[2];
        stringArray2 = stringArray3;
        stringArray3[0] = "CREATE SCHEMA IF NOT EXISTS ";
        stringArray2[1] = schema.getIdentifier();
        StringsKt.append((StringBuilder)stringArray, (String[])stringArray2);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        String string = stringArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String dropSchema(Schema schema, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Override
    protected boolean metadataMatchesTable(String string, String string2, Table object) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (((CharSequence)string2).length() == 0) {
            return Intrinsics.areEqual((Object)string, (Object)((Table)object).nameInDatabaseCaseUnquoted());
        }
        object = StringsKt.replace$default((String)((Table)object).getTableNameWithoutScheme$exposed_core(), (String)"`", (String)"", (boolean)false, (int)4, null);
        string2 = DatabaseDialectKt.inProperCase(string2 + '.' + (String)object);
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

