/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelId;

final class Http2StreamChannelId
implements ChannelId {
    private static final long serialVersionUID = -6642338822166867585L;
    private final int id;
    private final ChannelId parentId;

    Http2StreamChannelId(ChannelId channelId, int n) {
        this.parentId = channelId;
        this.id = n;
    }

    public final String asShortText() {
        return this.parentId.asShortText() + '/' + this.id;
    }

    public final String asLongText() {
        return this.parentId.asLongText() + '/' + this.id;
    }

    public final int compareTo(ChannelId channelId) {
        if (channelId instanceof Http2StreamChannelId) {
            channelId = (Http2StreamChannelId)channelId;
            int n = this.parentId.compareTo((Object)channelId.parentId);
            if (n == 0) {
                return this.id - channelId.id;
            }
            return n;
        }
        return this.parentId.compareTo((Object)channelId);
    }

    public final int hashCode() {
        return this.id * 31 + this.parentId.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Http2StreamChannelId)) {
            return false;
        }
        object = (Http2StreamChannelId)object;
        return this.id == ((Http2StreamChannelId)object).id && this.parentId.equals(((Http2StreamChannelId)object).parentId);
    }

    public final String toString() {
        return this.asShortText();
    }
}

