/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;

final class ComposedLastHttpContent
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;
    private DecoderResult result;

    ComposedLastHttpContent(HttpHeaders httpHeaders) {
        this.trailingHeaders = httpHeaders;
    }

    ComposedLastHttpContent(HttpHeaders httpHeaders, DecoderResult decoderResult) {
        this(httpHeaders);
        this.result = decoderResult;
    }

    @Override
    public final HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public final LastHttpContent copy() {
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.trailingHeaders().set(this.trailingHeaders());
        return defaultLastHttpContent;
    }

    @Override
    public final LastHttpContent duplicate() {
        return this.copy();
    }

    @Override
    public final LastHttpContent retainedDuplicate() {
        return this.copy();
    }

    @Override
    public final LastHttpContent replace(ByteBuf object) {
        object = new DefaultLastHttpContent((ByteBuf)object);
        object.trailingHeaders().setAll(this.trailingHeaders());
        return object;
    }

    @Override
    public final LastHttpContent retain(int n) {
        return this;
    }

    @Override
    public final LastHttpContent retain() {
        return this;
    }

    @Override
    public final LastHttpContent touch() {
        return this;
    }

    @Override
    public final LastHttpContent touch(Object object) {
        return this;
    }

    public final ByteBuf content() {
        return Unpooled.EMPTY_BUFFER;
    }

    public final DecoderResult decoderResult() {
        return this.result;
    }

    @Override
    public final DecoderResult getDecoderResult() {
        return this.decoderResult();
    }

    public final void setDecoderResult(DecoderResult decoderResult) {
        this.result = decoderResult;
    }

    public final int refCnt() {
        return 1;
    }

    public final boolean release() {
        return false;
    }

    public final boolean release(int n) {
        return false;
    }
}

